/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.platform.msg;

import com.fr.base.platform.msg.Message;
import com.fr.base.platform.msg.MessageDataAccessObject;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHelper {
    private static Map<String, MessageDataAccessObject> map = new ConcurrentHashMap<String, MessageDataAccessObject>();

    public static int getMessageDataAccessObjectCount() {
        return map.size();
    }

    public static void registerMessageDataAccessObject(String string, MessageDataAccessObject messageDataAccessObject) {
        map.put(string, messageDataAccessObject);
    }

    public static MessageDataAccessObject getMessageDataAccessObject(String string) {
        return map.get(string);
    }

    public static long save(String string, Message message) throws Exception {
        return MessageHelper.getMessageDataAccessObject(string).save(message);
    }

    public static void updateToasted(String string, long l2) throws Exception {
        MessageHelper.getMessageDataAccessObject(string).updateToasted(l2);
    }

    public static void updateReaded(String string, long l2) throws Exception {
        MessageHelper.getMessageDataAccessObject(string).updateReaded(l2);
    }

    public static Message findByID(String string, long l2) throws Exception {
        return MessageHelper.getMessageDataAccessObject(string).findByID(l2);
    }

    public static boolean deleteByID(String string, long l2) throws Exception {
        return MessageHelper.getMessageDataAccessObject(string).deleteByID(l2);
    }

    public static void deleteAll(long l2) throws Exception {
        for (String string : map.keySet()) {
            MessageDataAccessObject messageDataAccessObject = MessageHelper.getMessageDataAccessObject(string);
            if (messageDataAccessObject == null) continue;
            messageDataAccessObject.deleteByID(l2);
        }
    }

    public static List<Message> getMessages(String string) throws Exception {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (String string2 : map.keySet()) {
            MessageDataAccessObject messageDataAccessObject = MessageHelper.getMessageDataAccessObject(string2);
            if (messageDataAccessObject == null) continue;
            arrayList.addAll(messageDataAccessObject.getMessages(string));
        }
        return arrayList;
    }

    public static List<Message> getMessagesSortByDate(String string, JSONArray jSONArray) throws Exception {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        if (jSONArray.length() > 0) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                MessageDataAccessObject messageDataAccessObject = MessageHelper.getMessageDataAccessObject(jSONArray.getString(i2));
                if (messageDataAccessObject == null) continue;
                arrayList.addAll(messageDataAccessObject.getMessagesSortByDate(string));
            }
            return arrayList;
        }
        for (String string2 : map.keySet()) {
            MessageDataAccessObject messageDataAccessObject = MessageHelper.getMessageDataAccessObject(string2);
            if (messageDataAccessObject == null) continue;
            arrayList.addAll(messageDataAccessObject.getMessagesSortByDate(string));
        }
        return arrayList;
    }

    public static List<Message> getFreshMessages(String string) throws Exception {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (String string2 : map.keySet()) {
            MessageDataAccessObject messageDataAccessObject = MessageHelper.getMessageDataAccessObject(string2);
            if (messageDataAccessObject == null) continue;
            arrayList.addAll(messageDataAccessObject.getFreshMessages(string));
        }
        return arrayList;
    }

    public static JSONObject getMessageJSONObject(String string, JSONArray jSONArray, String string2) throws Exception {
        List<Message> list = MessageHelper.getFilterMessages(MessageHelper.getMessagesSortByDate(string, jSONArray), string2);
        List<Message> list2 = MessageHelper.getFreshMessages(string);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray2 = new JSONArray();
        for (Message object : list) {
            jSONArray2.put(object.createJSONObject());
        }
        jSONObject.put("toasted", jSONArray2);
        JSONArray jSONArray3 = new JSONArray();
        for (Message message : list2) {
            jSONArray3.put(message.createJSONObject());
        }
        jSONObject.put("fresh", jSONArray3);
        return jSONObject;
    }

    public static List<Message> getFilterMessages(List<Message> list, String string) throws Exception {
        ArrayList<Message> arrayList = new ArrayList();
        if (StringUtils.isEmpty(string)) {
            arrayList = list;
        } else {
            for (Message message : list) {
                if (!MessageHelper.isKeywordInMessages(message.createJSONObject(), string)) continue;
                arrayList.add(message);
            }
        }
        return arrayList;
    }

    public static boolean isKeywordInMessages(JSONObject jSONObject, String string) {
        return jSONObject.optString("message", "").toLowerCase().contains(string.toLowerCase());
    }
}

