/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.Parameter;
import com.fr.data.core.Compare;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorUtils;
import com.fr.third.antlr.ANTLRException;
import java.util.ArrayList;
import java.util.Arrays;

public class BaseScriptUtils {
    public static String[] getDependenceByCompare(Compare compare) {
        Object object = compare.getValue();
        if (object instanceof FormulaProvider) {
            return BaseScriptUtils.getDependenceByFormula(((FormulaProvider)object).getContent());
        }
        if (object instanceof ParameterProvider) {
            return new String[]{((ParameterProvider)object).getName()};
        }
        return new String[0];
    }

    public static String[] getDependenceByFormula(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ColumnRow[] columnRowArray = CalculatorUtils.relatedColumnRowArray(string);
            for (int i2 = 0; i2 < columnRowArray.length; ++i2) {
                arrayList.add(columnRowArray[i2].toString());
            }
            String[] stringArray = Calculator.relatedParameters(string);
            arrayList.addAll(Arrays.asList(stringArray));
        }
        catch (ANTLRException aNTLRException) {
            FRLogger.getLogger().error(aNTLRException.getMessage(), aNTLRException);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getDependenceByParameter(Parameter[] parameterArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < parameterArray.length; ++i2) {
            arrayList.add(parameterArray[i2].getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

