/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class IntervalDF
extends Interval {
    protected long seconds;
    protected long nanos;
    protected static final int NanosPerSecond = 1000000000;
    protected static final int MilliPerSecond = 1000;
    protected static final int SecondsPerMinute = 60;
    protected static final int SecondsPerHour = 3600;
    protected static final int SecondsPerDay = 86400;

    public IntervalDF() throws SQLException {
        this.setQualifier((byte)4, (byte)15);
    }

    public IntervalDF(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(timestamp, timestamp2);
    }

    public IntervalDF(long l, long l2) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(l, l2);
    }

    public IntervalDF(long l, long l2, short s) throws SQLException {
        this.setQualifier(s);
        this.set(l, l2);
    }

    public IntervalDF(String string) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(string);
    }

    public IntervalDF(String string, short s) throws SQLException {
        this.setQualifier(s);
        this.set(string);
    }

    public IntervalDF(String string, int n, byte by, byte by2) throws SQLException {
        this.setQualifier((byte)n, by, by2);
        this.set(string);
    }

    public void set(Timestamp timestamp, Timestamp timestamp2) {
        long l = ((Date)timestamp).getTime() / 1000L;
        long l2 = ((Date)timestamp2).getTime() / 1000L;
        long l3 = l - l2;
        long l4 = timestamp.getNanos() - timestamp2.getNanos();
        this.set(l3, l4);
    }

    public void set(long l, long l2) {
        if (l < 0L) {
            if (l2 > 0L) {
                ++l;
                l2 -= 1000000000L;
            }
        } else if (l2 < 0L && l > 0L) {
            --l;
            l2 += 1000000000L;
        }
        this.seconds = l;
        this.nanos = l2;
    }

    public void set(String string) throws SQLException {
        if (string == null) {
            return;
        }
        this.fromString(string);
    }

    public String toString() {
        int n;
        String string;
        long l = this.seconds;
        long l2 = this.nanos;
        StringBuffer stringBuffer = new StringBuffer();
        short s = this.getQualifier();
        int n2 = Interval.getEndCode(s);
        byte by = Interval.getStartCode(s);
        String string2 = "IntervalDF.toString() secs = " + l + " nans = " + l2 + " start = " + by + " end = " + n2;
        if (Interval.debugFlag) {
            System.out.println(string2);
        }
        boolean bl = false;
        if (this.seconds < 0L || this.seconds == 0L && this.nanos < 0L) {
            bl = true;
            l = -this.seconds;
            l2 = -l2;
        }
        if (by == 4) {
            long l3 = l / 86400L;
            l %= 86400L;
            stringBuffer.append(l3);
            if (n2 > 4) {
                stringBuffer.append(Interval.dtdelim[2]);
            }
            string = "After processing Days: " + stringBuffer;
            if (Interval.debugFlag) {
                System.out.println(string);
            }
        }
        if (by <= 6 && n2 >= 6) {
            long l4 = l / 3600L;
            l %= 3600L;
            if (l4 < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l4);
            if (n2 > 6) {
                stringBuffer.append(Interval.dtdelim[3]);
            }
            string = "After processing Hours: " + stringBuffer;
            if (Interval.debugFlag) {
                System.out.println(string);
            }
        }
        if (by <= 8 && n2 >= 8) {
            long l5 = l / 60L;
            l %= 60L;
            if (l5 < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l5);
            if (n2 > 8) {
                stringBuffer.append(Interval.dtdelim[4]);
            }
            string = "After processing Minutes: " + stringBuffer;
            if (Interval.debugFlag) {
                System.out.println(string);
            }
        }
        if (by <= 10 && n2 >= 10) {
            if (l < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l);
            string = "After processing Seconds: " + stringBuffer;
            if (Interval.debugFlag) {
                System.out.println(string);
            }
        }
        if (n2 > 10) {
            int n3;
            stringBuffer.append(Interval.dtdelim[5]);
            if (l2 == 0L) {
                n3 = 11;
                while (n3 <= n2) {
                    stringBuffer.append('0');
                    ++n3;
                }
            } else {
                n3 = n2 - 10;
                n = 0;
                int n4 = 11;
                long l6 = 100000000L;
                while (n4 <= n2 && l2 != 0L) {
                    if (l2 < l6) {
                        stringBuffer.append('0');
                        ++n;
                    } else {
                        stringBuffer.append((long)((int)l2) / l6);
                        ++n;
                        l2 %= l6;
                    }
                    l6 /= 10L;
                    ++n4;
                }
                n4 = n;
                while (n4 < n3) {
                    stringBuffer.append('0');
                    ++n4;
                }
            }
            string = "After processing Fractions: " + stringBuffer;
            if (Interval.debugFlag) {
                System.out.println(string);
            }
        }
        string = "IntervalDF.toString no strip |" + stringBuffer.toString();
        if (Interval.debugFlag) {
            System.out.println(string);
        }
        int n5 = 0;
        n = stringBuffer.length() - 1;
        while (n5 < n && stringBuffer.charAt(n5) == '0' && Character.isDigit(stringBuffer.charAt(n5 + 1))) {
            stringBuffer.setCharAt(n5, ' ');
            ++n5;
        }
        if (bl) {
            stringBuffer.insert(n5, '-');
        }
        String string3 = "IntervalDF.toString return |" + stringBuffer.toString();
        if (Interval.debugFlag) {
            System.out.println(string3);
        }
        return stringBuffer.toString();
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            return;
        }
        short s = this.getQualifier();
        string = string.trim();
        boolean bl = false;
        if (string.length() > 0 && string.charAt(0) == '-') {
            if (string.length() == 1) {
                throw IfxErrMsg.getSQLException(-79706, null);
            }
            bl = true;
            string = string.substring(1);
        }
        int[] nArray = this.stringToUnits(string, s);
        this.seconds = (long)nArray[2] * 86400L;
        this.seconds += (long)nArray[3] * 3600L;
        this.seconds += (long)nArray[4] * 60L;
        this.seconds += (long)nArray[5];
        this.nanos = nArray[6];
        if (bl) {
            this.seconds = -this.seconds;
            this.nanos = -this.nanos;
        }
        String string2 = "IntervalDF.fromString() seconds = " + this.seconds + " nanos: " + this.nanos;
        if (Interval.debugFlag) {
            System.out.println(string2);
        }
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getNanoSeconds() {
        return this.nanos;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof IntervalDF && object != null) {
            bl = this.seconds == ((IntervalDF)object).getSeconds() && this.nanos == ((IntervalDF)object).getNanoSeconds();
        }
        return bl;
    }

    public boolean greaterThan(IntervalDF intervalDF) {
        boolean bl = false;
        if (intervalDF != null) {
            long l = intervalDF.getSeconds();
            bl = this.seconds > l ? true : this.seconds == l && this.nanos > intervalDF.getNanoSeconds();
        }
        return bl;
    }

    public boolean lessThan(IntervalDF intervalDF) {
        boolean bl = false;
        if (intervalDF != null) {
            long l = intervalDF.getSeconds();
            bl = this.seconds < l ? true : this.seconds == l && this.nanos < intervalDF.getNanoSeconds();
        }
        return bl;
    }

    private void setQualifier(byte by, byte by2) throws SQLException {
        byte by3 = (byte)(by2 - by + (by == 0 ? 4 : 2));
        this.int_qual = (short)(by3 << 8 | by << 4 | by2);
    }

    public void setQualifier(byte by, byte by2, byte by3) throws SQLException {
        String string = "Interval.setQualifier(" + by + " , " + by2 + " , " + by3 + ")";
        if (Interval.debugFlag) {
            System.out.println(string);
        }
        if (by2 < 4 || by3 < 4 || by2 > by3) {
            throw IfxErrMsg.getSQLException(-79707, null);
        }
        this.int_qual = (short)(by3 - by2 + by << 8 | by2 << 4 | by3);
    }

    public void setQualifier(short s) throws SQLException {
        String string = "Interval.setQualifier(" + Integer.toString(s, 16) + ")";
        if (Interval.debugFlag) {
            System.out.println(string);
        }
        byte by = Interval.getStartCode(s);
        byte by2 = Interval.getEndCode(s);
        if (by < 4 || by2 < 4 || by > by2) {
            throw IfxErrMsg.getSQLException(-79707, null);
        }
        this.int_qual = s;
    }
}

