/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

abstract class IfxLob {
    protected static final short TYPE_IS_BLOB = 2;
    protected static final short TYPE_IS_CLOB = 3;
    protected IfxConnection conn;
    protected boolean isBlob_loaded = false;
    protected IfxTmpFile tempBlobFile;
    protected IfxLocator locatorPointer;
    protected InputStream blobStream;
    protected byte[] blobBuffer;
    protected String BlobFileName;
    protected long blobSize;
    protected short ifxType;

    protected IfxLob() {
    }

    public IfxLocator getLocator() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        return this.locatorPointer;
    }

    protected void setLocator(IfxLocator ifxLocator) {
        this.locatorPointer = ifxLocator;
    }

    protected void setIfxLobType(short s) {
        this.ifxType = s;
    }

    protected void setSize(long l) {
        this.blobSize = l;
    }

    protected void setConnection(IfxConnection ifxConnection) {
        this.conn = ifxConnection;
    }

    protected void setLoadFlag() {
        this.isBlob_loaded = true;
    }

    protected short getIfxLobType() {
        return this.ifxType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getPortion(long l, long l2) {
        int n = (int)l2;
        long l3 = l - 1L;
        if (l3 < 0L || n < 0) {
            return null;
        }
        if (l3 + (long)n > this.blobSize) {
            return null;
        }
        byte[] byArray = new byte[n];
        try {
            if (!this.isBlob_loaded) {
                this.loadSmBlob();
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (this.tempBlobFile != null) {
            FileInputStream fileInputStream;
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                fileInputStream = new FileInputStream(this.tempBlobFile.getFileName());
            }
            catch (Exception exception) {
                return null;
            }
            try {
                if (l3 > 0L) {
                    fileInputStream.skip(l3);
                }
                fileInputStream.read(byArray, 0, n);
                fileInputStream.close();
                if (this.ifxType != 3 && this.ifxType != 2) return byArray;
                this.isBlob_loaded = false;
                this.tempBlobFile.close();
                this.tempBlobFile = null;
                return byArray;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.blobBuffer == null) return null;
        System.arraycopy(this.blobBuffer, (int)l3, byArray, 0, n);
        return byArray;
    }

    protected InputStream getStreamImd() throws SQLException {
        if (!this.isBlob_loaded) {
            this.loadSmBlob();
        }
        return this.getStream();
    }

    protected InputStream getStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream ifxLobInputStream = new IfxLobInputStream(this.conn, this.locatorPointer);
                return ifxLobInputStream;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                IfxInputStream ifxInputStream = new IfxInputStream(this.tempBlobFile);
                return ifxInputStream;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
        return byteArrayInputStream;
    }

    protected void loadSmBlob() throws SQLException {
        FileOutputStream fileOutputStream = null;
        this.tempBlobFile = null;
        this.blobBuffer = null;
        if (this.blobSize == 0L) {
            this.blobBuffer = new byte[0];
            this.tempBlobFile = null;
            return;
        }
        int n = this.conn.getBlobCacheSize();
        if (n < 0 || n > 0 && this.blobSize <= (long)n) {
            try {
                this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79753, this.conn);
            }
            this.tempBlobFile = null;
        } else {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                this.createTempFile();
                fileOutputStream = new FileOutputStream(this.tempBlobFile.getFileName());
                this.blobBuffer = null;
            }
            catch (Exception exception) {
                if (n == 0) {
                    throw IfxErrMsg.getSQLException(-79774, this.conn);
                }
                this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize);
                fileOutputStream = null;
                this.tempBlobFile = null;
            }
        }
        try {
            IfxSmartBlob ifxSmartBlob = new IfxSmartBlob(this.conn);
            int n2 = ifxSmartBlob.IfxLoOpen(this.locatorPointer, 8);
            if (this.blobBuffer == null) {
                ifxSmartBlob.IfxLoRead(n2, fileOutputStream, (int)this.blobSize);
            } else {
                ifxSmartBlob.IfxLoRead(n2, this.blobBuffer, (int)this.blobSize);
            }
            ifxSmartBlob.IfxLoClose(n2);
        }
        catch (Exception exception) {}
        this.isBlob_loaded = true;
    }

    private void createTempFile() throws SQLException {
        String string = String.valueOf(System.currentTimeMillis());
        string = String.valueOf(this.conn.getJDBCTempDir()) + "ifxb_" + string.substring(4);
        this.tempBlobFile = new IfxTmpFile(string);
    }
}

