/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.fop.pdf.PDFObject;

public class PDFArray
extends PDFObject {
    protected List values = new ArrayList();

    public PDFArray() {
    }

    public PDFArray(int[] values) {
        int c = values.length;
        for (int i = 0; i < c; ++i) {
            this.values.add(new Integer(values[i]));
        }
    }

    public PDFArray(Collection values) {
        this.values.addAll(values);
    }

    public PDFArray(Object[] values) {
        int c = values.length;
        for (int i = 0; i < c; ++i) {
            this.values.add(values[i]);
        }
    }

    public int length() {
        return this.values.size();
    }

    public void set(int index, Object obj) {
        this.values.set(index, obj);
    }

    public Object get(int index) {
        return this.values.get(index);
    }

    public void add(Object obj) {
        this.values.add(obj);
    }

    public String toPDFString() {
        StringBuffer p = new StringBuffer(64);
        if (this.hasObjectNumber()) {
            p.append(this.getObjectID());
        }
        p.append("[");
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                p.append(" ");
            }
            Object obj = this.values.get(i);
            this.formatObject(obj, p);
        }
        p.append("]");
        if (this.hasObjectNumber()) {
            p.append("\nendobj\n");
        }
        return p.toString();
    }
}

