/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.utils;

import com.fr.general.IOUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.performance.PerformanceManager;
import com.fr.performance.info.CurrentReportArrayInfo;
import com.fr.performance.info.IReportPerformanceInfo;
import com.fr.performance.info.IRuntimeInfo;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.SessionIDInfor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionIDInfoUtils {
    private static final long MIN_IMAGE_MEMORY = 51200L;

    public static List<SessionIDInfor> getAllSessionInfo() {
        return SessionDealWith.getAllSession();
    }

    public static List<SessionIDInfor> getAllCompleteSessionInfo() {
        List list = SessionDealWith.getAllSession();
        ArrayList<SessionIDInfor> arrayList = new ArrayList<SessionIDInfor>();
        for (SessionIDInfor sessionIDInfor : list) {
            if (!sessionIDInfor.getStatus().isCompleteReport()) continue;
            arrayList.add(sessionIDInfor);
        }
        return arrayList;
    }

    public static List<SessionIDInfor> getOperatingSessionInfo() {
        List list = SessionDealWith.getAllSession();
        ArrayList<SessionIDInfor> arrayList = new ArrayList<SessionIDInfor>();
        for (SessionIDInfor sessionIDInfor : list) {
            if (!sessionIDInfor.getStatus().isOperate()) continue;
            arrayList.add(sessionIDInfor);
        }
        return arrayList;
    }

    public static CurrentReportArrayInfo getCurrentReportInfo() {
        CurrentReportArrayInfo currentReportArrayInfo = new CurrentReportArrayInfo();
        currentReportArrayInfo.setExecutingInfo(SessionIDInfoUtils.getExecutingInfo());
        currentReportArrayInfo.setCompleteInfo(SessionIDInfoUtils.getCompleteInfo());
        currentReportArrayInfo.setImageInfo(SessionIDInfoUtils.getCurrentImageInfo());
        currentReportArrayInfo.setRecordTime(System.currentTimeMillis());
        return currentReportArrayInfo;
    }

    private static JSONArray getCurrentImageInfo() {
        List<Map.Entry<String, Long>> list = SessionIDInfoUtils.getSortImageMemoryList();
        JSONArray jSONArray = new JSONArray();
        for (Map.Entry<String, Long> entry : list) {
            long l = entry.getValue();
            if (l <= 51200L) continue;
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("path", (Object)entry.getKey());
                jSONObject.put("memory", l);
                jSONArray.put((Object)jSONObject);
            }
            catch (JSONException jSONException) {}
        }
        return jSONArray;
    }

    private static List<Map.Entry<String, Long>> getSortImageMemoryList() {
        Map map = IOUtils.getCacheImageMap();
        HashMap hashMap = new HashMap();
        long l = 0L;
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            long l2 = PerformanceManager.getMemoryEstimation().estimateImageMemory((BufferedImage)entry.getValue());
            if (l2 > 51200L) {
                hashMap.put(entry.getKey(), l2);
                continue;
            }
            l += l2;
            ++n;
        }
        hashMap.put("\u5176\u4ed6(\u5171" + n + "\u4e2a)", l);
        ArrayList arrayList = new ArrayList(hashMap.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> entry, Map.Entry<String, Long> entry2) {
                if (entry.getValue() == entry2.getValue()) {
                    return 0;
                }
                return entry.getValue() > entry2.getValue() ? 1 : -1;
            }
        });
        return arrayList;
    }

    private static JSONArray getExecutingInfo() {
        JSONArray jSONArray = new JSONArray();
        List<SessionIDInfor> list = SessionIDInfoUtils.getOperatingSessionInfo();
        for (SessionIDInfor sessionIDInfor : list) {
            try {
                JSONObject jSONObject = new JSONObject();
                IRuntimeInfo iRuntimeInfo = sessionIDInfor.getRuntimeInfo();
                jSONObject.put("para", sessionIDInfor.getParameterMap4Execute());
                jSONObject.put("name", (Object)sessionIDInfor.getBookPath());
                jSONObject.put("time", SessionIDInfoUtils.calculateTime(sessionIDInfor));
                jSONObject.put("memory", SessionIDInfoUtils.calculateMemory(iRuntimeInfo));
                jSONObject.put("status", (Object)sessionIDInfor.getStatus().getDescription());
                jSONArray.put((Object)jSONObject);
            }
            catch (JSONException jSONException) {}
        }
        return jSONArray;
    }

    private static long calculateTime(SessionIDInfor sessionIDInfor) {
        return System.currentTimeMillis() - sessionIDInfor.getStartTime();
    }

    private static long calculateMemory(IRuntimeInfo iRuntimeInfo) {
        return iRuntimeInfo.getMemory();
    }

    private static JSONArray getCompleteInfo() {
        JSONArray jSONArray = new JSONArray();
        List<SessionIDInfor> list = SessionIDInfoUtils.getAllCompleteSessionInfo();
        for (SessionIDInfor sessionIDInfor : list) {
            try {
                JSONObject jSONObject = new JSONObject();
                IReportPerformanceInfo iReportPerformanceInfo = sessionIDInfor.getPerformanceInfo();
                if (iReportPerformanceInfo == null) continue;
                jSONObject.put("name", (Object)sessionIDInfor.getBookPath());
                jSONObject.put("para", sessionIDInfor.getParameterMap4Execute());
                jSONObject.put("id", (Object)sessionIDInfor.getSessionID());
                jSONObject.put("time", iReportPerformanceInfo.getTotalCalculateTime());
                jSONObject.put("memory", iReportPerformanceInfo.getTotalMemory());
                jSONObject.put("status", (Object)"complete");
                jSONArray.put((Object)jSONObject);
            }
            catch (JSONException jSONException) {}
        }
        return jSONArray;
    }
}

