/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.charttypes;

import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.ChartFactory;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.LinePlot;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.fun.impl.AbstractIndependentDefaultChartProviderWithAPILevel;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.stable.web.ServletContextListener;

public class LineIndependentChart
extends AbstractIndependentDefaultChartProviderWithAPILevel {
    public static Chart[] lineChartTypes = LineIndependentChart.initLineCharts();

    private static Chart[] initLineCharts() {
        return new Chart[]{LineIndependentChart.createLineChart()};
    }

    public String getChartName() {
        return "ChartF-Line";
    }

    public Chart[] getChartTypes() {
        return lineChartTypes;
    }

    private static Chart createLineChart() {
        LinePlot linePlot = new LinePlot();
        ConditionCollection conditionCollection = linePlot.getConditionCollection();
        ChartXMLCompatibleUtils.changeAttrNone(conditionCollection, false);
        AttrLineStyle attrLineStyle = conditionCollection.getDefaultAttr().getExisted(AttrLineStyle.class);
        if (attrLineStyle == null) {
            attrLineStyle = new AttrLineStyle();
            conditionCollection.getDefaultAttr().addDataSeriesCondition(attrLineStyle);
        }
        attrLineStyle.setLineStyle(5);
        ChartFactory.setChartFontAttr(linePlot);
        return new Chart(linePlot);
    }

    static {
        ServletContext.addServletContextListener((ServletContextListener)new ServletContextAdapter(){

            public void onServletStart() {
                if (lineChartTypes == null) {
                    lineChartTypes = LineIndependentChart.initLineCharts();
                }
            }

            public void onServletStop() {
                lineChartTypes = null;
            }
        });
    }
}

