/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.TransparentChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class BarTransparentChartStyle
extends TransparentChart {
    private Rectangle2D rect;
    private boolean isHorizontal;
    private boolean axisReversed;

    public BarTransparentChartStyle(Color color, Rectangle2D rectangle2D, boolean bl, boolean bl2, boolean bl3) {
        this.rect = rectangle2D;
        this.isHorizontal = bl;
        this.baseColor = color;
        this.avoidOriginDraw = bl2;
        this.axisReversed = bl3;
    }

    public void paintStyle(Graphics graphics) {
        if (this.baseColor == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        Color color = this.getPaintColor();
        BasicStroke basicStroke = this.getBasicStroke();
        graphics2D.setPaint(color);
        graphics2D.fill(this.rect);
        Color color2 = this.getStrokeColor();
        graphics2D.setPaint(color2);
        graphics2D.setStroke(basicStroke);
        GeneralPath generalPath = this.isHorizontal ? (this.axisReversed ? ChartUtils.getBoundsWithoutRight(this.rect) : ChartUtils.getBoundsWithoutLeft(this.rect)) : (this.axisReversed ? ChartUtils.getBoundsWithoutTop(this.rect) : ChartUtils.getBoundsWithoutBottom(this.rect));
        graphics2D.draw(generalPath);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }
}

