/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.BarPlotGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.Cubic;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Plot3DGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Bar3DPlotGlyph
extends BarPlotGlyph
implements Plot3DGlyph {
    private static final long serialVersionUID = -8494817723580336519L;
    private static final double ZP = 100.0;
    private static final double LABEL_BAR_GAP = 8.0;
    private int deep = -1;
    private int deepBase = -1;
    private boolean horizontalDrawBar = false;
    private Projection projection = new Projection();

    public void setDeep(int n) {
        this.deep = n;
    }

    public int getDeep() {
        return this.deep;
    }

    public void set3DDeepBase(int n) {
        this.deepBase = n;
    }

    public int getDeepBase() {
        return this.deepBase;
    }

    public void setHorizontalDrawBar(boolean bl) {
        this.horizontalDrawBar = bl;
    }

    public boolean isHorizontalDrawBar() {
        return this.horizontalDrawBar;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    protected void resetClip(Graphics2D graphics2D) {
    }

    protected byte[] get3DBaseCover() {
        byte[] byArray;
        if (this.isHorizontal) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 2;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 1;
        }
        return byArray;
    }

    protected boolean is3DBaseHorizontal() {
        return this.isHorizontal;
    }

    public void layoutAxisGlyph(int n) {
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), true, n);
    }

    public void layoutDataSeriesGlyph(int n) {
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            this.dealShape4Bar(this.getSeries(i), this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), this.getSeriesAxisGlyph(i), this.getSeriesSize(), i), n);
        }
        this.dealLabelBoundsInOrder();
    }

    public void dealShape4Bar(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, int n) {
        int n2 = dataSeries.getDataPointCount();
        for (int i = 0; i < n2; ++i) {
            DataPoint dataPoint = dataSeries.getDataPoint(i);
            if (dataPoint.isValueIsNull()) continue;
            Cubic cubic = new Cubic();
            cubic.setIsHorizontal(this.is3DBaseHorizontal());
            cubic.setProjection(this.getProjection());
            if (this.getSeriesSize() == 1) {
                cubic.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
                cubic.dealConditionWithSeriesColor(this.getConditionCollection(), dataPoint, this.createColors4Cate());
            } else {
                cubic.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
            }
            dataPoint.setDrawImpl(cubic);
            Rectangle2D rectangle2D = this.getBarShape(dataSeries, categoryPlotGlyph, i, barDataWithAxisGlyph);
            double d = this.get3DDeep((Plot3DGlyph)((Object)categoryPlotGlyph));
            double d2 = 0.0;
            if (!this.isStacked()) {
                d2 = -(d /= (double)barDataWithAxisGlyph.barNumber) * (double)barDataWithAxisGlyph.barIndex;
            }
            if (categoryPlotGlyph.isNeedDefaultDeep()) {
                d2 = 0.0;
                d = 100.0;
            }
            cubic.setCubic(rectangle2D.getX(), rectangle2D.getY(), d2, rectangle2D.getWidth(), rectangle2D.getHeight(), d);
            this.dealDataPointLabel(dataPoint, n);
        }
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.draw3DInfo(graphics, n);
        this.drawAxisGlyph4ThreeD(this.getyAxisGlyph(), graphics, n);
        this.drawAxisGlyph4ThreeD(this.getSecondAxisGlyph(), graphics, n);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGlyph4ThreeD(this.getxAxisGlyph(), graphics, n);
        if (!this.isStacked()) {
            this.drawWhenUnStacked(graphics2D, n);
        } else {
            this.drawWhenStacked(graphics2D, n);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawWhenUnStacked(Graphics2D graphics2D, int n) {
        int n2;
        if (this.horizontalDrawBar) {
            n2 = this.getCategoryCount();
            int n3 = this.getSeriesSize();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    if (this.getSeries(j) == null || this.getSeries(j).getDataPoint(i) == null) continue;
                    this.getSeries(j).getDataPoint(i).draw(graphics2D, n);
                }
            }
        } else {
            for (n2 = this.getSeriesSize() - 1; n2 >= 0; --n2) {
                if (this.getSeries(n2) == null) continue;
                this.getSeries(n2).draw(graphics2D, n);
            }
        }
        for (n2 = this.getSeriesSize() - 1; n2 >= 0; --n2) {
            if (this.getSeries(n2) == null) continue;
            this.getSeries(n2).drawLabel(graphics2D, n);
        }
    }

    private void drawWhenStacked(Graphics2D graphics2D, int n) {
        int n2;
        int n3 = this.getCategoryCount();
        int n4 = this.getSeriesSize();
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            DataPoint[] dataPointArray = new DataPoint[n4];
            for (n5 = 0; n5 < n4; ++n5) {
                if (this.getSeries(n5) == null) continue;
                dataPointArray[n5] = this.getSeries(n5).getDataPoint(n2);
            }
            for (n5 = 0; n5 < n4; ++n5) {
                for (int i = n4 - 1; i > n5; --i) {
                    if (dataPointArray[i] == null || dataPointArray[i].isValueIsNull() || !(dataPointArray[i].getValue() < 0.0)) continue;
                    DataPoint dataPoint = dataPointArray[i];
                    dataPointArray[i] = dataPointArray[i - 1];
                    dataPointArray[i - 1] = dataPoint;
                }
            }
            for (n5 = 0; n5 < n4; ++n5) {
                if (dataPointArray[n5] == null) continue;
                dataPointArray[n5].draw(graphics2D, n);
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.getSeries(n2) == null) continue;
            this.getSeries(n2).drawLabel(graphics2D, n);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Bar3DPlotGlyph && super.equals(object) && ((Bar3DPlotGlyph)object).deep == this.deep && ComparatorUtils.equals((Object)((Bar3DPlotGlyph)object).projection, (Object)this.projection);
    }

    public Object clone() throws CloneNotSupportedException {
        Bar3DPlotGlyph bar3DPlotGlyph = (Bar3DPlotGlyph)super.clone();
        if (this.projection != null) {
            bar3DPlotGlyph.projection = (Projection)this.projection.clone();
        }
        return bar3DPlotGlyph;
    }

    public Shape getOutline4Fill() {
        if (this.isHorizontal) {
            Point2D point2D = this.threeDBase.getBasePoint();
            double d = this.threeDBase.getWidth();
            double d2 = this.threeDBase.getHeight() - this.getyAxisGlyph().getBounds().getHeight();
            return new Rectangle2D.Double(point2D.getX(), point2D.getY(), d, d2);
        }
        return super.getOutline4Fill();
    }

    public boolean is3DPlotGlyph() {
        return true;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("deep", this.deep);
        jSONObject.put("horizontalDrawBar", this.horizontalDrawBar);
        jSONObject.put("isHorizontal", this.isHorizontal);
        if (this.projection != null) {
            jSONObject.put("projection", (Object)this.projection.toJSONObject());
        }
        return jSONObject;
    }

    public String getPlotDetailType() {
        String string = "";
        string = this.isHorizontal() ? string + "Bar3DPlotGlyph" : string + "Column3DPlotGlyph";
        if (this.isStacked()) {
            string = string + "-Stack";
        }
        if (this.getyAxisGlyph().isPercentage()) {
            string = string + "-Percentage";
        }
        if (this.isHorizontalDrawBar()) {
            string = string + "-Landscape";
        }
        return string;
    }

    public boolean isNeedDefaultDeep() {
        return this.isHorizontalDrawBar() || this.isStacked();
    }

    public String getPlotGlyphType() {
        return "Bar3DPlotGlyph";
    }

    public String getChartType() {
        return "Bar3D";
    }
}

