/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.TableData;
import com.fr.base.Utils;
import com.fr.base.chart.chartdata.BaseTableDefinition;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartdata.JSONDataModel;
import com.fr.chart.chartdata.TopDefinition;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.NameTableData;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.bridge.ObjectHolder;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.SessionCachedDataModelProcessor;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class TableDataDefinition
extends TopDefinition
implements BaseTableDefinition {
    private static final long serialVersionUID = 6650119421972084763L;
    private TableData tableData;

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public abstract ChartData createChartData(DataModel var1, DataProcessor var2);

    public String[] dependence(CalculatorProvider calculatorProvider) {
        if (this.getTableData() == null) {
            return new String[0];
        }
        ParameterProvider[] parameterProviderArray = this.getTableData().getParameters((Calculator)calculatorProvider);
        if (parameterProviderArray == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < parameterProviderArray.length; ++i) {
            arrayList.add(parameterProviderArray[i].getName().startsWith("$") ? parameterProviderArray[i].getName() : "$" + parameterProviderArray[i].getName());
            if (!(parameterProviderArray[i].getValue() instanceof Formula)) continue;
            arrayList.addAll(Arrays.asList(((Formula)parameterProviderArray[i].getValue()).dependence(calculatorProvider)));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public JSONObject createDataConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("dataType", (Object)this.getDataDefinitionType());
        Calculator calculator = Calculator.createCalculator();
        try {
            TableDataDefinition tableDataDefinition = (TableDataDefinition)this.clone();
            if (tableDataDefinition != null && tableDataDefinition.getTableData() != null) {
                DataModel dataModel = tableDataDefinition.getTableData().createDataModel(calculator);
                if (dataModel != null && !(dataModel instanceof JSONDataModel)) {
                    JSONObject jSONObject2 = new JSONObject();
                    for (int i = 0; i < dataModel.getColumnCount(); ++i) {
                        String string = dataModel.getColumnName(i);
                        JSONArray jSONArray = new JSONArray();
                        int n = dataModel.getRowCount();
                        for (int j = 0; j < n; ++j) {
                            Object object = dataModel.getValueAt(j, i);
                            jSONArray.put((Object)Utils.objectToString((Object)object));
                        }
                        jSONObject2.put(string, (Object)jSONArray);
                    }
                    jSONObject.put("tableData", (Object)jSONObject2);
                } else if (dataModel != null) {
                    JSONDataModel jSONDataModel = (JSONDataModel)dataModel;
                    jSONObject.put("tableData", (Object)jSONDataModel.getFilePath());
                    jSONObject.put("dataSource", (Object)"remote");
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), (Throwable)exception);
        }
        return jSONObject;
    }

    public ChartData calcu4ChartData(Calculator calculator, DataProcessor dataProcessor) {
        ChartData chartData = null;
        try {
            TableDataDefinition tableDataDefinition = (TableDataDefinition)this.clone();
            if (tableDataDefinition != null) {
                if (tableDataDefinition.getTableData() != null) {
                    SessionCachedDataModelProcessor sessionCachedDataModelProcessor;
                    NameTableData nameTableData = (NameTableData)tableDataDefinition.getTableData();
                    String string = nameTableData.getName();
                    DataModel dataModel = tableDataDefinition.getTableData().createDataModel(calculator);
                    ExtraClassManagerProvider extraClassManagerProvider = (ExtraClassManagerProvider)StableFactory.getMarkedObject((String)"ExtraClassManager", ExtraClassManagerProvider.class);
                    if (extraClassManagerProvider != null && (sessionCachedDataModelProcessor = (SessionCachedDataModelProcessor)extraClassManagerProvider.getSingle("SessionCachedDataModelProcessor")) != null && sessionCachedDataModelProcessor.isSupportedType(new ObjectHolder((Object)calculator))) {
                        NameSpace nameSpace = (NameSpace)Calculator.getSavedSessionNameSpace();
                        String string2 = (String)nameSpace.getVariable((Object)"sessionID", null);
                        dataModel = (DataModel)sessionCachedDataModelProcessor.getOrCreate(string2, string, new ObjectHolder((Object)dataModel)).get(dataModel.getClass());
                    }
                    if (dataModel == null) {
                        dataModel = tableDataDefinition.getTableData().createDataModel(calculator);
                    }
                    if (dataModel == DataModel.EMPTY_DATAMODEL) {
                        throw new TableDataException(Inter.getLocText((String)"Chart-Table_Data_Not_Found") + "!");
                    }
                    chartData = tableDataDefinition.createChartData(dataModel, dataProcessor);
                }
                if (chartData != null) {
                    chartData = tableDataDefinition.createTopChartData(chartData, calculator);
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), (Throwable)exception);
        }
        return chartData;
    }

    protected void addValueInColumnWithName(ArrayList arrayList, DataModel dataModel, ArrayList arrayList2, int n, int n2) throws TableDataException {
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (int j = 0; j < dataModel.getRowCount(); ++j) {
                if (n == -1) {
                    arrayList3.add(dataModel.getValueAt(j, n2));
                    continue;
                }
                if (!ComparatorUtils.equals(e, (Object)dataModel.getValueAt(j, n))) continue;
                arrayList3.add(dataModel.getValueAt(j, n2));
            }
            arrayList2.add(arrayList3);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.tableData != null) {
            DataCoreXmlUtils.writeXMLTableData((XMLPrintWriter)xMLPrintWriter, (TableData)this.tableData);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        TableData tableData;
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "TableData".equals(string = xMLableReader.getTagName()) && (tableData = DataCoreXmlUtils.readXMLTableData((XMLableReader)xMLableReader)) != null) {
            this.setTableData(tableData);
        }
    }

    public void modDefinitionFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
    }

    public boolean equals(Object object) {
        return object instanceof TableDataDefinition && ComparatorUtils.equals((Object)((TableDataDefinition)object).tableData, (Object)this.tableData) && super.equals(object);
    }

    public boolean isSupportAutoRefresh() {
        Calculator calculator = Calculator.createCalculator();
        if (this.getTableData() != null) {
            DataModel dataModel = this.getTableData().createDataModel(calculator);
            return dataModel instanceof JSONDataModel;
        }
        return false;
    }
}

