/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.web.core.process.reportprocess.operator.ProcessOperator;
import com.fr.web.core.process.reportprocess.operator.ProcessOperatorManager;
import com.fr.web.platform.TransmitParameters;

public class ReportControl {
    public static final String REPORT_PATH = "reportPath";
    public static final String PARAMETERS = "parameters";
    public static final String OPERATOR = "operator";
    private String reportPath;
    private TransmitParameters parameters = null;
    private ProcessOperator operator;

    public ReportControl() {
    }

    public ReportControl(String string) {
        try {
            this.parseJSON(new JSONObject(string));
        }
        catch (Exception exception) {
            FRContext.getLogger().info("error happens on init ReportControl");
        }
    }

    public ReportControl(JSONObject jSONObject) {
        this.parseJSON(jSONObject);
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public void setReportPath(String string) {
        this.reportPath = string;
    }

    public ProcessOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ProcessOperator processOperator) {
        this.operator = processOperator;
    }

    public TransmitParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(TransmitParameters transmitParameters) {
        this.parameters = transmitParameters;
    }

    public boolean isUnderTakeBy(long l2) {
        return this.operator != null && this.operator.isUnderTakeBy(l2);
    }

    public JSONObject createJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) {
        try {
            this.reportPath = jSONObject.optString(REPORT_PATH);
            this.parameters = TransmitParameters.parseJSON(jSONObject.optJSONArray(PARAMETERS));
            this.operator = ProcessOperatorManager.createOperator(jSONObject.optString(OPERATOR));
        }
        catch (Exception exception) {
            FRContext.getLogger().info("error happens on parse ReportControl");
        }
    }

    public String toString() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(REPORT_PATH, (Object)this.reportPath);
            if (this.parameters != null) {
                jSONObject.put(PARAMETERS, (Object)this.parameters.createJSON());
            }
            if (this.operator != null) {
                jSONObject.put(OPERATOR, (Object)this.operator.toString());
            }
            return jSONObject.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

