/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.form.ui.ToolBar;
import com.fr.form.ui.ToolBarButton;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.report.web.Location;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.button.write.ClearStashedButton;
import com.fr.report.web.button.write.StashButton;
import com.fr.report.web.button.write.Submit;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.ProcessConstant;
import com.fr.web.core.process.reportprocess.ProcessManager;
import com.fr.web.core.process.reportprocess.ProcessNode;
import com.fr.web.core.process.reportprocess.ProcessTaskImpl;
import com.fr.web.core.process.reportprocess.ReportControl;
import com.fr.web.core.process.reportprocess.StashData;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskImplDAO;
import com.fr.web.core.process.reportprocess.dao.StashDataDAO;
import com.fr.web.utils.WebUtils;
import com.fr.write.ProcessProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessBridge
implements ProcessProvider {
    private static ProcessBridge SC = new ProcessBridge();

    public static ProcessBridge getInstance() {
        return SC;
    }

    public void waitForRun() {
        ProcessManager.init();
    }

    @Override
    public int getTaskState(long l2) {
        ProcessTaskImpl processTaskImpl = ProcessManager.getTask(l2);
        if (processTaskImpl == null) {
            return -1;
        }
        return processTaskImpl.getState();
    }

    @Override
    public String getTaskName(long l2) {
        ProcessTaskImpl processTaskImpl = ProcessManager.getTask(l2);
        if (processTaskImpl == null) {
            return "";
        }
        return processTaskImpl.getName();
    }

    public long getFrTaskId(long l2) {
        ProcessTaskImpl processTaskImpl = ProcessManager.getTask(l2);
        if (processTaskImpl == null) {
            return -1L;
        }
        return processTaskImpl.getFrTaskId();
    }

    @Override
    public Object getTaskSender(long l2) {
        ProcessTaskImpl processTaskImpl = ProcessManager.getTask(l2);
        if (processTaskImpl == null) {
            return "";
        }
        return processTaskImpl.getAllSender(false);
    }

    @Override
    public String getTaskAuthority(long l2) {
        ProcessTaskImpl processTaskImpl = ProcessManager.getTask(l2);
        if (processTaskImpl == null) {
            return "";
        }
        ProcessNode processNode = processTaskImpl.getCurrentNode();
        return processNode.getAuthority();
    }

    @Override
    public Parameter[] getTaskParameters(long l2, Repository repository) {
        ProcessTaskImpl processTaskImpl = ProcessManager.getTask(l2);
        if (processTaskImpl == null) {
            return new Parameter[0];
        }
        ProcessNode processNode = processTaskImpl.getCurrentNode();
        int n2 = processTaskImpl.getReportOffset();
        if (n2 >= 0) {
            return processNode.getParameters(n2);
        }
        try {
            JSONArray jSONArray = new JSONArray(processNode.getReportControl());
            int n3 = jSONArray.length();
            if (n3 == 0) {
                return new Parameter[0];
            }
            if (n3 == 1) {
                return processNode.getParameters(0);
            }
            ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)RepositoryHelper.getSessionIDInfor((Repository)repository);
            long l3 = ProcessUtils.getCurrentUserId(repository.getHttpServletRequest());
            String string = reportSessionIDInfor.getBookPath();
            for (int i2 = 0; i2 < n3; ++i2) {
                ReportControl reportControl = new ReportControl(jSONArray.getString(i2));
                if (!ComparatorUtils.equals((String)reportControl.getReportPath(), (String)string) || !reportControl.isUnderTakeBy(l3)) continue;
                return processNode.getParameters(i2);
            }
        }
        catch (Exception exception) {
            return new Parameter[0];
        }
        return new Parameter[0];
    }

    @Override
    public ToolBarManager createDefaultReportProcessToolbar(String string, long l2) {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBarLocation(Location.createBottomEmbedLocation());
        ToolBar toolBar = new ToolBar();
        this.addProcessBtn(toolBar, string, l2);
        toolBarManager.setToolBar(toolBar);
        return toolBarManager;
    }

    @Override
    public boolean modifyToolbar(ToolBarManager[] toolBarManagerArray, List<ToolBarManager> list, String string, long l2) {
        if (toolBarManagerArray == null || string == null) {
            return false;
        }
        boolean bl = false;
        try {
            for (int i2 = 0; i2 < toolBarManagerArray.length; ++i2) {
                Widget widget;
                ToolBarManager toolBarManager = (ToolBarManager)toolBarManagerArray[i2].clone();
                ToolBar toolBar = toolBarManager.getToolBar();
                for (int i3 = 0; i3 < toolBar.getWidgetSize(); ++i3) {
                    widget = toolBar.getWidget(i3);
                    if (!(widget instanceof Submit) && !(widget instanceof StashButton) && !(widget instanceof ClearStashedButton)) continue;
                    toolBar.removeWidget(i3);
                    --i3;
                }
                list.set(i2, toolBarManager);
                if (!toolBarManagerArray[i2].isBottomPos() || bl) continue;
                ToolBarManager toolBarManager2 = (ToolBarManager)toolBarManagerArray[i2].clone();
                widget = toolBarManager2.getToolBar();
                this.addProcessBtn((ToolBar)widget, string, l2);
                list.set(i2, toolBarManager2);
                bl = true;
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return bl;
    }

    private void addProcessBtn(ToolBar toolBar, String string, long l2) {
        ToolBarButton[] toolBarButtonArray = ProcessConstant.getOperations(l2);
        int n2 = toolBarButtonArray.length;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            if (Integer.parseInt(string.substring(i2, i2 + 1)) != 1 || i2 >= n2 || toolBarButtonArray[i2] == null) continue;
            toolBar.addWidgetAhead((Widget)toolBarButtonArray[i2]);
        }
    }

    @Override
    public boolean isValidTaskUser(HttpServletRequest httpServletRequest, long l2) {
        long l3 = ProcessUtils.getCurrentUserId(httpServletRequest);
        if (ProcessUtils.invalidUser(l3)) {
            return false;
        }
        try {
            ProcessTaskImpl processTaskImpl = (ProcessTaskImpl)ProcessTaskImplDAO.getInstance().findByID(l2);
            if (processTaskImpl == null) {
                return false;
            }
            return processTaskImpl.isUnderTakeBy(l3);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getStashData(Repository repository, long l2) {
        long l3 = ProcessUtils.getCurrentUserId(repository.getHttpServletRequest());
        if (ProcessUtils.invalidUser(l3)) {
            return null;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put(StashData.USER_ID, l3);
        hashMap.put(StashData.TASK_ID, l2);
        try {
            List list = StashDataDAO.getInstance().listByFieldValues(hashMap);
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() == 1) {
                return ((StashData)list.get(0)).getData();
            }
            ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)RepositoryHelper.getSessionIDInfor((Repository)repository);
            String string = reportSessionIDInfor.getBookPath();
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    @Override
    public Map<String, Object> mixProcessParameters(HttpServletRequest httpServletRequest, Repository repository) {
        return this.addReportProcessParas(httpServletRequest, repository);
    }

    private boolean isReportProcess(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__processtaskid__");
        if (string == null) {
            return false;
        }
        try {
            return this.isValidTaskUser(httpServletRequest, Long.parseLong(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Map<String, Object> addReportProcessParas(HttpServletRequest httpServletRequest, Repository repository) {
        Parameter[] parameterArray;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!this.isReportProcess(httpServletRequest)) {
            return hashMap;
        }
        long l2 = Long.parseLong(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__processtaskid__"));
        long l3 = Long.parseLong(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__allprocesstaskid__"));
        hashMap.put("fr_task_id", this.getFrTaskId(l2));
        hashMap.put("fr_task_name", this.getTaskName(l2));
        hashMap.put("fr_task_state", this.getTaskState(l2));
        hashMap.put("fr_task_sender", this.getTaskSender(l2));
        for (Parameter parameter : parameterArray = this.getTaskParameters(l2, repository)) {
            hashMap.put(parameter.getName(), parameter.getValue());
        }
        return hashMap;
    }
}

