/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.button;

import com.fr.base.IconManager;
import com.fr.base.TemplateUtils;
import com.fr.form.ui.Button;
import com.fr.form.ui.ToolBarButton;
import com.fr.form.ui.ToolBarMenuButton;
import com.fr.report.web.button.AppletPrint;
import com.fr.report.web.button.FlashPrint;
import com.fr.report.web.button.PDFPrint;
import com.fr.report.web.button.ServerPrint;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;

public final class Print
extends ToolBarMenuButton {
    private boolean pdfPrint = true;
    private boolean appletPrint = true;
    private boolean flashPrint = true;
    private boolean serverPrint = false;

    public Print() {
        super(TemplateUtils.i18nTpl((String)"Print"), IconManager.PRINT.getName());
    }

    public boolean isPDFPrint() {
        return this.pdfPrint;
    }

    public void setPDFPrint(boolean bl) {
        this.pdfPrint = bl;
    }

    public boolean isAppletPrint() {
        return this.appletPrint;
    }

    public void setAppletPrint(boolean bl) {
        this.appletPrint = bl;
    }

    public boolean isFlashPrint() {
        return this.flashPrint;
    }

    public void setFlashPrint(boolean bl) {
        this.flashPrint = bl;
    }

    public boolean isServerPrint() {
        return this.serverPrint;
    }

    public void setServerPrint(boolean bl) {
        this.serverPrint = bl;
    }

    public boolean supportMobile() {
        return false;
    }

    public Button[] createMenuItems() {
        ArrayList<ToolBarButton> arrayList = new ArrayList<ToolBarButton>();
        if (this.pdfPrint) {
            arrayList.add(new PDFPrint());
        }
        if (this.appletPrint) {
            arrayList.add(new AppletPrint());
        }
        if (this.flashPrint) {
            arrayList.add(new FlashPrint());
        }
        if (this.serverPrint) {
            arrayList.add(new ServerPrint());
        }
        return arrayList.toArray(new Button[arrayList.size()]);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("PrintButtons")) {
            this.setPDFPrint(xMLableReader.getAttrAsBoolean("pdfPrint", true));
            this.setAppletPrint(xMLableReader.getAttrAsBoolean("appletPrint", true));
            this.setFlashPrint(xMLableReader.getAttrAsBoolean("flashPrint", true));
            this.setServerPrint(xMLableReader.getAttrAsBoolean("serverPrint", false));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("PrintButtons");
        if (!this.pdfPrint) {
            xMLPrintWriter.attr("pdfPrint", this.pdfPrint);
        }
        if (!this.appletPrint) {
            xMLPrintWriter.attr("appletPrint", this.appletPrint);
        }
        if (!this.flashPrint) {
            xMLPrintWriter.attr("flashPrint", this.flashPrint);
        }
        if (this.serverPrint) {
            xMLPrintWriter.attr("serverPrint", this.serverPrint);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Print)) {
            return false;
        }
        Print print = (Print)((Object)object);
        return super.equals(object) && this.isAppletPrint() == print.isAppletPrint() && this.isFlashPrint() == print.isPDFPrint() && this.isPDFPrint() == print.isPDFPrint() && this.isServerPrint() == print.isServerPrint();
    }
}

