/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.block;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.cache.list.IntList;
import com.fr.parser.BlockIntervalLiteral;
import com.fr.report.block.ResultBlock;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.core.block.PolyWorkSheetExecutor;
import com.fr.report.core.sheet.SequenceExecutor;
import com.fr.report.core.sheet.SheetExecutor;
import com.fr.report.elementcase.ResultElementCase;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.report.poly.PolyChartBlock;
import com.fr.report.poly.PolyWorkSheet;
import com.fr.report.poly.TemplateBlock;
import com.fr.report.report.ResultReport;
import com.fr.report.stable.fun.Actor;
import com.fr.script.Calculator;
import com.fr.stable.ListMap;
import com.fr.stable.script.Expression;
import com.fr.third.antlr.ANTLRException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BlockSequenceExecutor
extends SequenceExecutor {
    protected PolyWorkSheet tplReport;
    protected PolyWorkSheetExecutor current_ee;

    public BlockSequenceExecutor(PolyWorkSheet polyWorkSheet, Map map) {
        if (polyWorkSheet != null) {
            int n2 = polyWorkSheet.getBlockCount();
            this.nameListMap = new ListMap(n2);
            this.executed_mark = new IntList(n2);
            this.executor_list = new ArrayList(n2);
            this.exe_info_list = new ArrayList(n2);
            this.exe_start_time_list = new ArrayList(n2);
            TemplateBlock templateBlock = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                templateBlock = (TemplateBlock)polyWorkSheet.getBlock(i2);
                this.nameListMap.put((Object)templateBlock.getBlockName(), (Object)templateBlock);
                this.executed_mark.add(0);
                this.executor_list.add(null);
                this.exe_info_list.add(new int[n2]);
                this.exe_start_time_list.add(null);
            }
        }
        this.tplReport = polyWorkSheet;
        this.parameterMap = map;
    }

    public ResultReport execute(Actor actor) {
        if (this.tplReport == null) {
            return null;
        }
        this.current_ee = actor.createPolySequenceExecutor(this.tplReport, this.parameterMap, actor);
        this._execute();
        try {
            ResultReport resultReport = this.current_ee.result();
            return resultReport;
        }
        finally {
            this.current_ee = null;
        }
    }

    protected void _execute() {
        int n2 = this.nameListMap.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TemplateBlock templateBlock = (TemplateBlock)this.nameListMap.getByIndex(i2);
            this.current_index = i2;
            SheetExecutor sheetExecutor = null;
            sheetExecutor = this.checkIncludingBlockExecuteSequence() || templateBlock instanceof PolyChartBlock ? this.current_ee.createExecutor(templateBlock, this) : this.current_ee.createExecutor(templateBlock, null);
            this.executor_list.set(this.current_index, sheetExecutor);
        }
        while (this.next()) {
            SheetExecutor sheetExecutor = this.getExecutor();
            this.execute(sheetExecutor);
        }
    }

    protected long execute4Expand(SheetExecutor sheetExecutor) {
        return sheetExecutor.execute4Expand(this.current_ee.getExeType());
    }

    protected void addExecutor4Result(SheetExecutor sheetExecutor, long l2) {
        this.current_ee.addResult(this.current_index, sheetExecutor.execute4Poly(this.current_ee.getExeType(), l2));
    }

    protected void addExecutor4Result(int n2) {
        this.current_ee.addResult(n2, ((SheetExecutor)this.executor_list.get(n2)).execute4Poly(this.current_ee.getExeType(), (Long)this.exe_start_time_list.get(n2)));
    }

    protected String getLiteralName(List list, int n2) {
        BlockIntervalLiteral blockIntervalLiteral = (BlockIntervalLiteral)list.get(n2);
        return blockIntervalLiteral.getBlockName();
    }

    protected SheetExecutor getExecutor() {
        return (SheetExecutor)this.executor_list.get(this.current_index);
    }

    public TemplateElementCase getTemplateByIndex(int n2) {
        TemplateBlock templateBlock = (TemplateBlock)this.nameListMap.getByIndex(n2);
        return templateBlock.isCells() ? (TemplateElementCase)((Object)templateBlock) : null;
    }

    public boolean checkIncludingBlockExecuteSequence() {
        int n2 = this.nameListMap.size();
        if (n2 <= 1) {
            return false;
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        block2: for (int i2 = 0; i2 < n2; ++i2) {
            TemplateElementCase templateElementCase = this.getTemplateByIndex(i2);
            if (templateElementCase == null) continue;
            Iterator iterator = templateElementCase.cellIterator();
            while (iterator.hasNext()) {
                Object object;
                TemplateCellElement templateCellElement = (TemplateCellElement)iterator.next();
                if (templateCellElement == null || !((object = templateCellElement.getValue()) instanceof Formula)) continue;
                try {
                    Expression expression = Calculator.createCalculator().parse(((Formula)object).getContent());
                    expression.trav4HuntBIL(arrayList);
                    if (arrayList.size() <= 0) continue;
                    bl = true;
                    continue block2;
                }
                catch (ANTLRException aNTLRException) {
                    FRContext.getLogger().error(aNTLRException.getMessage(), (Throwable)aNTLRException);
                }
            }
        }
        return bl;
    }

    public ResultElementCase getResultByIndex(int n2) {
        ResultBlock resultBlock = (ResultBlock)this.current_ee.reslist.get(n2);
        return resultBlock.isCells() ? (ResultElementCase)((Object)resultBlock) : null;
    }
}

