/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.FRContext;
import com.fr.file.CacheManager;
import com.fr.general.IOUtils;
import com.fr.io.core.ExporterUtils;
import com.fr.io.exporter.CSVExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPageProvider;
import com.fr.report.core.A.A.A;
import com.fr.report.core.A.A.C;
import com.fr.report.core.ReportUtils;
import com.fr.report.elementcase.ElementGetter;
import com.fr.report.report.ECReport;
import com.fr.report.report.ResultReport;
import com.fr.stable.StableUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.tools.zip.ZipOutputStream;

public class LargeDataPageCSVExporter
extends CSVExporter {
    private static final int RANDOMNUM = 1000;
    private static final int MAXNUM = 1000000;
    private int count = 0;
    private int index = 0;
    private String reportName;
    private FileOutputStream fops;
    private boolean isLastPage = false;

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        List<PaperSettingProvider> list = ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook);
        File file = new File(CacheManager.getProviderInstance().getCacheDirectory(), "excel-temp");
        File file2 = new File(file, "TEMP_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
        int n2 = 0;
        while (file2.exists()) {
            file2 = new File(file, "TEMP_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n2);
            ++n2;
        }
        StableUtils.mkdirs((File)file2);
        file2.deleteOnExit();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        zipOutputStream.setEncoding("GBK");
        this.reportName = "Part";
        this.fops = new FileOutputStream(file2.getAbsolutePath() + File.separator + this.reportName + "_" + this.index + ".csv");
        int n3 = resultWorkBook.getReportCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.export(resultWorkBook.getResultReport(i2), list.get(i2), file2);
        }
        FRContext.getLogger().info("start compress files");
        IOUtils.zip((ZipOutputStream)zipOutputStream, (File)file2, null);
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        FRContext.getLogger().info("complete compress files");
        StableUtils.deleteFile((File)file2);
    }

    private void export(ResultReport resultReport, PaperSettingProvider paperSettingProvider, File file) throws Exception {
        if (resultReport instanceof A || resultReport instanceof C) {
            FRContext.getLogger().info("LayerReport start export");
            PageSetProvider pageSetProvider = resultReport.generateReportPageSet(paperSettingProvider).traverse4Export();
            this.export(pageSetProvider, file);
            pageSetProvider.release();
        } else if (resultReport != null) {
            this.isLastPage = true;
            FRContext.getLogger().info("UnLayerReport start export");
            this.exportReport((ECReport)((Object)resultReport), file);
        }
    }

    private void export(PageSetProvider pageSetProvider, File file) throws Exception {
        ReportPageProvider reportPageProvider;
        ClippedPageProvider clippedPageProvider;
        for (int i2 = 0; i2 < pageSetProvider.size() && (clippedPageProvider = ExporterUtils.support(reportPageProvider = pageSetProvider.getPage(i2))) != null; ++i2) {
            if (i2 == pageSetProvider.size() - 1) {
                this.isLastPage = true;
            }
            this.exportReport((ElementGetter)clippedPageProvider, file);
        }
    }

    private void exportReport(ElementGetter elementGetter, File file) throws Exception {
        int n2 = 0;
        int n3 = elementGetter.getRowCount();
        this.count += elementGetter.getRowCount();
        if (this.count > 1000000) {
            n3 = 1000000 - (this.count - elementGetter.getRowCount());
            this.exportReport(this.fops, elementGetter, n2, n3);
            int n4 = (elementGetter.getRowCount() - (1000000 - (this.count - elementGetter.getRowCount())) - 1) / 1000000 + 1;
            for (int i2 = 0; i2 < n4; ++i2) {
                ++this.index;
                n2 = 1000000 - (this.count - elementGetter.getRowCount()) + i2 * 1000000;
                n3 = i2 == n4 - 1 ? elementGetter.getRowCount() : 1000000 - (this.count - elementGetter.getRowCount()) + (i2 + 1) * 1000000;
                this.fops = new FileOutputStream(file.getAbsolutePath() + File.separator + this.reportName + "_" + this.index + ".csv");
                this.exportReport(this.fops, elementGetter, n2, n3);
            }
            this.count = n3 - n2;
        } else {
            this.exportReport(this.fops, elementGetter, n2, n3);
        }
        if (this.count == 1000000 && !this.isLastPage) {
            this.count = 0;
            ++this.index;
            this.fops = new FileOutputStream(file.getAbsolutePath() + File.separator + this.reportName + "_" + this.index + ".csv");
        }
    }
}

