/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.BaseUtils;
import com.fr.base.CustomConfigManager;
import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Margin;
import com.fr.base.PaperSize;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.cache.list.IntList;
import com.fr.data.PresentationType;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.general.PageCalObj;
import com.fr.io.attr.ReportExportAttr;
import com.fr.io.exporter.AbstractAppExporter;
import com.fr.io.exporter.ExcelHiddenCellsTool;
import com.fr.io.exporter.POIPictureLocation;
import com.fr.io.exporter.poi.wrapper.POICellAction;
import com.fr.io.exporter.poi.wrapper.POICellStyleAction;
import com.fr.io.exporter.poi.wrapper.POIClientAnchorAction;
import com.fr.io.exporter.poi.wrapper.POIFontAction;
import com.fr.io.exporter.poi.wrapper.POIHeaderFooterAction;
import com.fr.io.exporter.poi.wrapper.POIPatriarchAction;
import com.fr.io.exporter.poi.wrapper.POIPrintSetupAction;
import com.fr.io.exporter.poi.wrapper.POIRichStringAction;
import com.fr.io.exporter.poi.wrapper.POISheetAction;
import com.fr.io.exporter.poi.wrapper.POIWorkbookAction;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.parser.FRLexer;
import com.fr.parser.FRParser;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DefaultPageCellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.cell.cellattr.core.CellUtils;
import com.fr.report.cell.cellattr.core.RichChar;
import com.fr.report.cell.cellattr.core.RichText;
import com.fr.report.cell.cellattr.core.RichTextConverter;
import com.fr.report.core.PackedReport;
import com.fr.report.core.PaintUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.ResultECReport;
import com.fr.report.worksheet.PageRWorkSheet;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ExportConstants;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.ExcelExportCellValueProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.script.Expression;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.third.antlr.TokenStream;
import com.fr.third.com.lowagie.text.Font;
import com.fr.web.core.utils.ExportUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExcelExporter<T>
extends AbstractAppExporter<T> {
    protected static final short DEFAULT_FONT = 11;
    public static final short DEFAULT_COL_WIDTH = 9;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int EXCEL_EXPORT_RESOLUTION = 96;
    public static final String FORMULA_ERROR = "\"FR(" + Inter.getLocText((String)"FR-Engine-Excel_formula_error") + "!)\"";
    protected static final int MAX_PROPER_FONT = 14;
    protected static final double FONT_SCALE = 0.95;
    private static final int DEFAULT_FONT_SIZE = 11;
    private static final short TEXT_FORMAT = 49;
    private static final int CHAR_CODE1 = 164;
    private static final int CHAR_CODE2 = 65509;
    private static final int FONT_SIZE_RATE = 20;
    public static final short A3_PAGE_SIZE = 8;
    public static final short A6_PAGE_SIZE = 70;
    public static final short B4_PAGE_SIZE = 12;
    public static final short B5_PAGE_SIZE = 13;
    public static final short NOTE_PAGE_SIZE = 18;
    public static final short LEDGER_PAGE_SIZE = 4;
    private static final int SHEET_COUNT_LIMIT = 1000;
    protected static final int ROTATION_UPPER = 90;
    protected static final int ROTATION_DOWN = -90;
    public static final double HANDRED = 100.0;
    public static final int DEFAULT_SCALE = 1;
    public static final int HEIGHT_LIMIT = 120;
    public static final int EIGHTH = 80;
    protected List paperSettingList = null;
    protected HashMap hssfFontHash = new HashMap();
    protected HashMap hssfCellStyleHash = new HashMap();
    protected IntList colorList = new IntList();
    protected Map[] columnRowPostileMaps = null;
    protected ExcelHiddenCellsTool ex_tool = new ExcelHiddenCellsTool();
    protected int totalBreak;
    protected int[] sheets2Export = null;

    @Override
    public abstract void export(OutputStream var1, ResultWorkBook var2) throws Exception;

    protected abstract short getFormat(POIWorkbookAction var1, String var2);

    protected abstract POIFontAction createFont(POIWorkbookAction var1, java.awt.Font var2);

    protected abstract short getRotation(Style var1);

    protected abstract int getFloatLeftMax(double var1);

    protected abstract int getFloatTopMax(double var1);

    public void setSheets2Export(int[] nArray) {
        this.sheets2Export = nArray;
    }

    protected Object checkValueVertical(Object object, Style style, int n2, int n3) {
        String string = Utils.objectToString((Object)object);
        if (StringUtils.isEmpty((String)string)) {
            return object;
        }
        List list = BaseUtils.getLineTextList((String)string, (Style)style, (java.awt.Font)style.getFRFont().applyResolutionNP(96), (double)n3, (double)n2, (int)96);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string2 = i2 == list.size() - 1 ? "" : "\n";
            stringBuffer.append(list.get(i2)).append(string2);
        }
        return stringBuffer.toString();
    }

    protected boolean isShowAsImage(int n2, CellGUIAttr cellGUIAttr) {
        return n2 == 2 || n2 == 3 || cellGUIAttr.isShowAsImage();
    }

    protected int[] dealWithHiddenCR(int n2, int n3, IntList intList) {
        int[] nArray = new int[]{n2, n3};
        for (int i2 = 0; i2 < intList.size(); ++i2) {
            int n4 = intList.get(i2);
            if (n4 >= n2 && n4 < n2 + n3) {
                nArray[1] = nArray[1] - 1;
                continue;
            }
            if (n4 >= n2) continue;
            nArray[0] = nArray[0] - 1;
        }
        return nArray;
    }

    protected String dealWithSumFormula(String string, Object object, Formula formula, boolean bl) {
        String string2 = ((ResultFormula)object).getTransferContent();
        if (!bl && this.checkSumValid(string, string2)) {
            String[] stringArray = string2.split(",");
            string = stringArray[0] + ":" + stringArray[stringArray.length - 1];
        } else {
            string = string2;
            string = ComparatorUtils.equals((String)string, (String)"=") ? formula.getContent() : string;
        }
        return string;
    }

    private boolean checkSumValid(String string, String string2) {
        try {
            String string3 = StringUtils.perfectStart((String)string, (String)"=").replaceAll(" ", "").toUpperCase();
            return string3.indexOf("=SUM(") != -1 && string.indexOf(":") != -1 && string.split("[(:,)]").length == 3 && string2.indexOf(",") != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Object checkNumberFormat(Format format, Object object) {
        return ExportUtils.checkNumberFormat(format, object);
    }

    protected void setAttr4ECReportSIL(Calculator calculator, IntList intList, IntList intList2, ElementCase elementCase) {
        calculator.setAttribute(ExTool.TAG, (Object)this.ex_tool);
        this.ex_tool.setRowHiddenList(intList);
        this.ex_tool.setColHiddenList(intList2);
        this.ex_tool.setReport((Report)((Object)elementCase));
        this.ex_tool.setHhMap(null);
    }

    public void setPostilMap(Map[] mapArray) {
        this.columnRowPostileMaps = mapArray;
    }

    protected void dealWithFormula(POICellAction pOICellAction, String string) {
        if (!this.checkInvalidFormula(string)) {
            pOICellAction.setCellType(1);
            pOICellAction.setCellValue("=" + string);
            return;
        }
        try {
            pOICellAction.setCellType(2);
            pOICellAction.setCellFormula(string);
            if (!string.equalsIgnoreCase(pOICellAction.getCellFormula()) && !string.matches(".+![\\w&&[\\D]]+\\d+.*")) {
                pOICellAction.setCellType(1);
                pOICellAction.setCellFormula(string);
                FRContext.getLogger().error(Inter.getLocText((String)"FR-Engine-NS_export_excelFormula") + string);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(Inter.getLocText((String)"FR-Engine-NS_export_excelFormula") + string);
            if (string.indexOf("[!0") != -1) {
                pOICellAction.setCellType(0);
                pOICellAction.setCellValue(0.0);
            }
            pOICellAction.setCellType(1);
            pOICellAction.setCellValue("=" + string);
        }
    }

    protected String getPassword(ResultWorkBook resultWorkBook) {
        String string = null;
        ReportExportAttr reportExportAttr = resultWorkBook.getReportExportAttr();
        if (reportExportAttr != null && reportExportAttr.getExcelExportAttr() != null) {
            string = reportExportAttr.getExcelExportAttr().getPassword();
        }
        return string;
    }

    protected void setSheetName(POIWorkbookAction pOIWorkbookAction, String string) {
        ExportUtils.setSheetName(pOIWorkbookAction, string);
    }

    protected void dealWithPrintSetUp(POIPrintSetupAction pOIPrintSetupAction, PaperSize paperSize, int n2, ReportSettingsProvider reportSettingsProvider) {
        ExportUtils.dealWithPrintSetUp(pOIPrintSetupAction, paperSize, n2, reportSettingsProvider);
    }

    protected void dealWithAlignAndMargin(POISheetAction pOISheetAction, ReportSettingsProvider reportSettingsProvider, Margin margin) {
        ExportUtils.dealWithAlignAndMargin(pOISheetAction, reportSettingsProvider, margin);
    }

    protected void dealWithBufferImage(Object object, POIClientAnchorAction pOIClientAnchorAction, POIPatriarchAction pOIPatriarchAction, Style style, int n2, int n3, BufferedImage bufferedImage, POIWorkbookAction pOIWorkbookAction) {
        ExportUtils.dealWithBufferImage(object, pOIClientAnchorAction, pOIPatriarchAction, bufferedImage, pOIWorkbookAction);
    }

    protected POIFontAction createSimpleFont(POIWorkbookAction pOIWorkbookAction, FontAdapter fontAdapter, POIFontAction pOIFontAction, String string) {
        pOIFontAction.setFont(this.hssfFontHash.get(fontAdapter.getPackee()));
        if (pOIFontAction.getFont() == null) {
            pOIFontAction.setFont(pOIWorkbookAction.createFont());
            this.hssfFontHash.put(fontAdapter.getPackee(), pOIFontAction.getFont());
        }
        pOIFontAction.setFontHeight((short)(fontAdapter.getSize() * 20.0f));
        pOIFontAction.setFontName(ComparatorUtils.equals((String)fontAdapter.getName(), (String)"unknown") ? string : fontAdapter.getName());
        if (fontAdapter.isBold()) {
            pOIFontAction.setBoldweight((short)700);
        } else {
            pOIFontAction.setBoldweight((short)400);
        }
        if (fontAdapter.isItalic()) {
            pOIFontAction.setItalic(true);
        } else {
            pOIFontAction.setItalic(false);
        }
        return pOIFontAction;
    }

    protected void createComplexFont4FR(FRFont fRFont, POIFontAction pOIFontAction) {
        int n2;
        if (fRFont.isStrikethrough()) {
            pOIFontAction.setStrikeout(true);
        }
        if (fRFont.isSubscript()) {
            pOIFontAction.setTypeOffset((short)2);
        }
        if (fRFont.isSuperscript()) {
            pOIFontAction.setTypeOffset((short)1);
        }
        if ((n2 = GraphHelper.getLineStyleSize((int)fRFont.getUnderline())) == 0) {
            pOIFontAction.setUnderline((byte)0);
        } else if (n2 == 1) {
            pOIFontAction.setUnderline((byte)1);
        } else if (n2 == 2) {
            pOIFontAction.setUnderline((byte)2);
        }
    }

    protected void executeCellStyle(POIWorkbookAction pOIWorkbookAction, POICellStyleAction pOICellStyleAction, Style style) {
        Object object;
        Format format = style.getFormat();
        if (format != null) {
            if (format instanceof DecimalFormat) {
                object = ((DecimalFormat)format).toPattern();
                object = ((String)object).replace('\u00a4', '\uffe5');
                pOICellStyleAction.setDataFormat(this.getFormat(pOIWorkbookAction, (String)object));
            } else if (format instanceof SimpleDateFormat) {
                pOICellStyleAction.setDataFormat(this.getFormat(pOIWorkbookAction, ((SimpleDateFormat)format).toPattern()));
            } else if (format instanceof TextFormat) {
                pOICellStyleAction.setDataFormat((short)49);
            }
        }
        if ((object = this.createFont(pOIWorkbookAction, (java.awt.Font)style.getFRFont())) != null) {
            pOICellStyleAction.setFont((POIFontAction)object);
        }
        pOICellStyleAction.setBorderTop(this.getMapBorder(style.getBorderTop()));
        pOICellStyleAction.setBorderLeft(this.getMapBorder(style.getBorderLeft()));
        pOICellStyleAction.setBorderBottom(this.getMapBorder(style.getBorderBottom()));
        pOICellStyleAction.setBorderRight(this.getMapBorder(style.getBorderRight()));
        pOICellStyleAction.setWrapText(style.getTextStyle() == 0);
        pOICellStyleAction.setRotation(this.getRotation(style));
        int n2 = BaseUtils.getAlignment4Horizontal((Style)style);
        if (n2 == 2) {
            pOICellStyleAction.setAlignment((short)1);
        } else if (n2 == 0) {
            pOICellStyleAction.setAlignment((short)2);
        } else if (n2 == 4) {
            pOICellStyleAction.setAlignment((short)3);
        } else if (n2 == 6) {
            // empty if block
        }
        if (style.getVerticalAlignment() == 1) {
            pOICellStyleAction.setVerticalAlignment((short)0);
        } else if (style.getVerticalAlignment() == 0) {
            pOICellStyleAction.setVerticalAlignment((short)1);
        } else if (style.getVerticalAlignment() == 3) {
            pOICellStyleAction.setVerticalAlignment((short)2);
        } else if (style.getVerticalAlignment() == 6) {
            // empty if block
        }
    }

    protected short getMapBorder(int n2) {
        if (n2 == 1) {
            return 1;
        }
        if (n2 == 2) {
            return 2;
        }
        if (n2 == 3) {
            return 3;
        }
        if (n2 == 4) {
            return 4;
        }
        if (n2 == 5) {
            return 5;
        }
        if (n2 == 6) {
            return 6;
        }
        if (n2 == 7) {
            return 7;
        }
        if (n2 == 8) {
            return 8;
        }
        if (n2 == 9) {
            return 9;
        }
        if (n2 == 10) {
            return 10;
        }
        if (n2 == 11) {
            return 11;
        }
        if (n2 == 12) {
            return 12;
        }
        if (n2 == 13) {
            return 13;
        }
        return 0;
    }

    protected int loadPicture(BufferedImage bufferedImage, POIWorkbookAction pOIWorkbookAction) throws IOException {
        return ExportUtils.loadPicture(bufferedImage, pOIWorkbookAction);
    }

    protected void applyReportHFHeader(ReportHFProvider reportHFProvider, POIHeaderFooterAction pOIHeaderFooterAction) {
        ExportUtils.applyReportHFHeader(reportHFProvider, pOIHeaderFooterAction);
    }

    protected void applyReportHFFooter(ReportHFProvider reportHFProvider, POIHeaderFooterAction pOIHeaderFooterAction) {
        ExportUtils.applyReportHFFooter(reportHFProvider, pOIHeaderFooterAction);
    }

    protected boolean checkInvalidFormula(String string) {
        StringReader stringReader = new StringReader(string);
        FRLexer fRLexer = new FRLexer((Reader)stringReader);
        FRParser fRParser = new FRParser((TokenStream)fRLexer);
        Expression expression = null;
        try {
            expression = fRParser.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return expression != null;
    }

    protected void setDefaultFont(POIWorkbookAction pOIWorkbookAction) {
        POIFontAction pOIFontAction = pOIWorkbookAction.getFontAt((short)0);
        pOIFontAction.setCharSet((byte)1);
        pOIFontAction.setFontHeightInPoints((short)11);
        pOIFontAction.setFontName(Inter.getLocText((String)"FR-Base-Song_TypeFace"));
    }

    protected void exportBook(ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, boolean bl) throws Exception {
        this.exportBook(resultWorkBook, pOIWorkbookAction, list, list2, list3, bl, null);
    }

    protected void exportBook(ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, boolean bl, int[] nArray) throws Exception {
        Report report;
        int n2;
        int n3 = resultWorkBook.getReportCount();
        for (n2 = 0; n2 < n3; ++n2) {
            report = resultWorkBook.getReport(n2);
            list3.add(report);
            while (report instanceof PackedReport) {
                report = ((PackedReport)report).getPackee();
                list3.set(n2, report);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray != null && !ArrayUtils.contains((int[])nArray, (int)n2)) continue;
            report = list3.get(n2);
            this.processResultEC(report, resultWorkBook, pOIWorkbookAction, list, list2, list3, n2);
        }
    }

    private void processResultEC(Object object, ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, int n2) {
        if (!(object instanceof ResultECReport)) {
            return;
        }
        ResultECReport resultECReport = (ResultECReport)(object = ((ResultECReport)object).processWidgetAsImage((ResultECReport)object));
        if (!resultECReport.cellIterator().hasNext()) {
            PageRWorkSheet pageRWorkSheet = new PageRWorkSheet();
            Iterator iterator = resultECReport.floatIterator();
            while (iterator.hasNext()) {
                pageRWorkSheet.addFloatElement((FloatElement)iterator.next());
            }
            pageRWorkSheet.addCellElement(new DefaultPageCellElement(0, 0, ""));
            resultECReport = pageRWorkSheet;
        }
        this.innerExportReports(resultECReport, resultWorkBook, pOIWorkbookAction, list, list2, list3, n2);
    }

    protected Style adjustProperFontSize(Style style) {
        FRFont fRFont = style.getFRFont();
        int n2 = fRFont.getSize();
        if (n2 > 14 && style.getTextStyle() == 0) {
            fRFont = fRFont.applySize((float)((int)((double)n2 * 0.95)));
            return style.deriveFRFont(fRFont);
        }
        return style;
    }

    protected abstract void innerExportReports(ResultECReport var1, ResultWorkBook var2, POIWorkbookAction var3, List var4, List<String> var5, List<Report> var6, int var7);

    protected String replaceNewLineChar(String string) {
        return ExportUtils.replaceNewLineChar(string);
    }

    protected POIPictureLocation locateFloatElementInExcel(FloatElement floatElement, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, ElementCase elementCase, Object object) {
        int n2;
        Object[] objectArray = ReportHelper.calculateLastColumnAndRowOfFloatElement(elementCase, floatElement);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        l2 = floatElement.getLeftDistance().toFU();
        l3 = floatElement.getTopDistance().toFU();
        l4 = ((UNIT)objectArray[1]).toFU();
        l5 = ((UNIT)objectArray[2]).toFU();
        Point point = ReportHelper.calculateStartColumnAndRowOfFloatElement(elementCase, floatElement);
        int n3 = point.x;
        int n4 = point.y;
        int n5 = ((Point)objectArray[0]).x;
        int n6 = ((Point)objectArray[0]).y;
        int n7 = FU.getInstance((long)l2).toPixI(96);
        int n8 = FU.getInstance((long)l3).toPixI(96);
        int n9 = FU.getInstance((long)l4).toPixI(96);
        int n10 = FU.getInstance((long)l5).toPixI(96);
        int n11 = 0;
        int n12 = 0;
        for (n2 = n3; n2 > 0; --n2) {
            n11 = (int)((double)n11 + dynamicUnitList2.get(n3).toPixD(96));
        }
        for (n2 = n4; n2 > 0; --n2) {
            n12 = (int)((double)n12 + dynamicUnitList.get(n4).toPixD(96));
        }
        n7 = n7 > n11 ? n7 - n11 : 0;
        n8 = n8 > n12 ? n8 - n12 : 0;
        return this.locateFloatElementInExcel(dynamicUnitList, dynamicUnitList2, n5, n6, n9, n10, n3, n4, n7, n8, objectArray);
    }

    private POIPictureLocation locateFloatElementInExcel(DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object[] objectArray) {
        double d2 = dynamicUnitList2.get(n6).toPixD(96);
        double d3 = dynamicUnitList.get(n7).toPixD(96);
        double d4 = dynamicUnitList2.get(n2).toPixD(96);
        double d5 = dynamicUnitList.get(n3).toPixD(96);
        int n10 = this.getFloatLeftMax(d2);
        int n11 = this.getFloatTopMax(d3);
        int n12 = this.getFloatLeftMax(d4);
        int n13 = this.getFloatTopMax(d5);
        n8 = (int)(new Double(n8) / d2 * (double)n10);
        n9 = (int)(new Double(n9) / d3 * (double)n11);
        n4 = (int)(new Double(n4) / d4 * (double)n12);
        n5 = (int)(new Double(n5) / d5 * (double)n13);
        n8 = n8 < n10 ? n8 : n10;
        n9 = n9 < n11 ? n9 : n11;
        n4 = n4 < n10 ? n4 : n12;
        n5 = n5 < n11 ? n5 : n13;
        return new POIPictureLocation(n8, n9, n4, n5, (short)n6, n7, (short)((Point)objectArray[0]).x, ((Point)objectArray[0]).y);
    }

    protected void setColumnRowBreak(CellElement cellElement, POISheetAction pOISheetAction, int n2, int n3, int n4, int n5) {
        if (this.totalBreak > 1000) {
            return;
        }
        CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
        if (cellPageAttr == null) {
            return;
        }
        if (cellPageAttr.isPageBeforeColumn() && n2 > 1) {
            ++this.totalBreak;
            pOISheetAction.setColumnBreak((short)(n2 - 1));
        }
        if (cellPageAttr.isPageAfterColumn() && n4 < ExportConstants.MAX_COLS - 1) {
            ++this.totalBreak;
            pOISheetAction.setColumnBreak((short)n4);
        }
        if (cellPageAttr.isPageBeforeRow() && n3 > 1) {
            ++this.totalBreak;
            pOISheetAction.setRowBreak(n3 - 1);
        }
        if (cellPageAttr.isPageAfterRow() && n5 < ExportConstants.MAX_ROWS - 1) {
            ++this.totalBreak;
            pOISheetAction.setRowBreak(n5);
        }
    }

    protected POIRichStringAction html2HSSFRichTextString(POIWorkbookAction pOIWorkbookAction, String string, Style style) throws Exception {
        RichText richText = RichTextConverter.html2RichText(string, style);
        String string2 = richText.getContent();
        POIRichStringAction pOIRichStringAction = this.initRichString(string2);
        int n2 = 0;
        int n3 = 0;
        Iterator<RichChar> iterator = richText.charIterator();
        while (iterator.hasNext()) {
            RichChar richChar = iterator.next();
            POIFontAction pOIFontAction = this.createFont(pOIWorkbookAction, (java.awt.Font)richChar.getFont());
            pOIRichStringAction.applyFont(n2, n3 += richChar.getTextLength(), pOIFontAction);
            n2 = n3;
        }
        return pOIRichStringAction;
    }

    protected Object evalHtmlContent(POIWorkbookAction pOIWorkbookAction, Object object, Style style, int n2, int n3) {
        POIRichStringAction pOIRichStringAction = null;
        try {
            String string = Utils.objectToString((Object)object);
            pOIRichStringAction = this.html2HSSFRichTextString(pOIWorkbookAction, string, style);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(Inter.getLocText((String)"FR-Engine-NS_export_excelHtml"));
        }
        if (pOIRichStringAction != null) {
            return pOIRichStringAction.getRichString();
        }
        return PaintUtils.createHTMLContentBufferedImage(object.toString(), new Rectangle(n2, n3), 1, 1, style);
    }

    protected abstract POIRichStringAction initRichString(String var1);

    protected abstract Object evalFormulaValue(Object var1, boolean var2, boolean var3, List var4, POICellAction var5, Calculator var6, List var7);

    protected Object evalCellValue(CellElement cellElement, boolean bl, boolean bl2, List list, POICellAction pOICellAction, Calculator calculator, Style style, List list2, CellGUIAttr cellGUIAttr, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2, int n3, int n4, int n5, POIWorkbookAction pOIWorkbookAction) {
        Object object = cellElement.getShowValue();
        if (object == null) {
            object = "";
        }
        if (object instanceof Formula) {
            object = this.evalFormulaValue(object, bl, bl2, list, pOICellAction, calculator, list2);
        } else if (object instanceof PageCalObj) {
            object = cellElement.getValue();
        } else {
            int n6 = style.getTextStyle();
            object = Utils.resolveOtherValue((Object)object, (boolean)cellGUIAttr.isShowAsImage(), (PresentationType)PresentationType.EXPORT);
            int n7 = dynamicUnitList2.getRangeValue(n2, n2 + n4).toPixI(96);
            int n8 = dynamicUnitList.getRangeValue(n3, n3 + n5).toPixI(96);
            if (this.isShowAsImage(n6, cellGUIAttr) && !CustomConfigManager.getInstance().isExportFullImg4Excel()) {
                object = CellUtils.value2ImageWithBackground(object, 96, style, n7, n8);
            }
            if (cellGUIAttr.isShowAsDownload() && !this.isPrintableValue(cellElement.getValue())) {
                object = "";
            }
            if (cellGUIAttr.isShowAsHTML()) {
                object = this.evalHtmlContent(pOIWorkbookAction, object, style, n7, n8);
            }
            if (style.getVerticalText() == 1) {
                object = this.checkValueVertical(object, style, n7, n8);
            }
        }
        Set set = ExtraClassManager.getInstance().getArray("ExcelExportCellValueProvider");
        for (ExcelExportCellValueProvider excelExportCellValueProvider : set) {
            object = excelExportCellValueProvider.getCellValue((Object)cellElement, object, (CalculatorProvider)calculator);
        }
        return object;
    }

    private boolean isPrintableValue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Number) {
            return true;
        }
        return object instanceof Date;
    }

    protected static class TextFontAdapter
    implements FontAdapter {
        private Font font;

        protected TextFontAdapter(Font font) {
            this.font = font;
        }

        public boolean equals(Object object) {
            return ComparatorUtils.equals((Object)this.font, (Object)object);
        }

        public String getName() {
            return this.font.getFamilyname();
        }

        public Object getPackee() {
            return this.font;
        }

        public float getSize() {
            return this.font.getSize();
        }

        public boolean isBold() {
            return this.font.isBold();
        }

        public boolean isItalic() {
            return this.font.isItalic();
        }
    }

    public static interface FontAdapter {
        public boolean equals(Object var1);

        public Object getPackee();

        public boolean isBold();

        public boolean isItalic();

        public float getSize();

        public String getName();
    }

    public static class JavaFontAdapter
    implements FontAdapter {
        private java.awt.Font font;

        public JavaFontAdapter(java.awt.Font font) {
            this.font = font;
        }

        public float getSize() {
            return this.font.getSize();
        }

        public boolean isBold() {
            return this.font.isBold();
        }

        public boolean isItalic() {
            return this.font.isItalic();
        }

        public boolean equals(Object object) {
            return ComparatorUtils.equals((Object)this.font, (Object)object);
        }

        public String getName() {
            return this.font.getName();
        }

        public Object getPackee() {
            return this.font;
        }
    }
}

