/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.form.main.Form;
import com.fr.form.ui.PaddingMargin;
import com.fr.form.ui.Widget;
import com.fr.form.ui.container.WAbsoluteLayout;
import com.fr.form.ui.container.WBodyLayoutType;
import com.fr.form.ui.container.WLayout;
import com.fr.form.ui.container.WSortLayout;
import com.fr.form.ui.widget.CRBoundsWidget;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.fun.ReportFitProcessor;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.A.nA;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFitLayout
extends WSortLayout {
    public static final int STATE_FULL = 0;
    public static final int STATE_ORIGIN = 1;
    private static final long serialVersionUID = -2411890197815749646L;
    private static final double DEFAULT_PERCENT = 1.0;
    public static final int SCROLL_BAR_WIDTH = 18;
    private int compState = 0;
    private WBodyLayoutType layoutType = WBodyLayoutType.FIT;
    private double resolutionScaling = 1.0;
    private int containerWidth = 960;
    private int containerHeight = 540;
    private int MIN_INTERVAL = 5;
    private boolean hasResized = false;
    private boolean appRelayout = true;
    private List<CRBoundsWidget> rightWidgets;
    private List<CRBoundsWidget> leftWidgets;
    private List<CRBoundsWidget> downWidgets;
    private List<CRBoundsWidget> upWidgets;
    private JSONArray extendInfo;

    public WFitLayout() {
    }

    public WFitLayout(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            this.setWidgetName(string);
        }
    }

    @Override
    public String getLayoutToolTip() {
        return Inter.getLocText((String)"FR-Designer-Layout_Adaptive_Layout");
    }

    @Override
    public boolean canCurrentMarginAvailable(PaddingMargin paddingMargin) {
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.getWidget(i2);
            Rectangle rectangle = cRBoundsWidget.getBounds();
            Rectangle rectangle2 = new Rectangle(rectangle);
            if (rectangle.x == 0) {
                rectangle2.width -= paddingMargin.getLeft();
            }
            if (rectangle.y == 0) {
                rectangle2.height -= paddingMargin.getTop();
            }
            if (rectangle.x + rectangle.width == this.containerWidth) {
                rectangle2.width -= paddingMargin.getRight();
            }
            if (rectangle.y + rectangle.height == this.containerHeight) {
                rectangle2.height -= paddingMargin.getBottom();
            }
            if (rectangle2.width >= MIN_WIDTH && rectangle2.height >= MIN_HEIGHT) continue;
            return false;
        }
        return true;
    }

    @Override
    public Dimension getMinDesignSize() {
        return new Dimension(MIN_WIDTH * this.getHorComps().length, MIN_HEIGHT * this.getVertiComps().length);
    }

    public int[] getVertiComps() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        arrayList.add(this.containerHeight);
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.getWidget(i2);
            Rectangle rectangle = cRBoundsWidget.getBounds();
            if (arrayList.contains(rectangle.y)) continue;
            arrayList.add(rectangle.y);
        }
        Collections.sort(arrayList);
        return ArrayUtils.toPrimitive((Integer[])arrayList.toArray(new Integer[]{arrayList.size()}));
    }

    public int[] getHorComps() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        arrayList.add(this.containerWidth);
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.getWidget(i2);
            Rectangle rectangle = cRBoundsWidget.getBounds();
            if (arrayList.contains(rectangle.x)) continue;
            arrayList.add(rectangle.x);
        }
        Collections.sort(arrayList);
        return ArrayUtils.toPrimitive((Integer[])arrayList.toArray(new Integer[]{arrayList.size()}));
    }

    @Override
    public String getXType() {
        return "fit";
    }

    @Override
    public CRBoundsWidget getBoundsWidget(Widget widget) {
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.getWidget(i2);
            if (!ComparatorUtils.equals((Object)cRBoundsWidget.getWidget(), (Object)widget)) continue;
            return cRBoundsWidget;
        }
        return null;
    }

    @Override
    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject;
        if (repository.getDevice().isMobile() && (jSONObject = this.getBodyLayoutType().createMobileJSONConfig(this, repository, calculator, nodeVisitor)) != null) {
            return jSONObject;
        }
        jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("compState", this.compState);
        jSONObject.put("appRelayout", this.appRelayout);
        jSONObject.put("fitLayoutWidth", this.containerWidth);
        jSONObject.put("fitLayoutHeight", this.containerHeight);
        jSONObject.put("hasResized", this.hasResized);
        return jSONObject;
    }

    public void initWidgetsList() {
        this.rightWidgets = new ArrayList<CRBoundsWidget>();
        this.leftWidgets = new ArrayList<CRBoundsWidget>();
        this.downWidgets = new ArrayList<CRBoundsWidget>();
        this.upWidgets = new ArrayList<CRBoundsWidget>();
    }

    public void calculateRelatedJson(Rectangle rectangle, CRBoundsWidget cRBoundsWidget, JSONObject jSONObject) throws Exception {
        this.extendInfo = JSONArray.create();
        this.calculateRelatedWidgets(rectangle, cRBoundsWidget);
        jSONObject.put("extendInfo", (Object)this.extendInfo);
    }

    public void calculateRelatedWidgets(Rectangle rectangle, CRBoundsWidget cRBoundsWidget) throws Exception {
        this.calculateRelatedComponent(cRBoundsWidget.getBounds());
        cRBoundsWidget.setVisible(false);
        cRBoundsWidget.setBounds(new Rectangle(rectangle.x, rectangle.y, 0, 0));
    }

    public void calculateRelatedComponent(Rectangle rectangle) throws Exception {
        if (this.getWidgetCount() == 0) {
            return;
        }
        this.initWidgetsList();
        this.calculateRelated(rectangle);
        if (this.rightWidgets.size() > 0 && this.getAllCompHeight(this.rightWidgets) == rectangle.height) {
            for (int i2 = 0; i2 < this.rightWidgets.size(); ++i2) {
                this.addExtendInfo(this.rightWidgets.get(i2).getWidgetName(), "right");
                Rectangle rectangle2 = this.rightWidgets.get(i2).getBounds();
                this.rightWidgets.get(i2).setBounds(new Rectangle(rectangle2.x - rectangle.width, rectangle2.y, rectangle2.width + rectangle.width, rectangle2.height));
            }
        } else if (this.leftWidgets.size() > 0 && this.getAllCompHeight(this.leftWidgets) == rectangle.height) {
            for (int i3 = 0; i3 < this.leftWidgets.size(); ++i3) {
                this.addExtendInfo(this.leftWidgets.get(i3).getWidgetName(), "left");
                Rectangle rectangle3 = this.leftWidgets.get(i3).getBounds();
                this.leftWidgets.get(i3).setBounds(new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width + rectangle.width, rectangle3.height));
            }
        } else if (this.downWidgets.size() > 0 && this.getAllCompWidth(this.downWidgets) == rectangle.width) {
            for (int i4 = 0; i4 < this.downWidgets.size(); ++i4) {
                this.addExtendInfo(this.downWidgets.get(i4).getWidgetName(), "down");
                Rectangle rectangle4 = this.downWidgets.get(i4).getBounds();
                this.downWidgets.get(i4).setBounds(new Rectangle(rectangle4.x, rectangle4.y - rectangle.height, rectangle4.width, rectangle4.height + rectangle.height));
            }
        } else if (this.upWidgets.size() > 0 && this.getAllCompWidth(this.upWidgets) == rectangle.width) {
            for (int i5 = 0; i5 < this.upWidgets.size(); ++i5) {
                this.addExtendInfo(this.upWidgets.get(i5).getWidgetName(), "up");
                Rectangle rectangle5 = this.upWidgets.get(i5).getBounds();
                this.upWidgets.get(i5).setBounds(new Rectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height + rectangle.height));
            }
        } else {
            this.calculateNoRelatedWidget(rectangle);
        }
    }

    private void addExtendInfo(String string, String string2) throws Exception {
        if (this.extendInfo != null) {
            JSONObject jSONObject = JSONObject.create();
            jSONObject.put("widgetName", (Object)string);
            jSONObject.put("extendDirection", (Object)string2);
            this.extendInfo.put((Object)jSONObject);
        }
    }

    private void calculateRelated(Rectangle rectangle) throws Exception {
        int n2 = rectangle.y;
        int n3 = rectangle.x;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = this.getWidgetCount();
        for (int i2 = 0; i2 < n6; ++i2) {
            boolean bl;
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.getWidget(i2);
            Rectangle rectangle2 = cRBoundsWidget.getBounds();
            int n7 = rectangle2.x;
            int n8 = rectangle2.y;
            int n9 = rectangle2.width;
            int n10 = rectangle2.height;
            if (n9 == 0 || n10 == 0) continue;
            int n11 = n8 - n2;
            int n12 = n7 - n3;
            boolean bl2 = n11 >= 0 && n5 >= n10 + n11;
            boolean bl3 = bl = n12 >= 0 && n4 >= n9 + n12;
            if (bl2 && n3 + n4 == n7) {
                this.rightWidgets.add(cRBoundsWidget);
                continue;
            }
            if (bl2 && n3 == n7 + n9) {
                this.leftWidgets.add(cRBoundsWidget);
                continue;
            }
            if (bl && n2 + n5 == n8) {
                this.downWidgets.add(cRBoundsWidget);
                continue;
            }
            if (!bl || n2 != n8 + n10) continue;
            this.upWidgets.add(cRBoundsWidget);
        }
    }

    private void calculateNoRelatedWidget(Rectangle rectangle) throws Exception {
        if (this.getWidgetCount() <= 1) {
            return;
        }
        CRBoundsWidget cRBoundsWidget = this.getRightWidget(rectangle);
        if (cRBoundsWidget == null) {
            return;
        }
        Rectangle rectangle2 = cRBoundsWidget.getBounds();
        int n2 = rectangle2.y;
        if (n2 != rectangle.y) {
            this.calculateNoRelatedWhileRightTop(rectangle, cRBoundsWidget);
        } else {
            this.calculateNoRelatedWhileRightBott(rectangle, cRBoundsWidget);
        }
    }

    private CRBoundsWidget getRightWidget(Rectangle rectangle) {
        int n2 = rectangle.x + rectangle.width + this.MIN_INTERVAL;
        int n3 = rectangle.y;
        return this.getWidget(n2, n3);
    }

    private CRBoundsWidget getWidget(int n2, int n3) {
        int n4 = this.getWidgetCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            boolean bl;
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.getWidget(i2);
            Rectangle rectangle = cRBoundsWidget.getBounds();
            boolean bl2 = bl = n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width && n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height;
            if (!bl) continue;
            return cRBoundsWidget;
        }
        return null;
    }

    private CRBoundsWidget getBottomRightComp(Rectangle rectangle) {
        int n2 = rectangle.x + rectangle.width + this.MIN_INTERVAL;
        int n3 = rectangle.y + rectangle.height - this.MIN_INTERVAL;
        return this.getWidget(n2, n3);
    }

    private void calculateNoRelatedWhileRightTop(Rectangle rectangle, CRBoundsWidget cRBoundsWidget) throws Exception {
        if (cRBoundsWidget == null) {
            return;
        }
        int n2 = cRBoundsWidget.getBounds().y;
        int n3 = cRBoundsWidget.getBounds().height;
        int n4 = cRBoundsWidget.getBounds().width;
        int n5 = rectangle.y - n2;
        if (n3 + n2 == rectangle.y + rectangle.height) {
            cRBoundsWidget.getBounds().width = n4;
            cRBoundsWidget.getBounds().height = n5;
            if (this.extendInfo != null) {
                JSONObject jSONObject = JSONObject.create();
                jSONObject.put("widgetName", (Object)cRBoundsWidget.getWidgetName());
                jSONObject.put("extendDirection", (Object)"up");
                jSONObject.put("trisection", true);
                this.extendInfo.put((Object)jSONObject);
            }
            rectangle.width += n4;
        } else {
            rectangle.y = n2 + n3;
            rectangle.height = rectangle.height + rectangle.y - n3 - n2;
            this.calculateRelatedComponent(rectangle);
            rectangle.height = n2 + n3 - rectangle.y;
            this.calculateRelatedComponent(rectangle);
            return;
        }
        this.calculateRelatedComponent(rectangle);
    }

    public void calculateNoRelatedWhileRightBott(Rectangle rectangle, CRBoundsWidget cRBoundsWidget) throws Exception {
        cRBoundsWidget = this.getBottomRightComp(rectangle);
        int n2 = cRBoundsWidget.getBounds().y;
        int n3 = cRBoundsWidget.getBounds().height;
        int n4 = cRBoundsWidget.getBounds().width;
        int n5 = n2 + n3 - cRBoundsWidget.getBounds().y - cRBoundsWidget.getBounds().height;
        if (n2 == cRBoundsWidget.getBounds().y) {
            cRBoundsWidget.getBounds().width = n4;
            cRBoundsWidget.getBounds().height = n5;
            if (this.extendInfo != null) {
                JSONObject jSONObject = JSONObject.create();
                jSONObject.put("widgetName", (Object)cRBoundsWidget.getWidgetName());
                jSONObject.put("extendDirection", (Object)"down");
                jSONObject.put("trisection", true);
                this.extendInfo.put((Object)jSONObject);
            }
            rectangle.width += n4;
        } else {
            rectangle.height = n2 - rectangle.y;
            this.calculateRelatedComponent(rectangle);
            rectangle.y = n2;
            rectangle.height = rectangle.height - n2 + rectangle.y;
            this.calculateRelatedComponent(rectangle);
            return;
        }
        this.calculateRelatedComponent(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public int getAllCompHeight(List<CRBoundsWidget> list) {
        int n2 = 0;
        if (list.isEmpty()) {
            return n2;
        }
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += list.get((int)i2).getBounds().height;
        }
        return n2;
    }

    public int getAllCompWidth(List<CRBoundsWidget> list) {
        int n2 = 0;
        if (list.isEmpty()) {
            return n2;
        }
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += list.get((int)i2).getBounds().width;
        }
        return n2;
    }

    public void processFitLayoutMargin() {
        for (int i2 = 0; i2 < this.widgetList.size(); ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.widgetList.get(i2);
            Rectangle rectangle = cRBoundsWidget.getBounds();
            Rectangle rectangle2 = new Rectangle(rectangle);
            if (rectangle.x == 0) {
                rectangle2.x = (int)((double)rectangle2.x + (double)this.margin.getLeft() / this.resolutionScaling);
                rectangle2.width = (int)((double)rectangle2.width - (double)this.margin.getLeft() / this.resolutionScaling);
            }
            if (rectangle.x + rectangle.width == this.containerWidth) {
                rectangle2.width = (int)((double)rectangle2.width - (double)this.margin.getRight() / this.resolutionScaling);
            }
            if (rectangle.y == 0) {
                rectangle2.y = (int)((double)rectangle2.y + (double)this.margin.getTop() / this.resolutionScaling);
                rectangle2.height = (int)((double)rectangle2.height - (double)this.margin.getTop() / this.resolutionScaling);
            }
            if (rectangle.y + rectangle.height == this.containerHeight) {
                rectangle2.height = (int)((double)rectangle2.height - (double)this.margin.getBottom() / this.resolutionScaling);
            }
            rectangle2.y = (int)((double)rectangle2.y - (double)this.margin.getTop() / this.resolutionScaling);
            rectangle2.x = (int)((double)rectangle2.x - (double)this.margin.getLeft() / this.resolutionScaling);
            rectangle.setBounds(rectangle2);
            cRBoundsWidget.getWidget().updateChildBounds(rectangle2);
        }
    }

    public int getActualWidth() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.widgetList.size(); ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.widgetList.get(i2);
            Rectangle rectangle = cRBoundsWidget.getBounds();
            if (rectangle.x + rectangle.width <= n2) continue;
            n2 = rectangle.x + rectangle.width;
        }
        return n2;
    }

    public int getActualHeight() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.widgetList.size(); ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.widgetList.get(i2);
            Rectangle rectangle = cRBoundsWidget.getBounds();
            if (rectangle.y + rectangle.height <= n2) continue;
            n2 = rectangle.y + rectangle.height;
        }
        return n2;
    }

    public void processFitLayoutInterval(int n2, int n3) {
        if (this.compInterval == 0) {
            return;
        }
        int n4 = this.compInterval / 2;
        for (int i2 = 0; i2 < this.widgetList.size(); ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.widgetList.get(i2);
            Rectangle rectangle = cRBoundsWidget.getBounds();
            Rectangle rectangle2 = new Rectangle(rectangle);
            if (rectangle.x > 0) {
                rectangle2.x += n4;
                rectangle2.width -= n4;
            }
            if (rectangle.width + rectangle.x < n2) {
                rectangle2.width -= n4;
            }
            if (rectangle.y > 0) {
                rectangle2.y += n4;
                rectangle2.height -= n4;
            }
            if (rectangle.height + rectangle.y < n3) {
                rectangle2.height -= n4;
            }
            rectangle.setBounds(rectangle2);
        }
    }

    @Override
    protected JSONArray createJSONItems(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        Collections.sort(this.widgetList);
        ReportFitProcessor reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor");
        if (reportFitProcessor == null && !repository.getDevice().isMobile()) {
            this.processFitLayoutMargin();
        }
        return super.createJSONItems(repository, calculator, nodeVisitor);
    }

    public void setBounds(Widget widget, Rectangle rectangle) {
        CRBoundsWidget cRBoundsWidget = this.getBoundsWidget(widget);
        if (cRBoundsWidget != null) {
            cRBoundsWidget.setBounds(rectangle);
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("WidgetZoomAttr".equals(string)) {
                this.setCompState(xMLableReader.getAttrAsInt("compState", 0));
            } else if ("AppRelayout".equals(string)) {
                this.setAppRelayout(xMLableReader.getAttrAsBoolean("appRelayout", true));
            } else if ("Size".equals(string)) {
                this.setContainerWidth(xMLableReader.getAttrAsInt("width", 960));
                this.setContainerHeight(xMLableReader.getAttrAsInt("height", 540));
            } else if (string.equals("ResolutionScalingAttr")) {
                this.setResolutionScaling(xMLableReader.getAttrAsDouble("percent", 1.0));
            } else if ("BodyLayoutType".equals(string)) {
                this.setLayoutType(WBodyLayoutType.parse(xMLableReader.getAttrAsInt("type", WBodyLayoutType.FIT.getTypeValue())));
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("WidgetZoomAttr").attr("compState", this.compState).end();
        xMLPrintWriter.startTAG("AppRelayout").attr("appRelayout", this.appRelayout).end();
        xMLPrintWriter.startTAG("Size").attr("width", this.containerWidth).attr("height", this.containerHeight).end();
        xMLPrintWriter.startTAG("ResolutionScalingAttr").attr("percent", this.resolutionScaling).end();
        this.writeLayoutTypeAttr(xMLPrintWriter);
    }

    protected void writeLayoutTypeAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("BodyLayoutType").attr("type", this.layoutType.getTypeValue()).end();
    }

    public int getCompState() {
        return this.compState;
    }

    public void setCompState(int n2) {
        this.compState = n2;
    }

    public double getResolutionScaling() {
        return this.resolutionScaling;
    }

    public void setResolutionScaling(double d2) {
        this.resolutionScaling = d2;
    }

    public WBodyLayoutType getBodyLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(WBodyLayoutType wBodyLayoutType) {
        this.layoutType = wBodyLayoutType;
    }

    public int getContainerWidth() {
        return this.containerWidth;
    }

    public void setContainerWidth(int n2) {
        this.containerWidth = n2;
    }

    public int getContainerHeight() {
        return this.containerHeight;
    }

    public void setContainerHeight(int n2) {
        this.containerHeight = n2;
    }

    public boolean isAppRelayout() {
        return this.appRelayout;
    }

    public void setAppRelayout(boolean bl) {
        this.appRelayout = bl;
    }

    public int getContentWidth() {
        return this.containerWidth;
    }

    public int getContentHeight() {
        return this.containerHeight;
    }

    @Override
    public void setCompVisible(Widget widget, JSONObject jSONObject, boolean bl, Form form, int n2, int n3) throws Exception {
        this.backupBoundsWidget(this);
        WAbsoluteLayout.BoundsWidget boundsWidget = (WAbsoluteLayout.BoundsWidget)this.getBoundsWidget(widget);
        if (!bl) {
            this.calculateRelatedJson(boundsWidget.getBounds(), boundsWidget, jSONObject);
            boundsWidget.setVisible(false);
        } else {
            this.dealVisibleWidget(form, this, boundsWidget, n2, n3, jSONObject);
        }
    }

    public void backupBoundsWidget(WFitLayout wFitLayout) {
        int n2 = wFitLayout.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            WAbsoluteLayout.BoundsWidget boundsWidget = (WAbsoluteLayout.BoundsWidget)wFitLayout.getWidget(i2);
            if (boundsWidget.getBeforeScaleBounds() != null) continue;
            boundsWidget.setBeforeScaleBounds(new Rectangle(boundsWidget.getBounds()));
        }
    }

    private void dealVisibleWidget(Form form, WFitLayout wFitLayout, WAbsoluteLayout.BoundsWidget boundsWidget, int n2, int n3, JSONObject jSONObject) throws Exception {
        Object object;
        int n4;
        JSONArray jSONArray = JSONArray.create();
        boundsWidget.setVisible(true);
        ArrayList<WAbsoluteLayout.BoundsWidget> arrayList = new ArrayList<WAbsoluteLayout.BoundsWidget>();
        for (n4 = 0; n4 < this.getWidgetCount(); ++n4) {
            object = (WAbsoluteLayout.BoundsWidget)wFitLayout.getWidget(n4);
            if (object.isVisible()) continue;
            arrayList.add((WAbsoluteLayout.BoundsWidget)object);
        }
        this.setAllVisible(wFitLayout, arrayList);
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            if (boundsWidget.getWidgetName().equals(((WAbsoluteLayout.BoundsWidget)arrayList.get(n4)).getWidgetName())) continue;
            wFitLayout.calculateRelatedWidgets(((WAbsoluteLayout.BoundsWidget)arrayList.get(n4)).getBounds(), (CRBoundsWidget)arrayList.get(n4));
        }
        Form form2 = (Form)((Object)form.clone());
        object = (WFitLayout)form2.getWidgetByName("body");
        form2.resizeFormWithBrowser(n2, n3);
        Widget widget = form2.getWidgetWithBound(boundsWidget.getWidgetName());
        WFitLayout wFitLayout2 = (WFitLayout)nA.A((WLayout)((Object)object), widget);
        int n5 = wFitLayout2.getWidgetCount();
        for (int i2 = 0; i2 < n5; ++i2) {
            JSONObject jSONObject2 = JSONObject.create();
            WAbsoluteLayout.BoundsWidget boundsWidget2 = (WAbsoluteLayout.BoundsWidget)wFitLayout2.getWidget(i2);
            Rectangle rectangle = boundsWidget2.getBounds();
            jSONObject2.put("widgetName", (Object)boundsWidget2.getWidgetName());
            jSONObject2.put("x", rectangle.getBounds().x);
            jSONObject2.put("y", rectangle.getBounds().y);
            jSONObject2.put("width", rectangle.getBounds().width);
            jSONObject2.put("height", rectangle.getBounds().height);
            jSONArray.put((Object)jSONObject2);
        }
        jSONObject.put("widgetSizeInfo", (Object)jSONArray);
    }

    public void setAllVisible(WFitLayout wFitLayout, List<WAbsoluteLayout.BoundsWidget> list) throws Exception {
        for (int i2 = 0; i2 < wFitLayout.getWidgetCount(); ++i2) {
            WAbsoluteLayout.BoundsWidget boundsWidget = (WAbsoluteLayout.BoundsWidget)wFitLayout.getWidget(i2);
            Rectangle rectangle = new Rectangle(boundsWidget.getBeforeScaleBounds());
            boundsWidget.setVisible(true);
            boundsWidget.setBounds(rectangle);
        }
    }

    public void setHasResized(boolean bl) {
        this.hasResized = bl;
    }

    @Override
    public void resize(double d2, double d3, double d4) {
        ReportFitProcessor reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor");
        if (reportFitProcessor == null) {
            this.resizeFitLayout(d2, d3, d4);
            return;
        }
        reportFitProcessor.resizeFitLayout((Widget)this, d2, d3, d4);
    }

    public void resizeFitLayout(double d2, double d3, double d4) {
        if (this.getCompState() != 0) {
            d2 -= 18.0;
        }
        this.processFitLayoutMargin();
        this.processFitLayoutInterval(this.getActualWidth(), this.getActualHeight());
        PaddingMargin paddingMargin = this.getMargin();
        double d5 = (d2 -= (double)(paddingMargin.getLeft() + paddingMargin.getRight())) / ((double)this.getContentWidth() - (double)paddingMargin.getLeft() / this.getResolutionScaling() - (double)paddingMargin.getRight() / this.getResolutionScaling());
        double d6 = (d3 -= (double)(paddingMargin.getBottom() + paddingMargin.getTop())) / ((double)this.getContentHeight() - (double)paddingMargin.getTop() / this.getResolutionScaling() - (double)paddingMargin.getBottom() / this.getResolutionScaling());
        this.setHasResized(d5 != 1.0 || d6 != 1.0);
        if (this.getCompState() != 0) {
            d3 = (double)this.getContentHeight() * d5;
            d6 = d5;
        }
        d4 = d4 == -1.0 ? 1.0 : d6;
        this.setContainerWidth((int)d2);
        this.setContainerHeight((int)d3);
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Widget widget = this.getWidget(i2);
            widget.resize(d5, d6, d4);
        }
    }

    public void dealInvisible() throws Exception {
        this.backupBoundsWidget(this);
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            WAbsoluteLayout.BoundsWidget boundsWidget = (WAbsoluteLayout.BoundsWidget)this.getWidget(i2);
            Widget widget = boundsWidget.getWidget();
            Rectangle rectangle = boundsWidget.getBounds();
            if (!widget.isVisible()) {
                this.calculateRelatedComponent(new Rectangle(boundsWidget.getBounds()));
                boundsWidget.setBounds(new Rectangle(rectangle.x, rectangle.y, 0, 0));
                boundsWidget.setVisible(false);
                continue;
            }
            widget.dealInvisible();
        }
    }
}

