/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util.svg;

import com.mxgraph.util.svg.DefaultErrorHandler;
import com.mxgraph.util.svg.ErrorHandler;
import com.mxgraph.util.svg.NormalizingReader;
import com.mxgraph.util.svg.ParseException;
import com.mxgraph.util.svg.Parser;
import com.mxgraph.util.svg.StringNormalizingReader;
import java.io.IOException;
import java.util.MissingResourceException;

public abstract class AbstractParser
implements Parser {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.parser.resources.Messages";
    protected ErrorHandler errorHandler = new DefaultErrorHandler();
    protected NormalizingReader reader;
    protected int current;

    public int getCurrent() {
        return this.current;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void parse(String s) throws ParseException {
        try {
            this.reader = new StringNormalizingReader(s);
            this.doParse();
        }
        catch (IOException e) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), e));
        }
    }

    protected abstract void doParse() throws ParseException, IOException;

    protected void reportError(String key, Object[] args) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage(key, args), this.reader.getLine(), this.reader.getColumn()));
    }

    protected void reportCharacterExpectedError(char expectedChar, int currentChar) {
        this.reportError("character.expected", new Object[]{new Character(expectedChar), new Integer(currentChar)});
    }

    protected void reportUnexpectedCharacterError(int currentChar) {
        this.reportError("character.unexpected", new Object[]{new Integer(currentChar)});
    }

    protected String createErrorMessage(String key, Object[] args) {
        try {
            return "";
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    protected String getBundleClassName() {
        return BUNDLE_CLASSNAME;
    }

    protected void skipSpaces() throws IOException {
        while (true) {
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            this.current = this.reader.read();
        }
    }

    protected void skipCommaSpaces() throws IOException {
        block6: while (true) {
            switch (this.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.current = this.reader.read();
                    continue block6;
                }
            }
            break;
        }
        if (this.current == 44) {
            block7: while (true) {
                this.current = this.reader.read();
                switch (this.current) {
                    default: {
                        break block7;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block7;
                    }
                }
                break;
            }
        }
    }
}

