FS.REGISTER = {
    init : function(renderer){
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_register.css', 'css');
        this.initData(renderer);
    },
    initContainer:function(renderer){
        var self = this;
        var register_type =this.getRegisterType();
        var items = [self.createVersionInfoPane(register_type),self.createFunctionList()];
        self.registerTabPane = new FS.LTabPane({
            width:'100%',
            height:'100%',
            items: items,
            style: 'blue',
            vgap:21,
            widgetName:'visitorManagerTabPane',
            renderEl: renderer,
            initAfterActions : [
                function() {
                	this.getWidgetByName("versionInfoTable").element.css({
                		'-webkit-user-select' : 'initial',
                		'-moz-user-select' : 'initial',
                		 'width':'900px'
                	});
                },
                function () {
                }
            ]
        });
    },
    getRegisterType:function(){
        var register_type = 0;
        if(FS.config.isLicExist != 'true') {
            //未注册
            register_type = 0;
        } else {
            //已注册
            if(this.isRegisterSuccess()){
                //注册成功
                register_type = 1;
            }else{
                //注册失败
                register_type = 2;
            }
        }
        return  register_type;
    },

    //判断是否注册成功
    isRegisterSuccess: function(){
        var info = this.data.appinfo;
        if (info) {
            if (this.isOnlineCheck) {
                return info["Re-online-match"];
            }
            return info["Re-appname-match"] && info["Re-version-match"]
                && info["Re-uuid-match"] && info["Re-mac-match"]
                && !info['Re-lic-out-date'] && info["Re-appcontent-match"]

        }
        return false;
    },

    createVersionInfoPane:function(register_type){
    	var panelHeight = this.macinfo.length * 25 + 390;
        var versionInfoConfig = {
            title:FR.i18nText("FS-Reg-Version_Info"),
            content:{
                widgetName:'versionInfoPanel',
                type: 'panel',
                width: 850,
                height: panelHeight,
                doSize: true,
//                contentWidget:{
//                    type:'absolute',
//                    items:[]
//                }   //this._createVersionInfoTable(register_type)
                contentWidget:this._createVersionInfoTable(register_type)
            }
        }
        return versionInfoConfig;
    },
    _createVersionInfoTable:function(register_type){
        var rowSize;
        var items =[
            [
                {el:$('<div/>')},
                {el : {type: 'llabel',levelStyle:1,value: FR.i18nText("FS-Reg_Version_Registration")}} ,
                {el:$('<div/>')}
            ],
            [
                {el:$('<div/>')},
                {el :this._createVersionInfoLabel(register_type)} , // this._createVersionInfoLabel(register_type)
                {el:$('<div/>')}
            ],
            [
                {el:$('<div/>')},
                {el:this._getFileLoad(register_type)},            //this._getFileLoad(register_type)
                {el:$('<div/>')}
            ],
            [
                {el:$('<div/>')},
                {el : {type: 'llabel',levelStyle:1,value: FR.i18nText("FS-Reg-Bind_Info")}},
                {el:$('<div/>')}
            ],
            [
                {el:$('<div/>')},
                {el:this._createInfoTable(register_type)},//
                {el:$('<div/>')}
            ]
        ];
        items.push([
            {el: $('<div/>')},
            {el: this._createExportInfo()},//this._createInfoTable(register_type)
            {el: $('<div/>')}
        ]);
        var macInfoTableHeight = Math.max(25 * this.macinfo.length + 135, 180);
        rowSize = [28, 25, 40, 28, macInfoTableHeight, 40];

        var  visitorViewConfig = {
            widgetName: 'versionInfoTable',
            type: 'tablelayout',
            items:items,
            columnSize : [17,731,50],
            rowSize : rowSize,
            width:830,
            vgap : 10
        }
        return visitorViewConfig;
    },
    _createExportInfo: function () {
        var self = this;
        return {
            type: 'absolute',
            items: [
                {
                    x: 0,
                    y: 5,
                    type: 'quickbutton',
                    text: FR.i18nText('FS-Reg-Export_Info'),
                    width: FR.i18nTextWidth('FS-Reg-Export_Info') + 30,
                    height: 33,
                    handler: function() {
                        window.location = FR.servletURL + "?op=fs_manager&cmd=export_registrationinformation";
                    }
                },
                {
                    x: FR.i18nTextWidth('FS-Reg-Export_Info') + 50,
                    y: 13,
                    el: self._createEmailLink()
                }
            ]
        }
    },
    _createEmailLink: function(){
        var email_link = $('<div/>').attr('id', 'email_link');    //.css({'margin-top':'20px'})
        var link_a = $('<a/>').addClass('email_link').appendTo(email_link);
        link_a.attr('href', FS.config.registerUrl);
        $('<span/>').addClass('email_link').text(FR.i18nText("FS-Reg-Register_email") + " " + FS.config.registerMail).appendTo(link_a);
        return email_link;
    },
    _createVersionInfoLabel:function(register_type){
        var value = register_type;
        var wrapDiv = $('<div/>').addClass('is_register_success_span');
        switch(value){
            case 0:
                value = FR.i18nText("FS-Reg-Unregister_Version");
                wrapDiv.css('color','#F30000');
                break;
            case 1:
                value = FR.i18nText("FS-Reg_Registration_Successfully");
                wrapDiv.css('color','#2DAC00');
                break;
            case 2:
                value = FR.i18nText("FS-Reg-Simple_Register_Failed");
                wrapDiv.css('color','#F30000');
                break;
        };
        $('<span/>').text(value).appendTo(wrapDiv);
//        var config ={
//            type:'label',
//            value: value,
//            renderEl:wrapDiv
//        };
        return wrapDiv;          //config
    },
    _getFileLoad:function(register_type){
        var config = {
            x:0,
            y:0,
            type:'multifile',
            text:FR.i18nText("FS-Privilege-Simple_Preview"),
            height:40,
            width:40,
            accept : '.lic',
            hideFileList : true,
            maxlength:1,
            listeners : [{
                eventName : "afteredit",
                action: function() {
                    var attach =this.wrap.attach_array[0];
                    var id = attach.attach_id;
                    var isSuccess = false;
                    $(function() {
                        FR.ajax({
                            url : FR.servletURL,
                            data : {
                                op : 'reg',
                                cmd : 'lic_upload',
                                id : id
                            },
                            async : false,
                            complete : function(res, status) {
                                if (status == 'success') {
                                    isSuccess = res.responseText == 'true';
                                }
                            }
                        })
                    });
                    if(isSuccess){
                        FR.Msg.toast(FR.i18nText("FS-Reg-Lic_Upload_Success"));
                    }else{
                        FR.Msg.toast(FR.i18nText("FS-Reg-Lic_Upload_Failed"));
                    }
                }
            }]
        };
        var tip = "";
        if(register_type === 0){
            tip = FR.i18nText("FS-Reg-Unregister_Tip");
        }else if(register_type === 2){
            tip = FR.i18nText("FS-Reg-Fail_Tip");
        }
        var fileTip = {x:45,y:8,type: 'label',value: tip,color:'#B8B8B8',width:600, height:35};
        var filePanel = {
            widgetName:'filePanel',
            type: 'panel',
            width: 731,
            height: 41,
            doSize: true,
            contentWidget: {
                type:'absolute',
                items:[
                    config,fileTip
                ]
            }
        }
        return filePanel;
    },
    _createInfoTable:function(register_type){
        if(register_type === 0){
            return this._createUnregisteredInfoTable();
        }else{
            return this._createRegisterSuccessInfoTable(register_type);
        }
    },
    _createUnregisteredInfoTable:function(){
        var self = this;
        var appinfo = self.data.appinfo;
        var macinfo = this.macinfo;
        var mac_items =[];
        mac_items.push(this._createRegisterSpan(macinfo[0]));
        for(var m = 1, len = macinfo.length; m < len; m ++) {
            var mac_item = this._createRegisterUnableSpan(macinfo[m]);
            mac_items.push([
                {el:mac_item},{el:$('<div/>')}
            ]);
        }
        var macHeight = macinfo.length*25-8;
        var macItems = [
            {x:0,y:0,type: 'label',height:15,width:300,fontfamily: 'SimSun',fontsize: '13px',color: '#202020',value: macinfo[0]}
        ];
        for(var i = 1, len = macinfo.length; i < len; i ++) {
        	macItems.push(
        		{x:0,y:25*i,type: 'label',height:15,width:300,fontfamily: 'SimSun',fontsize: '13px',color: 'grey',value: macinfo[i]}
        	);
        }
        var  visitorViewConfig = {
            widgetName: 'versionInfoTable',
            type: 'tablelayout',
            items: [
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Mac_Address"))},
                    {el:{
                        type: 'panel',
                        width: 607,
                        height: macHeight,
                        doSize: true,
                        contentWidget:{
                            type:'absolute',
                            items:macItems
                        }
                    }},
                    {el:$('<div/>')}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Machine_Code"))},
                    {el:this._createRegisterSpan(appinfo['Re-uuid-in-system'], 'uuid')},
                    {el:$('<div/>')}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-App_Name"))},
                    {el:this._createRegisterSpan(appinfo['Re-AppName'])},
                    {el:$('<div/>')}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Version_Number"))},
                    {el:this._createRegisterSpan(appinfo['Re-system-version'])},
                    {el:$('<div/>')}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Simple_Jar"))},
                    {el:this._createRegisterSpan(appinfo['Re-Jar'])},
                    {el:$('<div/>')}
                ]
            ],
            columnSize : [180,607,50],
            rowSize : [macHeight,15,15,15, 15],
            vgap : 15
        }
        return visitorViewConfig;
    },
    _createRegisterSuccessInfoTable:function(register_type){
        var self = this;
        var appinfo = self.data.appinfo;
        var macPane=[];
        var machinePane=[];
        var tdHeight = 0;
        if(!self.isOnlineCheck){
            tdHeight = 20;
            macPane = [
                {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Mac_Address"))},
                {el:this._createRegisterSpan(appinfo['Re-binding-mac'])},
                {el:this.getIsTip(appinfo['Re-mac-match'])}
            ];
            machinePane = [
                {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Machine_Code"))},
                {el:this._createRegisterSpan(appinfo['Re-uuid-in-lic'])},
                {el:this.getIsTip(appinfo['Re-uuid-match'])}
            ];
        }
        var  visitorViewConfig = {
            widgetName: 'versionInfoTable',
            type: 'tablelayout',
            items: [
                macPane,
                machinePane,
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-App_Name"))},
                    {el:this._createRegisterSpan(appinfo['Re-appname-in-lic'])},
                    {el:this.getIsTip(appinfo['Re-appname-match'])}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Version_Number"))},
                    {el:this._createRegisterSpan(appinfo['Re-version-in-lic'])},
                    {el:this.getIsTip(appinfo['Re-version-match'])}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Simple_Jar"))},
                    {el:this._createRegisterSpan(appinfo['Re-Jar'])},
                    {el:$('<div/>')}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Simple_Deadline"))},
                    {el:this._createRegisterSpan(appinfo['Re-deadline'])},
                    {el:this.getIsTip(!appinfo['Re-lic-out-date'])}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Lock_Serial_Number"))},
                    {el:this._createRegisterSpan(FR.i18nText(appinfo['Re-lock-serial']))},
                    {el:$('<div/>')}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Reg-Concurrent_Ip"))},
                    {el:this._createRegisterSpan(FR.i18nText(appinfo['Re-sametime-ip']))},
                    {el:$('<div/>')}
                ],
                [
                    {el:this._createRegisterSpan(FR.i18nText("FS-Generic-Register_Version"))},
                    {el:this._createRegisterSpan(FR.i18nText(appinfo['About-Version']))},
                    {el:$('<div/>')}
                ]
            ],
            columnSize : [
                FR.i18nTextWidth("FS-Reg-Concurrent_Ip", 6.5) + 63,
                724 - FR.i18nTextWidth("FS-Reg-Concurrent_Ip", 6.5),
                50],
            rowSize : [tdHeight,tdHeight,20,20,20,20,20,20,20],
            vgap : 10
        }
        return visitorViewConfig;
    },
    _createUnRegisterSuceessTip:function(){
        var $tip = $('<div/>');
        $('<span/>').text(FR.i18nText("FS-Reg-Part_Success_TipA")).addClass('register_fail_style').appendTo($tip);
        $('<br>').appendTo($tip);
        $('<span/>').text(FR.i18nText("FS-Reg-Part_Success_TipB")).addClass('register_fail_style').appendTo($tip);
        return $tip;
    },
    getIsTip:function(isTip){
       if(isTip){
          return $('<div/>').addClass('fs-register-ok');
       }else{
          return $('<div/>').addClass('fs-register-fail');
       }
    },
    _createRegisterSpan:function(info, uuid){
        var wrap = $('<div/>');
		var changeColor = uuid && info === FR.i18nText("FS-Generic-Get_Uuid_Failed");
        $('<span/>').text(info).addClass(changeColor ? 'uuid_failed' : 'register_info').appendTo(wrap);
        return wrap;
    },
    _createRegisterUnableSpan:function(info){
        var wrap = $('<div/>');
        $('<span/>').text(info).addClass('register_unable_info').appendTo(wrap);
        return wrap;
    },
    createFunctionList:function(){
        var versionInfoConfig = {
            title:FR.i18nText("FS-Reg-Function_List"),
            content:{
                widgetName:'functionListPanel',
                type: 'panel',
                left:20,
                width: 950,
                height: 27*(this.data.functionlist.length+1)+25,//'100%'
                doSize: true,
                contentWidget:this._createFunctionListTable()
            }
        }
        return  versionInfoConfig;
    },
getFuncListLocaled : function() {
    var funcList = this.data.functionlist;
    for (var i = 0, len = funcList.length; i < len; i++) {
        var func = funcList[i];
        if (func.name) {
            func.name = FR.i18nText(func.name);
        }
    }

    return funcList;
},
_createFunctionListTable:function(){
        var self = this;
        var functionListPane ={
            type: 'quickgrid',
            widgetName:'functionListGrid',
            items: self.getFuncListLocaled(),
            columnsConfig: [
                {
                    key: 'name',
                    value: FR.i18nText("FS-Reg_Function_Name_List"),
                    width: 580
                }, {
                    key: 'support',
                    value: FR.i18nText("FS-Reg-Support_Or_Not"),
                    width: 140,
                    onCellCreate: function(){
                        return $("<div/>").addClass("fs-register-ok");
                    }
                }
            ]
        };
        return functionListPane;   //this.functionListPane
    },
    initData : function(renderer) {
        var self = this;
        var config = {
            url: FR.servletURL + '?op=fr_server&cmd=sc_get_registerinfo',
            type: 'POST'
        }
        var completefun = function(res, status) {
            self.data = FR.jsonDecode(res.responseText);
            var appinfo = self.data.appinfo;
            if (appinfo['Re-all-server-mac']) {
                self.macinfo = appinfo['Re-all-server-mac'].split("\n");
            }
            self.isOnlineCheck = appinfo['Re-isonline-check'];
            self.initContainer(renderer);
        };
        FS.Async.ajax(config, completefun);
    }
};