if (window.FR == null) {
    window.FR = {};
}

$.extend(FR, {
    /**
     * 这里添加一些必须要使用中文的键值对，然后通过FR.plainText(key)进行调用
     */
    chinese : {

    },

    i18n: ${i18n_props},
    /**
     * 根据键获取国际化后的值
     * @param key 键
     * @returns {String} 国际化后的文本
     * @example
     *    FR.i18nText("Click");//输出结果为"点击"
     *    FR.i18nText("Sum({R1}, {R2}) = 3", 1,2);//输出结果为"Sum(1, 2) = 3"
     */
    i18nText: function (key) {
        var localeText = FR.i18n[key];
        if (!localeText) {
            localeText = key;
        }
        var len = arguments.length;
        if(len > 1){
            for(var i = 1;i<len;i++){
                var key = "{R"+i+"}";
                localeText = localeText.replaceAll(key, arguments[i]+"");
            }
        }
        return localeText;
    },

    /**
     * 获取不需要国际化的中文字符串
     * @param key 中文字符串对应的键
     * @returns {String} 中文字符串
     */
    plainText : function(key) {
        return this.chinese[key] || key;
    },

    /**
     * 获取国际化字符串的字符串宽度（根据当前语言环境动态变化）
     * @param key 国际化字符串对应的键
     * @param fontWidth 字体宽度
     * @returns {number} 字符串宽度
     */
    i18nTextWidth: function (key, fontWidth) {
        return FR.byteLength(this.i18nText(key)) * (fontWidth ? fontWidth : 6);
    }
});