;
(function ($) {


    /**
     * 各种预览方式在浏览器中展示对象的基类
     * @abstract
     * @class FR.BasePane
     * @extends FR.Widget
     */
    FR.BasePane = FR.extend(FR.Widget, {
        type: "basepane",
        zoom: 1.0,

        _defaultConfig: function () {
            return $.extend(FR.BasePane.superclass._defaultConfig.apply(this, arguments), {});
        },

        _init: function () {
            FR.BasePane.superclass._init.apply(this, arguments);
        },

        /**
         * 根据报表所在窗体的宽度和高度自适应的放大和缩小表内容
         */
        autoScale: function () {
            if (window != top && this.$contentPane && this.options.autoScale) { // denny:
                // 说明是iframe集成
                var $contentDiv = $('.pageContentDIV', this.$contentPane);

                if ($contentDiv) {
                    // var bHeight = window.document.body.scrollHeight;
                    // var dHeight = window.document.documentElement.scrollHeight;
                    var height = $contentDiv.height();

                    // var bWidth = window.document.body.scrollWidth;
                    // var dWidth = window.document.documentElement.scrollWidth;
                    var width = $contentDiv.width();

                    var iframe_height = FR.windowHeight;
                    var iframe_width = FR.windowWidth;

                    this.scale(iframe_height / height);
                }
            }
        },

        /**
         * 缩放报表页面
         *
         *     @example
         *     contentPane.scale('+');//放大
         *     contentPane.scale(1.5);//縮放到150%
         *
         * @param {'+'/'-'/Number} 按照指定的参数进行缩放
         */
        scale: (function () {
            // ["25%", "50%", "75%", "100%", "120%", "150%", "200%"]
            var zooms = [0.25, 0.5, 0.75, 1.0, 1.2, 1.5, 2.0];

            return function (zoom) {
                if (zoom === '+') {
                    for (var i = 0, len = zooms.length; i < len; i++) {
                        if (zooms[i] > this.zoom) {
                            return this.scale(zooms[i]);
                        }
                    }
                    if (i == zooms.length) {
                        return this.scale(zooms[zooms.length - 1]);
                    }
                } else if (zoom === '-') {
                    for (var i = (zooms.length - 1); i >= 0; i--) {
                        if (zooms[i] < this.zoom) {
                            return this.scale(zooms[i]);
                        }
                    }
                    if (i < 0) {
                        return this.scale(zooms[0]);
                    }
                } else if (typeof zoom == 'number') {
                    if (this.$contentPane) {
                        var $contentDiv = $('.pageContentDIV', this.$contentPane);
                        if (FR.Browser.r.gecko) {
                            $contentDiv.css('-moz-transform', 'scale(' + zoom + ','
                                + zoom + ')');
                            $contentDiv.css('-moz-transform-origin', 'top left');
                        } else if (FR.Browser.r.webkit) {
                            $contentDiv.css('-webkit-transform', 'scale(' + zoom
                                + ',' + zoom + ')');
                            $contentDiv.css('-webkit-transform-origin', 'top left');
                        } else if (FR.Browser.r.opera) {
                            $contentDiv.css('-o-transform', 'scale(' + zoom + ','
                                + zoom + ')');
                            $contentDiv.css('-o-transform-origin', 'top left');
                        } else {
                            $contentDiv.css('zoom', zoom);
                        }
                        this.zoom = zoom;

                        this.fireEvent("zoomchanged");
                    }
                } else {
                    return this.zoom;
                }
            }
        })(),

        /**
         * 根据配置文件加载ReportPane。
         * 如果有参数，就加载ParameterPane + ContentPane,如果没有参数则加载ContentPane
         * @param options 配置
         * @protected
         */
        loadReportPane: function (options) {
            this.fireEvent(FR.Events.INIT);
            options = options || {};
            options.param = $.extend({
                showType: 1
            }, options.param); // 默认不显示参数面板,showType为1:embed

            var items = [];

            if (options.param.html) {
                this.parameterEl = this._createFormParameterPane(options, items);
            }

            this.$contentPane = this._createContentPane(options.sheets,
                options.browserbg, options.$paraContainer);
            items.push({
                region: 'center',
                el: this.$contentPane
            });

            // alex:设置布局为BorderLayout
            this._doReportPaneLayout(items, options);

            // james:初始化ContentPane的一些事件，目前主要是Tab的一些切换操作内容
            this.initContentPane();

            // 最后loadContentPane
            if (this.parameterEl == null) {
                this.loadContentPane();
            } else if (options.param.delay === false) {
                this.parameterCommit();
            }

            this.delay = options.param.delay;
        },

        _doReportPaneLayout: function (items, options) {
            var self = this;
            var borderLayout = new FR.BorderLayout({
                items: items,
                renderEl: this.options.renderEl
            });
            $(window).bind("resize", function () {
                if (self.resizeid != null) {
                    clearTimeout(self.resizeid);
                    self.resizeid = null;
                }
                self.resizeid = setTimeout(function () {
                    if (options.$paraContainer) {
                        options.$paraContainer.width = document.body.offsetWidth;
                    }
                    var paramWidget = borderLayout.getWidgetByName(options.alignLayoutName);

                    if (paramWidget) {
                        paramWidget.element.css('width', options.param.width);
                        self.addParaPaneScrollBar(options.$paraContainer, paramWidget.element, options.param.height, self.scrollHeight);
                    }
                    borderLayout.doLayout();
                }, 200);
            });
            var paramWidget = borderLayout.getWidgetByName(options.alignLayoutName);
            if (paramWidget) {
                this.addParaPaneScrollBar(options.$paraContainer, paramWidget.element, options.param.height, this.scrollHeight);
            }
            options.onCollapse = function (isCollapsed, layoutName, paraHeight) {
                borderLayout.getWidgetByName(layoutName).setVisible(!isCollapsed);
                borderLayout.setRegionWH('north', paraHeight);
                borderLayout.doLayout();
            };
            options.onCalculate = function (maxHeight, collapseHeight, $container) {
                options.param.height = maxHeight;
                $container.height(maxHeight + collapseHeight);
                borderLayout.doLayout();
            };
            borderLayout.doLayout();
        },

        _createContentPane: function (sheetsO, browserbg, $paraContainer) {
            sheetsO = sheetsO || [];
            var $contentPane = $("div.content-container");
            if ($contentPane.length !== 1) {
                $contentPane = $("<div id='content-container'>")
                    .appendTo(this.element).addClass("content-container");
            }
            $contentPane.css({
                overflow: 'hidden'
            });
            if (sheetsO && sheetsO.length > 1) {
                this._initSheetTabPane($contentPane, sheetsO, browserbg.background);
            } else {// 普通的单Sheet，就不需要用tabs啦
                // alex: overflow:auto 以显示滚动条查看所有报表内容
                // p: '0px solid #97A5B0'我改成了0px,这样既去掉了上边框,也能够显示滚动条了.
                $contentPane.css("overflow", "auto").css('border-top', '0px');
            }
            // 画网页背景
            // 为使背景固定，对不同浏览器使用不同策略
            if (browserbg.background != null) {
                if (FR.Browser.isIE8Before()) {
                    $contentPane.css('background', browserbg.background + " fixed");
                    if (browserbg.filter !== undefined) {
                        $contentPane.css('filter', browserbg.filter);
                    }
                    if (FR.Browser.isIE6()
                        && $paraContainer) {
                        $contentPane.css('background-position', '0px '
                            + $paraContainer.height()
                            + 'px 0px 0px');
                    }
                } else {
                    $contentPane.css('background', browserbg.background);
                    var bgSize = browserbg["background-size"];
                    if (bgSize !== undefined) {
                        $contentPane.css('background-size', bgSize);
                    }
                }
            }
            return $contentPane;
        },
        addParaPaneScrollBar: function (container, mover, top, height) {
            if (container) {
                container.hScrollPane({
                    mover: mover, //指定container对象下的哪个元素需要滚动位置 | 必传项;
                    showArrow: false, //指定是否显示左右箭头，默认不显示 | 可选项;
                    top: top, //滚动条所在的top位置
                    height: height,//滚动条的高度
                    //moverW:function(){return $(".press").width();}(), //传入水平滚动对象的长度值,不传入的话默认直接获取mover的宽度值 | 可选项;
                    //handleMinWidth:100,//指定handle的最小宽度,要固定handle的宽度请在css中设定handle的width属性（如 width:28px!important;），不传入则不设定最小宽度 | 可选项;
                    dragable: false, //指定是否要支持拖动效果，默认可以拖动 | 可选项;
                    easing: false, //滚动是否需要滑动效果,默认有滑动效果 | 可选项;
                    // handleCssAlter:"draghandlealter", //指定拖动鼠标时滚动条的样式，不传入该参数则没有变化效果 | 可选项;
                    mousewheel: {bind: false, moveLength: 500} //mousewheel: bind->'true',绑定mousewheel事件; ->'false',不绑定mousewheel事件；moveLength是指定鼠标滚动一次移动的距离,默认值：{bind:true,moveLength:300} | 可选项;
                });
            }
        },
        /**
         * 展示页面设置的对话框
         * @param o 对话框的配置
         */
        showPageSetupDialog: function (o) {
            o = o || {};
            o.width = o.width || 390;
            o.height = o.height || 295;
            o.title = FR.i18nText("PageSetup-Page_Setup");
            var fontsize = 12, label_color = '#4C4C4C', fontfamily = "simsun", sessionID = o.sessionID || '',
                reportIndex = o.reportIndex,
                widgetPadding = 10, northHeight = 25, mediumRightPadding = 162, rh = 21, radioRightPadding = 234;
            var paperSize_items = [
                {text: "Letter", value: "Letter"},
                {text: "A2", value: "A2"},
                {text: "Legal", value: "Legal"},
                {text: "A0", value: "A0"},
                {text: "A1", value: "A1"},
                {text: "Note", value: "Note"},
                {text: "A3", value: "A3"},
                {text: "A4", value: "A4"},
                {text: "A5", value: "A5"},
                {text: "A6", value: "A6"},
                {text: "A7", value: "A7"},
                {text: "A8", value: "A8"},
                {text: "B0", value: "B0"},
                {text: "B1", value: "B1"},
                {text: "B2", value: "B2"},
                {text: "B3", value: "B3"},
                {text: "B4", value: "B4"},
                {text: "B5", value: "B5"},
                {text: "Tabloid", value: "Tabloid"},
                {text: "Ledger", value: "Ledger"},
                {text: "Halfletter", value: "Halfletter"}
            ];
            var tableLayout = FR.createWidget({
                type: 'tablelayout',
                columnSize: [72, 16, 302],
                rowSize: [rh, 52, 52],
                vgap: 20,
                items: [
                    [
                        {
                            el: {
                                type: 'label',
                                value: FR.i18nText("FR-Engine-PageSetup_Orientation"),
                                fontsize: fontsize,
                                verticalcenter: true,
                                textalign: 'right',
                                fontfamily: fontfamily
                            }
                        },
                        {el: $('<div>')},
                        {
                            el: {
                                type: 'border', items: [
                                    {
                                        region: 'center', el: {
                                        type: 'radio',
                                        widgetName: 'portrait',
                                        text: FR.i18nText("FR-Engine-PageSetup_Portrait"),
                                        fontSize: fontsize,
                                        listeners: [
                                            {
                                                eventName: 'statechange',
                                                action: function () {
                                                    if (this.getValue()) {
                                                        var radio_landscape = tableLayout.getWidgetByName("landscape");
                                                        if (radio_landscape) {
                                                            radio_landscape.setValue(false);
                                                        }
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                    },
                                    {
                                        region: 'east', width: radioRightPadding, el: {
                                        type: 'radio',
                                        widgetName: 'landscape',
                                        text: FR.i18nText("FR-Engine-PageSetup_Landscape"),
                                        fontSize: fontsize,
                                        listeners: [
                                            {
                                                eventName: 'statechange',
                                                action: function () {
                                                    if (this.getValue()) {
                                                        var radio_portrait = tableLayout.getWidgetByName("portrait");
                                                        if (radio_portrait) {
                                                            radio_portrait.setValue(false);
                                                        }
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                    }
                                ]
                            }
                        }
                    ],
                    [
                        {
                            el: {
                                type: 'label',
                                value: FR.i18nText("FR-Engine-PageSetup_Paper_Size"),
                                fontsize: fontsize,
                                textalign: 'right',
                                fontfamily: fontfamily
                            }
                        },
                        {el: $('<div>')},
                        {
                            el: {
                                type: 'border', items: [
                                    {
                                        region: 'north', height: rh, el: {
                                        type: 'border', items: [
                                            {
                                                region: 'center', el: {
                                                type: 'radio',
                                                widgetName: 'predefined',
                                                text: FR.i18nText("FR-Engine-PageSetup_Predefined"),
                                                fontSize: fontsize,
                                                listeners: [
                                                    {
                                                        eventName: 'afteredit', action: function () {
                                                        var value = this.getValue();
                                                        var tableWidget = tableLayout.getWidgetByName('papaersize_setup');
                                                        if (value === false) {
                                                            tableWidget.setRowVisible(0, false);
                                                        } else {
                                                            tableWidget.setRowVisible(0, true);
                                                        }
                                                        tableWidget.doLayout();
                                                    }
                                                    },
                                                    {
                                                        eventName: 'statechange', action: function () {
                                                        var tableWidget = tableLayout.getWidgetByName('papaersize_setup');
                                                        if (this.getValue()) {
                                                            tableWidget.setRowVisible(1, false);
                                                            var radio_customed = tableLayout.getWidgetByName("customed");
                                                            if (radio_customed) {
                                                                radio_customed.setValue(false);
                                                            }
                                                        } else {
                                                            tableWidget.setRowVisible(1, true);
                                                        }
                                                        tableWidget.doLayout();
                                                    }
                                                    }
                                                ]
                                            }
                                            },
                                            {
                                                region: 'east', width: radioRightPadding, el: {
                                                type: 'radio',
                                                widgetName: 'customed',
                                                text: FR.i18nText("FR-Engine_Custom"),
                                                fontSize: fontsize,
                                                listeners: [
                                                    {
                                                        eventName: 'afteredit', action: function () {
                                                        var value = this.getValue();
                                                        var tableWidget = tableLayout.getWidgetByName('papaersize_setup');
                                                        if (value === false) {
                                                            tableWidget.setRowVisible(1, false);
                                                        } else {
                                                            tableWidget.setRowVisible(1, true);
                                                        }
                                                        tableWidget.doLayout();
                                                    }
                                                    },
                                                    {
                                                        eventName: 'statechange', action: function () {
                                                        var tableWidget = tableLayout.getWidgetByName('papaersize_setup');
                                                        if (this.getValue()) {
                                                            tableWidget.setRowVisible(0, false);
                                                            var radio_predefined = tableLayout.getWidgetByName("predefined");
                                                            if (radio_predefined) {
                                                                radio_predefined.setValue(false);
                                                            }
                                                        } else {
                                                            tableWidget.setRowVisible(0, true);
                                                        }
                                                        tableWidget.doLayout();
                                                    }
                                                    }
                                                ]
                                            }
                                            }
                                        ]
                                    }
                                    },
                                    {region: 'center', height: widgetPadding, el: $('<div>')},
                                    {
                                        region: 'south', height: rh, el: {
                                        type: 'tablelayout',
                                        widgetName: 'papaersize_setup',
                                        columnSize: [302],
                                        rowSize: [rh, rh],
                                        vgap: 0,
                                        items: [
                                            [
                                                {
                                                    el: {
                                                        type: 'border', items: [
                                                            {
                                                                region: 'center', el: {
                                                                type: 'combo',
                                                                widgetName: 'paperSize',
                                                                allowBlank: false,
                                                                directEdit: true,
                                                                items: paperSize_items,
                                                                fontSize: fontsize,
                                                                listeners: [
                                                                    {
                                                                        eventName: 'afteredit', action: function () {
                                                                        FR.ajax({
                                                                            url: FR.servletURL,
                                                                            type: 'POST',
                                                                            data: {
                                                                                op: 'fr_utils',
                                                                                cmd: 'utils_papersize',
                                                                                paperSize: this.getValue()
                                                                            },
                                                                            complete: function (res) {
                                                                                var paper = FR.jsonDecode(res.responseText);
                                                                                tableLayout.getWidgetByName("user_width").setValue(paper.width);
                                                                                tableLayout.getWidgetByName("user_height").setValue(paper.height);
                                                                                tableLayout.getWidgetByName("predefined").setValue(true);
                                                                                tableLayout.getWidgetByName("customed").reset();
                                                                            }
                                                                        });
                                                                    }
                                                                    }
                                                                ]
                                                            }
                                                            },
                                                            {region: 'east', width: mediumRightPadding, el: $('<div>')}
                                                        ]
                                                    }
                                                }
                                            ],
                                            [
                                                {
                                                    el: {
                                                        type: 'tablelayout',
                                                        columnSize: [12, 12, 60, 5, 21, 14, 12, 12, 60, 5, 21, 68],
                                                        rowSize: [rh],
                                                        vgap: 0,
                                                        items: [
                                                            [
                                                                {
                                                                    el: {
                                                                        type: 'label',
                                                                        value: FR.i18nText("FR-Engine_Width"),
                                                                        fontsize: fontsize
                                                                    }
                                                                },
                                                                {el: $('<div>')},
                                                                {
                                                                    el: {
                                                                        type: 'number',
                                                                        widgetName: 'user_width',
                                                                        fontSize: fontsize
                                                                    }
                                                                },
                                                                {el: $('<div>')},
                                                                {
                                                                    el: {
                                                                        type: 'label',
                                                                        value: "mm",
                                                                        fontsize: fontsize,
                                                                        color: label_color,
                                                                        fontfamily: 'tahoma'
                                                                    }
                                                                },
                                                                {el: $('<div>')},
                                                                {
                                                                    el: {
                                                                        type: 'label',
                                                                        value: FR.i18nText("FR-Engine_Height"),
                                                                        fontsize: fontsize
                                                                    }
                                                                },
                                                                {el: $('<div>')},
                                                                {
                                                                    el: {
                                                                        type: 'number',
                                                                        widgetName: 'user_height',
                                                                        fontSize: fontsize
                                                                    }
                                                                },
                                                                {el: $('<div>')},
                                                                {
                                                                    el: {
                                                                        type: 'label',
                                                                        value: "mm",
                                                                        fontsize: fontsize,
                                                                        color: label_color,
                                                                        fontfamily: 'tahoma'
                                                                    }
                                                                },
                                                                {el: $('<div>')}
                                                            ]
                                                        ]
                                                    }
                                                }
                                            ]
                                        ]
                                    }
                                    }
                                ]
                            }
                        }
                    ],
                    [
                        {
                            el: {
                                type: 'label',
                                value: FR.i18nText("FR-Engine-PageSetup_Margin"),
                                fontsize: fontsize,
                                textalign: 'right',
                                fontfamily: fontfamily
                            }
                        },
                        {el: $('<div>')},
                        {
                            el: {
                                type: 'tablelayout',
                                columnSize: [12, 12, 60, 5, 21, 14, 12, 12, 60, 5, 21, 68],
                                rowSize: [rh, rh],
                                vgap: 10,
                                items: [
                                    [
                                        {el: {type: 'label', value: FR.i18nText("FR-Engine_Top"), fontsize: fontsize}},
                                        {el: $('<div>')},
                                        {el: {type: 'number', widgetName: 'margin_top', fontSize: fontsize}},
                                        {el: $('<div>')},
                                        {
                                            el: {
                                                type: 'label',
                                                value: "mm",
                                                fontsize: fontsize,
                                                color: label_color,
                                                fontfamily: 'tahoma'
                                            }
                                        },
                                        {el: $('<div>')},
                                        {
                                            el: {
                                                type: 'label',
                                                value: FR.i18nText("FR-Engine_Bottom"),
                                                fontsize: fontsize
                                            }
                                        },
                                        {el: $('<div>')},
                                        {el: {type: 'number', widgetName: 'margin_bottom', fontSize: fontsize}},
                                        {el: $('<div>')},
                                        {
                                            el: {
                                                type: 'label',
                                                value: "mm",
                                                fontsize: fontsize,
                                                color: label_color,
                                                fontfamily: 'tahoma'
                                            }
                                        },
                                        {el: $('<div>')}
                                    ],
                                    [
                                        {el: {type: 'label', value: FR.i18nText("FR-Engine_Left"), fontsize: fontsize}},
                                        {el: $('<div>')},
                                        {el: {type: 'number', widgetName: 'margin_left', fontSize: fontsize}},
                                        {el: $('<div>')},
                                        {
                                            el: {
                                                type: 'label',
                                                value: "mm",
                                                fontsize: fontsize,
                                                color: label_color,
                                                fontfamily: 'tahoma'
                                            }
                                        },
                                        {el: $('<div>')},
                                        {
                                            el: {
                                                type: 'label',
                                                value: FR.i18nText("FR-Engine_Right"),
                                                fontsize: fontsize
                                            }
                                        },
                                        {el: $('<div>')},
                                        {el: {type: 'number', widgetName: 'margin_right', fontSize: fontsize}},
                                        {el: $('<div>')},
                                        {
                                            el: {
                                                type: 'label',
                                                value: "mm",
                                                fontsize: fontsize,
                                                color: label_color,
                                                fontfamily: 'tahoma'
                                            }
                                        },
                                        {el: $('<div>')}
                                    ]
                                ]
                            }
                        }
                    ]
                ]
            });
            var widget_predefined = tableLayout.getWidgetByName('predefined');
            var widget_customed = tableLayout.getWidgetByName('customed');
            var widget_portrait = tableLayout.getWidgetByName('portrait');
            var widget_landscape = tableLayout.getWidgetByName('landscape');
            var widget_paperSize = tableLayout.getWidgetByName('paperSize');
            var widget_user_width = tableLayout.getWidgetByName('user_width');
            var widget_user_height = tableLayout.getWidgetByName('user_height');
            var widget_margin_top = tableLayout.getWidgetByName('margin_top');
            var widget_margin_bottom = tableLayout.getWidgetByName('margin_bottom');
            var widget_margin_left = tableLayout.getWidgetByName('margin_left');
            var widget_margin_right = tableLayout.getWidgetByName('margin_right');
            // 异步获取页面设置的信息,给控件赋默认值
            FR.ajax({
                url: FR.servletURL,
                type: 'POST',
                data: {
                    op: 'fr_dialog',
                    cmd: 'read_page_setup_tpl',
                    sessionID: sessionID,
                    reportIndex: reportIndex
                },
                complete: function (res, status) {
                    var result = FR.jsonDecode(res.responseText);
                    if (result != null) {
                        widget_predefined.setValue(result.predefined);
                        if (widget_predefined.getValue()) {
                            tableLayout.getWidgetByName('papaersize_setup').setRowVisible(0, true);
                            tableLayout.getWidgetByName('papaersize_setup').setRowVisible(1, false);
                        } else {
                            tableLayout.getWidgetByName('papaersize_setup').setRowVisible(0, false);
                            tableLayout.getWidgetByName('papaersize_setup').setRowVisible(1, true);
                        }
                        tableLayout.getWidgetByName('papaersize_setup').doLayout();
                        widget_customed.setValue(result.customed);
                        widget_portrait.setValue(result.portrait);
                        widget_landscape.setValue(result.landscape);
                        widget_paperSize.setValue(result.paperSize);
                        widget_user_width.setValue(result.user_width);
                        widget_user_height.setValue(result.user_height);
                        widget_margin_top.setValue(result.margin_top);
                        widget_margin_bottom.setValue(result.margin_bottom);
                        widget_margin_left.setValue(result.margin_left);
                        widget_margin_right.setValue(result.margin_right);
                    }
                }
            });
            o.onOK = function () {
                FR.ajax({
                    url: FR.servletURL,
                    type: 'POST',
                    data: {
                        op: 'fr_dialog',
                        cmd: 'change_page_setup',
                        sessionID: sessionID,
                        reportIndex: reportIndex,
                        predefined: widget_predefined.getValue(),
                        customed: widget_customed.getValue(),
                        portrait: widget_portrait.getValue(),
                        landscape: widget_landscape.getValue(),
                        paperSize: widget_paperSize.getValue(),
                        user_width: widget_user_width.getValue(),
                        user_height: widget_user_height.getValue(),
                        margin_top: widget_margin_top.getValue(),
                        margin_bottom: widget_margin_bottom.getValue(),
                        margin_left: widget_margin_left.getValue(),
                        margin_right: widget_margin_right.getValue()
                    },
                    complete: function () {
                        FR.closeDialog();
                    }
                });
            };
            o.contentWidget = {
                type: 'border',
                items: [
                    {region: 'north', el: $('<div>'), height: northHeight},
                    {region: 'center', el: tableLayout.element}
                ]
            };
            FR.showUpdateDialog(o);
        },

        _sheetPositionPane: function () {
            return "bottom";
        },

        _initSheetTabPane: function ($contentPane, sheetsO, bg) {
            var sheetPosition = this._sheetPositionPane();
            var writeTab = new FR.TabPane({
                background: bg,
                items: sheetsO,
                tabPosition: sheetPosition,
                renderEl: $contentPane
            });
            $contentPane.data("TabPane", writeTab);
        },

        _initParameterFormPane: function () {
            return $("<div>").appendTo(this.element).addClass("parameter-container");
        },

        _createFormParameterPane: function (options, layout) {
            var collapsePaneHeight = 8;
            options.alignLayoutName = '__layout4align__';
            var self = this, paramO = options.param;
            var config = paramO.html;
            self.scrollHeight = 6;
            //这边maxWidth 7.1的时候被改成了paramO.width, 导致web端的居右居中效果很奇怪
            var maxWidth = 0, maxHeight = 0;
            for (var i = 0; i < config.items.length; i++) {
                var item = config.items[i];
                maxWidth = Math.max(maxWidth, item.x + item.width);
                maxHeight = Math.max(maxHeight, item.y + item.height);
            }
            var deltaHeight = paramO.height - maxHeight;
            var formLayout;
            var barHeight = paramO.width > document.body.offsetWidth ? self.scrollHeight : 0;
            var $paraContainer = $("<div class='parameter-container' style='overflow: auto;'>").css({
                'height': paramO.height + barHeight + collapsePaneHeight,
                'width': document.body.offsetWidth
            });
            FR.parameterContainerHeight = paramO.height + barHeight + collapsePaneHeight;
            options.$paraContainer = $paraContainer;
            config.onCalculate = function (currentMaxHeight) {
                if ($.isFunction(options.onCalculate)) {
                    options.onCalculate.call(this, currentMaxHeight + deltaHeight, collapsePaneHeight, $paraContainer);
                }
            };
            var $expandEl = $("<div class='parameter-container-collapseimg-up' style='cursor: pointer'></div>").click(function () {
                var resizeTime = new Date();
                self.lastResizeTime = resizeTime;
                setTimeout(function () {
                    if (resizeTime == self.lastResizeTime) {
                        delete self.lastResizeTime;
                        $paraContainer.animate({
                            height: (self.hasCollapsed ? "+=" : "-=") + paramO.height
                        }, "fast", function () {
                            if (self.hasCollapsed) {
                                FR.parameterContainerHeight += paramO.height;
                            }
                            else {
                                FR.parameterContainerHeight -= paramO.height;
                            }
                            self.hasCollapsed = !self.hasCollapsed;
                            $expandEl.switchClass('parameter-container-collapseimg-down', 'parameter-container-collapseimg-up');
                            if ($.isFunction(options.onCollapse)) {
                                options.onCollapse.call(this, self.hasCollapsed, options.alignLayoutName, $paraContainer.height());
                                self.doAfterCollapse();
                            }
                        });
                    }
                }, 222);
            });

            var alignment = 'left';
            switch (paramO.alignLocation) {
                case 0 :
                    alignment = 'left';
                    break;
                case 1 :
                    alignment = 'center';
                    break;
                case 2 :
                    alignment = 'right';
                    break;
                default :
                    alignment = 'left';
            }
            var $center = $('<div class="pmeter-container"></div>').css({
                "height": paramO.height,
                "width": paramO.width
            });
            //定义一下用来滚动的对象
            var paraConfig = {
                renderEl: $paraContainer,
                type: 'border',
                items: [
                    {
                        region: 'south', height: collapsePaneHeight, el: {
                        type: 'horizontal',
                        items: [
                            {el: $expandEl, width: 120}
                        ]
                    }
                    },
                    {
                        region: 'center', el: {
                        type: 'para_horizontal',
                        width: paramO.width,
                        minWidth: paramO.width,
                        widgetName: options.alignLayoutName,
                        alignment: alignment,
                        items: [
                            {el: $center, width: maxWidth}
                        ]
                    }
                    }
                ]
            };
            this._setBackground(paramO, $paraContainer);
            if (paramO.showType === 1) {
                layout.push({
                    region: 'north',
                    el: paraConfig,
                    height: paramO.height + collapsePaneHeight + barHeight
                });
            }
            if (paramO.showType === 0) {
                $paraContainer.css({
                    position: "absolute",
                    width: paramO.width,
                    height: paramO.height
                }).appendTo("body");
                config.listeners = [
                    {
                        once: true,
                        eventName: 'submitcomplete',
                        action: function () {
                            FR.closeDialog();
                        }
                    }
                ];
                config.renderEl = $paraContainer;
                formLayout = new FR.contentForm(config);
            } else {
                config.renderEl = $center;
                config.container = $paraContainer;
                formLayout = new FR.contentForm(config);
            }
            if (paramO.showType === 0) {
                formLayout.doLayout();
                FR.showDialog({
                    title: paramO.paramWindowTitle,
                    width: paramO.width + 20,
                    height: paramO.height + 45,
                    contentHtml: $paraContainer
                });
            }
            return formLayout;
        },

        _setBackground: function (paramO, $dom) {
            var bg = paramO.parambg;
            if (bg != null) {
                FR.setBackground($dom, bg);
            }
        },

        doAfterCollapse: function () {
        },

        afterLoad: function () {

        },

        /**
         * 提交参数并加载报表主体内容
         *
         *     @example
         *     contentPane.parameterCommit();
         *
         * @param {Object} reloadOthers 配置
         */
        parameterCommit: function (reloadOthers) {
            if ($.isFunction(this.parameterEl.formSubmit)) {
                this.parameterEl.formSubmit({
                    url: FR.servletURL
                    + "?op=fr_dialog&cmd=parameters_d&sessionID="
                    + _g().currentSessionID,
                    callback: function () {
                        _g().loadContentPane(reloadOthers);
                    }
                });
            }
        },

        /**
         * 改变在鼠标经过或者点击报表行时行的颜色
         *
         *     @example
         *     contentPane.makeHighlight('red', 'click');
         *
         * @param {String} color 需要变换成的颜色
         * @param {'click'/'mouseover'} [op='click'] 鼠标动作
         * @param deep 是否是加在td上面
         */
        makeHighlight: function (color, op, deep) {
            var self = this;
            if (!op) {
                op = 'click';
            }
            var container = $('div.content-container');
            var tr = $("tr", container);
            var changeTds = function (currentTR, lastTDColors) {
                var tds = currentTR.children();
                for (var i = 0; i < tds.length; i++) {
                    var td = tds.eq(i);
                    lastTDColors.push(td[0].style.backgroundColor);
                    td[0].style.backgroundColor = color;
                }
            };
            var highLightFun = function (e) {
                if (!$(e.target).is("td")) {
                    return;
                }
                var currentTR = $(e.target).parent();
                if ($(e.target).attr("hv")) {
                    // marro:如果是格子套格子的,PageCellWriter.getValueWrapper
                    currentTR = currentTR.closest("td").parent();
                }
                if (lastSelectedTR != null) {
                    if (deep === true) {
                        var tds = lastSelectedTR.children();
                        for (var i = 0; i < tds.length; i++) {
                            var td = tds.eq(i);
                            td[0].style.backgroundColor = lastTDColors[i] == "" ? "White" : lastTDColors[i];
                        }
                        lastTDColors.length = 0;
                        if (currentTR[0] != lastSelectedTR[0]) {
                            changeTds(currentTR, lastTDColors);
                            lastSelectedTR = currentTR;
                            return;
                        }
                    } else {
                        lastSelectedTR[0].style.backgroundColor = 'White';
                        if (currentTR[0] != lastSelectedTR[0]) {
                            currentTR[0].style.backgroundColor = (currentTR[0].style.backgroundColor == color
                                ? 'White'
                                : color);
                            lastSelectedTR = currentTR;
                            return;
                        }
                    }
                    lastSelectedTR = null;
                    return;
                }
                lastSelectedTR = currentTR;

                if (deep === true) {
                    changeTds(currentTR, lastTDColors);
                } else {
                    currentTR[0].style.backgroundColor = (currentTR[0].style.backgroundColor == color
                        ? 'White'
                        : color);
                }
            };

            var lastSelectedTR = null;
            var lastTDColors = [];
            var action = op.indexOf('over') != -1 ? "mouseover" : "click";
            if (window.highfun != null) {
                container.unbind(action, window.highfun);
            }
            window.highfun = function (e) {
                highLightFun(e);
            };
            container.bind(action, window.highfun);
        },

        initContentPane: function () {
            var events = FR.Report.Plugin.Panel.Events;
            if ($.isArray(events)) {
                for (var i = 0, len = events.length; i < len; i++) {
                    var evt = events[i];
                    this.on(evt.name, evt.action.createDelegate(this));
                }
            }
        },

        pdfPrint: function (isPopup) {
            if (this.fireEvent(FR.Events.BPDFPRINT) === false) {
                return;
            }
            if (FR.Browser.isIE()) {
                FR.doPDFPrint(this.currentSessionID, isPopup);
            } else {
                // james：pdfPrint需要用format=pdfPrint，服务器才能识别为是打印状态啊
                window.open(FR.servletURL + "?op=fr_pdfprint&cmd=native&sessionID=" + this.currentSessionID, "_blank");
                this.fireEvent(FR.Events.APDFPRINT);
            }
        },
        //wei:移动端支持自动刷新，pc不做事
        setAppearRefresh: function () {

        },
        /**
         * 根据sheet的序号加载sheet
         * @param index sheet序号
         */
        loadSheetByIndex: function (index) {
            var $contentPane = $("div.content-container");
            if (index && $contentPane && $contentPane.data && $contentPane.data('TabPane')) {
                $contentPane.data('TabPane').selectTabAt(index);
            }
        },
        /**
         * 根据sheet的名称加载sheet
         * @param sheetName sheet名称
         */
        loadSheetByName: function (sheetName) {
            var $contentPane = $("div.content-container");
            if (sheetName && $contentPane && $contentPane.data && $contentPane.data('TabPane')) {
                $contentPane.data('TabPane').selectTabByName(sheetName);
            }
        },
        /**
         * 文件下载
         * @param url 下载地址
         */
        downloadExportFile: function (url, type) {
            //新导出方式插件
            if (FR.Report.Plugin.XHR2FileSaveProcessor.item && FR.Plugin.validLevel(FR.Report.Plugin.XHR2FileSaveProcessor, FR.Report.Plugin.XHR2FileSaveProcessor.item)) {
                FR.Report.Plugin.XHR2FileSaveProcessor.item.action.call(this, url, type);
                return;
            }
            if (FR.Browser.r.gecko) {
                //火狐下使用window.location会导致gif卡住，使用表单提交下载
                var form = $("<form>");
                form.attr({"style": "display : none", "target": "", "method": "post", "action": url});
                var input = $("<input>");
                $("body").append(form);
                form.append(input);
                form.submit();
                form.remove();
            } else {
                window.location = url;
            }
            FR.progressBar.call(this, this.currentSessionID, type);
        },
        createProgressBar: function () {
            if ($('#progressBar').length <= 0) {
                var progressBar = $('<div id = ' + '\"' + 'progressBar' + '\"' + '>' + '</div>').appendTo("body");
                var tips = $('<div>' + FR.i18nText("FR-Engine_Exporting") + '...' + '</div>').appendTo($('#progressBar'));
                var $maskDiv = $('<div id="transparent_mask" style="position:absolute;filter:alpha(opacity=50);opacity:0.5;"></div>');
                $maskDiv.css('left', "0px").css('top', "0px").css('width', "100%").css('height', "100%").css('z-index', 2001).appendTo("body");
                progressBar.addClass("progressBar");
                tips.addClass("progressBarTips");
            }
        },
        removeProgressBar: function () {
            $('#progressBar').remove();
            $('#transparent_mask').remove();
        }
    });
})(jQuery);