package com.jshx.zzhxmhistory.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxmhistory.dao.ZzhxmHistoryDao;
import com.jshx.zzhxmhistory.entity.ZzhxmHistory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhxmHistoryDao")
public class ZzhxmHistoryDaoImpl extends BaseDaoImpl implements ZzhxmHistoryDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhxmByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhxmHistory(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhxmByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmHistory getById(String id)
	{
		return (ZzhxmHistory)this.getObjectById(ZzhxmHistory.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhxm 信息
	 */
	public void save(ZzhxmHistory zzhxm)
	{
		zzhxm.setId(null);
		this.saveOrUpdateObject(zzhxm);
	}

	/**
	 * 修改信息
	 * @param zzhxm 信息
	 */
	public void update(ZzhxmHistory zzhxm)
	{
		this.saveOrUpdateObject(zzhxm);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(ZzhxmHistory.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		ZzhxmHistory zzhxm = (ZzhxmHistory)this.getObjectById(ZzhxmHistory.class, id);
		zzhxm.setDelFlag(1);
		this.saveObject(zzhxm);
	}
}
