package com.jshx.zzhxm.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jshx.core.utils.SFTPChannel;
import com.jshx.core.utils.SysPropertiesUtil;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.string;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.Properties;

/**
 * Author：
 * Date：
 * Description：
 * 创建ChannelSftp对象,编写一个工具类，根据ip，
 * 用户名及密码得到一个SFTP channel对象，即ChannelSftp的实例对象，
 * 在应用程序中就可以使用该对象来调用SFTP的各种操作方法。
 */
public class FTPUtils {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(SFTPChannel.class.getName());

    private static final String host = SysPropertiesUtil.getProperty("gd.host");
    private static final String port = SysPropertiesUtil.getProperty("gd.port");
    private static final String username = SysPropertiesUtil.getProperty("gd.username");
    private static final String password = SysPropertiesUtil.getProperty("gd.password");
    /**
     * 获取ftpClient对象
     * @param ftpHost FTP服务器地址
     * @param ftpUserName 登录FTP服务器用户名
     * @param ftpPassword 登录FTP服务器密码
     * @param ftpPort FTP服务器端口
     * @return
     */
    public static FTPClient getFTPClient(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort) {
        FTPClient ftpClient = new FTPClient();
        //ftpClient.setControlEncoding("GBK"); // 传输的字符编码（防止乱码）,自带的编码是ISO-8859-1,一般不会出现乱码
        //超时时间（防止僵死）
        //ftpClient.setDataTimeout(1000*60);
        //ftpClient.setDefaultTimeout(1000*60);
        //工作流的大小
        //ftpClient.setBufferSize(1024*4);
        //主被动模式（应对FTP服务器的相关安全设置）
        ftpClient.enterLocalPassiveMode();
        //ftpClient.enterLocalActiveMode();
        try {
//            ftpClient.
            ftpClient.connect(ftpHost, ftpPort);  // 连接FTP服务器
            if(ftpClient.isConnected()) {
                //使用用户名和密码登录
                if(ftpClient.login(ftpUserName, ftpPassword)) {
                    //判断FTP连接是否可用，源码中是通过判断ReplyCode值（200=< reply <300)
                    if(FTPReply.isPositiveCompletion(ftpClient.getReplyCode())) {
                        logger.info("FTP连接成功。");
                        System.out.println("FTP登录成功,ftpHost: ftp:/"+ftpClient.getRemoteAddress());
                        ftpClient.setFileType(FTPClient.BINARY_FILE_TYPE);
                    }
                }else {
                    logger.info("未连接到FTP，用户名或密码错误。");
                    ftpClient.disconnect();
                }
            }
        } catch (SocketException e) {
            e.printStackTrace();
            logger.info("FTP的IP地址可能错误，请正确配置。");
        } catch (IOException e) {
            e.printStackTrace();
            logger.info("FTP的端口错误,请正确配置。");
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("错误。");
        }
        return ftpClient;
    }

    /**
     * 上传文件
     * @param ftpHost FTP服务器地址
     * @param ftpUserName 登录FTP服务器用户名
     * @param ftpPassword 登录FTP服务器密码
     * @param ftpPort FTP服务器端口
     * @param ftpPath 上传到FTP服务器的指定目录
     * @param filename 上传的文件名
     * @param input 文件输入流
     * @return 成功返回true，否则返回false
     */
    public static boolean uploadFile(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort, String ftpPath, String filename, InputStream input) {
        boolean result = false;
        FTPClient ftpClient = getFTPClient(ftpHost, ftpUserName, ftpPassword, ftpPort);
        try {
            int reply;
            reply = ftpClient.getReplyCode(); //用户名密码错误时,值是530

            if (!FTPReply.isPositiveCompletion(reply)) { //判断是否成功登录
                //ftpClient.disconnect(); //用户名密码错误时报空指针,是因为在用户名密码不正确时，在上面已执行disconnect操作
                return result;
            }

            ftpClient.setFileType(FTPClient.BINARY_FILE_TYPE);
            ftpClient.makeDirectory(ftpPath.endsWith(File.separator)? ftpPath : ftpPath + File.separator); //目录不存在则创建目录
            ftpClient.changeWorkingDirectory(ftpPath.endsWith(File.separator)? ftpPath : ftpPath + File.separator); //切换到要上传的目录
            //编码文件名，支持中文文件名
//            filename = new String(filename.getBytes("GBK"), "UTF-8");
            filename = new String(filename.getBytes("GBK"), "ISO-8859-1");
            //上传文件
            if (!ftpClient.storeFile(filename, input)) {
                System.out.println("文件已存在"); //应该是判断文件是否已存在服务器上
                return result;
            }
            input.close();
            ftpClient.logout();
            result = true;
        } catch (IOException e) {
            e.printStackTrace();
        } catch (NullPointerException e){
            e.printStackTrace();
        } finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                } catch (IOException e) {}
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String ftpHost = "192.168.1.101";
        String ftpUserName = "epsoa";
        String ftpPassword = "888";
        int ftpPort = 21;
        //String ftpPath = "";  //目录名， ""表示根目录
//        String ftpPath = "hz";  //目录名最好是英文，中文目录暂时还未成功上传
//        String fileName = "test_上传测试.docx"; //要上传的文件名

        String src = "D:/workspace_git_new/njzsb/out/uploads/YZS/YZS20200146/"; // 本地文件名
        String dst = "/upload/111/"; // 目标文件名
        String fileName = "业务需求.docx";

        //上传文件
        try{
            FileInputStream in=new FileInputStream(new File(src + fileName)); //要上传的文件所在的目录，这里放的是D盘的根目录下
            Boolean result = FTPUtils.uploadFile(ftpHost, ftpUserName,  ftpPassword, ftpPort, dst, fileName, in);
//            Boolean result = FTPUtils.uploadFile(host, username,  password, Integer.parseInt(port), dst, fileName, in);
            if(result){
                System.out.println(fileName+"文件上传成功");
            }else{
                System.out.println(fileName+"文件上传失败");
            }
        } catch (Exception e){
            e.printStackTrace();
        }
       /* String path = "/upload/";
        String attachPath = "YZS20200015/南京市工程建设项目档案资料清单_YZS20200015.tif";
        String fileName = attachPath.substring(attachPath.lastIndexOf("/") + 1);
        String filePath = attachPath.substring(0, attachPath.lastIndexOf("/") + 1);
        System.out.println(fileName);
        System.out.println(path + filePath);*/
    }


}

