package com.jshx.zzhxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmSfxxDao;
import com.jshx.zzhxm.dao.ZzhxmSfxxHistoryDao;
import com.jshx.zzhxm.entity.ZzhxmSfxx;
import com.jshx.zzhxm.entity.ZzhxmSfxxHistory;
import com.jshx.zzhxm.service.ZzhxmSfxxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhxmSfxxService")
public class ZzhxmSfxxServiceImpl extends BaseServiceImpl implements ZzhxmSfxxService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("zzhxmSfxxDao")
	private ZzhxmSfxxDao zzhxmSfxxDao;

	@Autowired()
	@Qualifier("zzhxmSfxxHistoryDao")
	private ZzhxmSfxxHistoryDao zzhxmSfxxHistoryDao;

	@Transactional
	public List<ZzhxmSfxx> findZzhxmSfxx(Map<String, Object> paraMap) {
		return zzhxmSfxxDao.findZzhxmSfxx(paraMap);
	}

	@Override
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
		return zzhxmSfxxDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmSfxx getById(String id)
	{
		return zzhxmSfxxDao.getById(id);
	}

	@Override
	public ZzhxmSfxx getByYbjksbh(String ybjksbh)
	{
		Map<String,Object> paramMap = new HashMap<>();
		paramMap.put("ybjksbh",ybjksbh);
		ZzhxmSfxx zzhxmSfxx = (ZzhxmSfxx)zzhxmSfxxDao.findObjectByFieldsMap(ZzhxmSfxx.class,paramMap);
		return zzhxmSfxx;
	}

	@Override
	public ZzhxmSfxx getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		ZzhxmSfxx zzhxmSfxx = (ZzhxmSfxx)zzhxmSfxxDao.findObjectByFieldsMap(ZzhxmSfxx.class,paramMap);
		return zzhxmSfxx;
	}

	/**
	 * 保存信息
	 * @param zzhxmSfxx 信息
	 */
	@Transactional
	public void save(ZzhxmSfxx zzhxmSfxx)
	{
		zzhxmSfxxDao.save(zzhxmSfxx);
	}

	/**
	 * 修改信息
	 * @param zzhxmSfxx 信息
	 */
	@Transactional
	public void update(ZzhxmSfxx zzhxmSfxx)
	{
		zzhxmSfxxDao.update(zzhxmSfxx);
	}

	/**
	 * 修改收费信息并插入到历史表中
	 * @param sfxx
	 * @param sfxxHistory
	 */
	@Transactional
	@Override
	public void updateAndSaveHistory(ZzhxmSfxx sfxx, ZzhxmSfxxHistory sfxxHistory) {
		zzhxmSfxxHistoryDao.save(sfxxHistory);
		zzhxmSfxxDao.update(sfxx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhxmSfxxDao.findZzhxmSfxx(paraMap);

		zzhxmSfxxDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhxmSfxxDao.deleteWithFlag(id);
			}
		}
	}

}
