package com.jshx.zzhxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmfshxxDao;
import com.jshx.zzhxm.entity.Zzhxmfshxx;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @Author: Danfoen
 * @Description:
 * @Date: Created in 14:17 2019/5/23
 * @Modifird by:
 */
@Component("zzhxmfshxxDao")
public class ZzhxmfshxxDaoImpl  extends BaseDaoImpl implements ZzhxmfshxxDao {

    /**
     * 分页查询
     * @param page 分页信息
     * @param paraMap 查询条件信息
     * @return 分页信息
     */
    public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
    {
        return this.findPageByHqlId("findZzhxmfshxxByMap", paraMap, page);
    }

    /**
     * 查询所有记录
     * @param paraMap 查询条件信息
     * @return 分页信息
     */
    @Override
    public List findZzhxmfshxx(Map<String, Object> paraMap) {
        return this.findListByHqlId("findZzhxmfshxxByMap", paraMap);
    }

    /**
     * 根据主键ID查询信息
     * @param id 主键ID
     * @return 主键ID对应的信息
     */
    @Override
    public Zzhxmfshxx getById(String id) {
        return (Zzhxmfshxx) this.getObjectById(Zzhxmfshxx.class, id);
    }

    /**
     * 保存信息
     * @param zzhxmfshxx 信息
     */
    @Override
    public void save(Zzhxmfshxx zzhxmfshxx) {
        zzhxmfshxx.setId(null);
        this.saveOrUpdateObject(zzhxmfshxx);
    }

    /**
     * 修改信息
     * @param zzhxmfshxx 信息
     */
    @Override
    public void update(Zzhxmfshxx zzhxmfshxx) {
        this.saveOrUpdateObject(zzhxmfshxx);
    }

    /**
     * 物理删除信息
     * @param id 主键ID
     */
    @Override
    public void delete(String id) {
        this.removeObjectById(Zzhxmfshxx.class, id);
    }

    /**
     * 逻辑删除信息
     * @param id 主键ID
     */
    @Override
    public void deleteWithFlag(String id) {
        Zzhxmfshxx zzhxmfshxx = (Zzhxmfshxx)this.getObjectById(Zzhxmfshxx.class, id);
        zzhxmfshxx.setDelFlag(1);
        this.saveObject(zzhxmfshxx);
    }
}
