package com.jshx.zzhxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmSfxxDao;
import com.jshx.zzhxm.dao.ZzhxmSfxxHistoryDao;
import com.jshx.zzhxm.entity.ZzhxmSfxx;
import com.jshx.zzhxm.entity.ZzhxmSfxxHistory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhxmSfxxHistoryDao")
public class ZzhxmSfxxHistoryDaoImpl extends BaseDaoImpl implements ZzhxmSfxxHistoryDao
{

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhxmSfxxHistory(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhxmSfxxByMap", paraMap);
	}

	/**
	 * 分页查询
	 * @param page
	 * @param paraMap
	 * @return
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhxmSfxxByMap", paraMap, page);
	}
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmSfxxHistory getById(String id)
	{
		return (ZzhxmSfxxHistory) this.getObjectById(ZzhxmSfxxHistory.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhxmSfxx 信息
	 */
	public void save(ZzhxmSfxxHistory zzhxmSfxx)
	{
		zzhxmSfxx.setId(null);
		this.saveOrUpdateObject(zzhxmSfxx);
	}

	/**
	 * 修改信息
	 * @param zzhxmSfxx 信息
	 */
	public void update(ZzhxmSfxxHistory zzhxmSfxx)
	{
		this.saveOrUpdateObject(zzhxmSfxx);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(ZzhxmSfxxHistory.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		ZzhxmSfxxHistory zzhxmSfxx = (ZzhxmSfxxHistory)this.getObjectById(ZzhxmSfxxHistory.class, id);
		zzhxmSfxx.setDelFlag(1);
		this.saveObject(zzhxmSfxx);
	}
}
