package com.jshx.zzhxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmJktzsHistoryDao;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.entity.ZzhxmJktzsHistory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhxmJktzsHistoryDao")
public class ZzhxmJktzsHistoryDaoImpl extends BaseDaoImpl implements ZzhxmJktzsHistoryDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhxmJktzsByMap", paraMap, page);
	}

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhxmJktzsHistory(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhxmJktzsHistoryByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmJktzsHistory getById(String id)
	{
		return (ZzhxmJktzsHistory)this.getObjectById(ZzhxmJktzsHistory.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhxmJktzs 信息
	 */
	public void save(ZzhxmJktzsHistory zzhxmJktzsHistory)
	{
		zzhxmJktzsHistory.setId(null);
		this.saveOrUpdateObject(zzhxmJktzsHistory);
	}

	/**
	 * 修改信息
	 * @param zzhxmJktzs 信息
	 */
	public void update(ZzhxmJktzsHistory zzhxmJktzsHistory)
	{
		this.saveOrUpdateObject(zzhxmJktzsHistory);
	}
	/**
	 * 修改信息
	 * @param zzhxmJktzs 信息
	 */
	@Override
	public void updateNotSave(ZzhxmJktzsHistory zzhxmJktzsHistory)
	{
		this.update(zzhxmJktzsHistory);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(ZzhxmJktzsHistory.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		ZzhxmJktzsHistory zzhxmJktzsHistory = (ZzhxmJktzsHistory)this.getObjectById(ZzhxmJktzsHistory.class, id);
		zzhxmJktzsHistory.setDelFlag(1);
		this.saveObject(zzhxmJktzsHistory);
	}
}
