package com.jshx.zzhxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.ZzhxmJktzsDao;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhxmjktzsDao")
public class ZzhxmJktzsDaoImpl extends BaseDaoImpl implements ZzhxmJktzsDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhxmJktzsByMap", paraMap, page);
	}

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhxmJktzs(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhxmJktzsByMap", paraMap);
	}

	public List findYzsMaterialCol(Map<String, Object> paraMap){
		return this.findListByHqlId("findYzsMaterialColByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmJktzs getById(String id)
	{
		return (ZzhxmJktzs)this.getObjectById(ZzhxmJktzs.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhxmJktzs 信息
	 */
	public void save(ZzhxmJktzs zzhxmJktzs)
	{
		zzhxmJktzs.setId(null);
		this.saveOrUpdateObject(zzhxmJktzs);
	}

	/**
	 * 修改信息
	 * @param zzhxmJktzs 信息
	 */
	public void update(ZzhxmJktzs zzhxmJktzs)
	{
		this.saveOrUpdateObject(zzhxmJktzs);
	}
	/**
	 * 修改信息
	 * @param zzhxmJktzs 信息
	 */
	@Override
	public void updateNotSave(ZzhxmJktzs zzhxmJktzs)
	{
		this.update(zzhxmJktzs);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(ZzhxmJktzs.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		ZzhxmJktzs zzhxmJktzs = (ZzhxmJktzs)this.getObjectById(ZzhxmJktzs.class, id);
		zzhxmJktzs.setDelFlag(1);
		this.saveObject(zzhxmJktzs);
	}
}
