package com.jshx.zzhxm.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhxm.dao.YzsMaterialColDao;
import com.jshx.zzhxm.entity.YzsMaterialCol;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("yzsmaterialcolDao")
public class YzsMaterialColDaoImpl extends BaseDaoImpl implements YzsMaterialColDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findYzsMaterialColByMap", paraMap, page);
	}

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findYzsMaterialCol(Map<String, Object> paraMap){
		return this.findListByHqlId("findYzsMaterialColByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public YzsMaterialCol getById(String id)
	{
		return (YzsMaterialCol)this.getObjectById(YzsMaterialCol.class, id);
	}

	/**
	 * 保存信息
	 * @param yzsMaterialCol 信息
	 */
	public void save(YzsMaterialCol yzsMaterialCol)
	{
		yzsMaterialCol.setId(null);
		this.saveOrUpdateObject(yzsMaterialCol);
	}

	/**
	 * 修改信息
	 * @param yzsMaterialCol 信息
	 */
	public void update(YzsMaterialCol yzsMaterialCol)
	{
		this.saveOrUpdateObject(yzsMaterialCol);
	}

	/**
	 * 修改信息
	 * @param yzsMaterialCol 信息
	 */
	@Override
	public void updateNotSave(YzsMaterialCol yzsMaterialCol)
	{
		this.update(yzsMaterialCol);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(YzsMaterialCol.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		YzsMaterialCol yzsMaterialCol = (YzsMaterialCol)this.getObjectById(YzsMaterialCol.class, id);
		yzsMaterialCol.setDelFlag(1);
		this.saveObject(yzsMaterialCol);
	}
}
