package com.jshx.zzhqftk.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhqfdz.dao.ZzhqfdzDao;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqftk.dao.ZzhqftkDao;
import com.jshx.zzhqftk.entity.Zzhqftk;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhqftkDao")
public class ZzhqftkDaoImpl extends BaseDaoImpl implements ZzhqftkDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhqftkByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhqftk(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhqftkByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqftk getById(String id)
	{
		return (Zzhqftk)this.getObjectById(Zzhqftk.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhqftk 信息
	 */
	public void save(Zzhqftk zzhqftk)
	{
		zzhqftk.setId(null);
		this.saveOrUpdateObject(zzhqftk);
	}

	/**
	 * 修改信息
	 * @param zzhqftk 信息
	 */
	public void update(Zzhqftk zzhqftk)
	{
		this.saveOrUpdateObject(zzhqftk);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Zzhqftk.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Zzhqftk zzhqftk = (Zzhqftk)this.getObjectById(Zzhqftk.class, id);
		zzhqftk.setDelFlag(1);
		this.saveObject(zzhqftk);
	}
}
