package com.jshx.zzhqfdz.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.zzhkppj.entity.Zzhkppj;
import com.jshx.zzhkppj.service.ZzhkppjService;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.entity.Zzhqfhz;
import com.jshx.zzhqfdz.entity.Zzhqfhzmx;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhqfdz.service.ZzhqfhzService;
import com.jshx.zzhqfdz.service.ZzhqfhzmxService;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.entity.ZzhxmSfxx;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import com.jshx.zzhxm.service.ZzhxmSfxxService;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

public class ZzhqfhzAction extends BaseAction
{
	private static Logger logger = LoggerFactory.getLogger(ZzhqfhzAction.class);

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String jktzsbhVal;
	private List<Zzhqfhz> zzhqfhzList = new ArrayList<>();
	private List<ZzhxmJktzs> zzhxmJktzsList = new ArrayList<>();
	private List<ZzhxmSfxx> zzhxmSfxxList = new ArrayList<>();
	List<ZzhxmSfxx> newzzhxmSfxxList = new ArrayList<ZzhxmSfxx>();
	List<String> xmhzList = new ArrayList<String>();



	Map<String,List<ZzhxmSfxx>> bankMap =  new LinkedHashMap();
	Map<String,List<Zzhkppj>> bankMapkp =  new LinkedHashMap();
	Map<String, Map<String, String>> bankDetail = new HashMap<>();
	private List<Zzhqfhzmx> zzhqfhzmxList = new ArrayList<>();

	/**
	 * 实体类
	 */
	private Zzhqfhz zzhqfhz = new Zzhqfhz();
	private ZzhxmJktzs zzhxmJktzs = new ZzhxmJktzs();
	private ZzhxmSfxx zzhxmSfxx = new ZzhxmSfxx();

	/**
	 * 业务类
	 */
	@Autowired
	private ZzhqfhzService zzhqfhzService;
	@Autowired
	private ZzhxmJktzsService zzhxmJktzsService;
	@Autowired
	private ZzhxmSfxxService zzhxmSfxxService;
	@Autowired
	private ZzhqfhzmxService zzhqfhzmxService;
	@Autowired
	private ZzhkppjService zzhkppjService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;


	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;


	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		/*if(null != zzhxmJktzs){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != zzhxmJktzs.getJfdmwybh()) && (0 < zzhxmJktzs.getJfdmwybh().trim().length())){
				paraMap.put("jfdmwybh", "%" + zzhxmJktzs.getJfdmwybh().trim() + "%");
			}
			if ((null != zzhxmJktzs.getAccountDetail()) && (0 < zzhxmJktzs.getAccountDetail().trim().length())){
				paraMap.put("accountDetail", "%" + zzhxmJktzs.getAccountDetail().trim() + "%");
			}
			if ((null != zzhxmJktzs.getJktzsbh()) && (0 < zzhxmJktzs.getJktzsbh().trim().length())){
				paraMap.put("jktzsbh", "%" + zzhxmJktzs.getJktzsbh().trim() + "%");
			}
		}*/
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "";
		final String filter = "id|qfqrsj|qfjkzje|qfjklxid|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = zzhqfhzService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}


	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		try {
			BigDecimal bd =  new BigDecimal("0");
			Map<String,Object> paramMap2 = new HashMap<>();
			List<String> fshList = new ArrayList<>();//非税行
			List<ZzhxmSfxx> zzhxmSfxxList1 = new ArrayList<>();
			if ((null != zzhqfhz) && (null != zzhqfhz.getId())) {
				//获取清分汇总明细
				paramMap2.put("qfhzid",zzhqfhz.getId());
				zzhqfhzmxList = zzhqfhzmxService.findZzhqfhzmx(paramMap2);
				for(Zzhqfhzmx zzhqfhzmx1:zzhqfhzmxList){
					bd =  bd.add(new BigDecimal(zzhqfhzmx1.getQfyjjemx()));
				}
				for(Zzhqfhzmx zzhqfhzmx2:zzhqfhzmxList){
					zzhqfhzmx2.setQfhzhjje(bd.toString());
					zzhqfhzmxService.update(zzhqfhzmx2);
				}

				zzhqfhz = zzhqfhzService.getById(zzhqfhz.getId());
				String qfjklxid = zzhqfhz.getQfjklxid();
				Map<String, Object> paramMap = new HashMap<>();
				paramMap.put("qfjklxid", qfjklxid);
				zzhxmJktzsList = zzhxmJktzsService.findZzhxmJktzs(paramMap);
				if (CollectionUtils.isNotEmpty(zzhxmJktzsList)) {
					for(int i=0;i<zzhxmJktzsList.size();i++){
						Map<String, Object> paramMap1 = new HashMap<>();
						String jfdmwybh = zzhxmJktzsList.get(i).getJfdmwybh();
						paramMap1.put("jfdmwybh",jfdmwybh);
						zzhxmSfxxList =  zzhxmSfxxService.findZzhxmSfxx(paramMap1);
						if(CollectionUtils.isNotEmpty(zzhxmSfxxList)) {
							for (int j = 0; j < zzhxmSfxxList.size(); j++) {
								zzhxmSfxxList1.add(zzhxmSfxxList.get(j));
							}
						}
					}
				}
			}
			Map<String, Object> paramMap1 = new HashMap<>();
			//根据银行划分明细清单
			for(ZzhxmSfxx zzhxmSfxx:zzhxmSfxxList1){
				ZzhxmJktzs zzhxmJktzs111 = zzhxmJktzsService.getByJfdmwybh(zzhxmSfxx.getJfdmwybh());
				List<Zzhkppj> zzhkppjList = new ArrayList<>();
				paramMap1.put("sfxmmc", zzhxmSfxx.getSfxmmc());
				paramMap1.put("accountDetail", zzhxmJktzs111.getAccountDetail());
				zzhkppjList = zzhkppjService.findZzhkppj(paramMap1);
//				Zzhkppj zzhkppj = new Zzhkppj();
				String khyh = zzhxmSfxx.getKhyh();
				if(bankMapkp.containsKey(khyh)){
					/*
					zzhxmSfxx.setZzh(zzhxmJktzs111.getAccountDetail());
					zzhxmSfxx.setJftzsbh(zzhxmJktzs111.getJktzsbh());*/
					if(CollectionUtils.isNotEmpty(zzhkppjList) || zzhkppjList.size() != 0) {
						for (Zzhkppj zzhkppj : zzhkppjList) {
							bankMapkp.get(khyh).add(zzhkppj);
						}
					}
				}else{
					//存银行明细
//					List<Zzhkppj> list = new ArrayList<>();
//					ZzhxmJktzs zzhxmJktzs11 = zzhxmJktzsService.getByJfdmwybh(zzhxmSfxx.getJfdmwybh());
					if(CollectionUtils.isNotEmpty(zzhkppjList) || zzhkppjList.size() != 0) {
						/*zzhkppj.setAccountDetail(zzhxmSfxx.getZzh());
						zzhkppj.setJktzsbh(zzhxmJktzs11.getJktzsbh());
						zzhkppj.setJktzsbh(zzhxmJktzs11.getJktzsbh());
						list.add(zzhkppj);*/
						bankMapkp.put(khyh,zzhkppjList);
					}
				}
			}
		}catch (Exception e){
			logger.error(e.getMessage());
		}
		return VIEW;
	}




	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		if((null != zzhqfhz)&&(null != zzhqfhz.getId())){
			zzhqfhz = zzhqfhzService.getById(zzhqfhz.getId());
			Map<String, Object> paramMap = new HashMap<>();
			String jfdmwybh = zzhxmJktzs.getJfdmwybh();
			paramMap.put("jfdmwybh", jfdmwybh);
			zzhqfhzList = zzhqfhzService.findZzhqfhz(paramMap);
		}
		return EDIT;
	}


	/**
	 * 	添加字典信息
	 */
	public String initEditadd() throws Exception{
		view();
		return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}

		if ("mod".equalsIgnoreCase(this.flag)){
			String[] sfxxId = zzhxmSfxx.getId().split(",");
			String[] sfxxybjksbh = zzhxmSfxx.getYbjksbh().split(",");
			String[] sfxxkpsj = zzhxmSfxx.getKpsj().split(",");
			String[] sfxxkpje = zzhxmSfxx.getKpje().split(",");

			List<String> sfxxIdList = Arrays.asList(sfxxId);
			List<String> sfxxybjksbhList = Arrays.asList(sfxxybjksbh);
			List<String> sfxxkpsjList = Arrays.asList(sfxxkpsj);
			List<String> sfxxkpjeList = Arrays.asList(sfxxkpje);

			try{
				for(int i=0;i<sfxxIdList.size();i++){
					String sid = sfxxIdList.get(i).trim();
					ZzhxmSfxx zzhxmSfxx1 = zzhxmSfxxService.getById(sid);
					if(zzhxmSfxx1 != null){
						zzhxmSfxx1.setYbjksbh(sfxxybjksbhList.get(i).trim());
						zzhxmSfxx1.setKpsj(sfxxkpsjList.get(i).trim());
						zzhxmSfxx1.setKpje(sfxxkpjeList.get(i).trim());
						zzhxmSfxxService.update(zzhxmSfxx1);
					}
				}
				ZzhxmJktzs zzhxmJktzs1 = zzhxmJktzsService.getById(zzhxmJktzs.getId());
				zzhxmJktzs1.setKpzt("1");//改为已开票
				zzhxmJktzsService.update(zzhxmJktzs1);
			}catch(Exception e){
				logger.error(e.getMessage());
			}
		}
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (null != zzhqfhz)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
			zzhqfhzService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getJktzsbhVal() {
		return jktzsbhVal;
	}

	public void setJktzsbhVal(String jktzsbhVal) {
		this.jktzsbhVal = jktzsbhVal;
	}

	public ZzhxmJktzs getZzhxmJktzs() {
		return zzhxmJktzs;
	}

	public void setZzhxmJktzs(ZzhxmJktzs zzhxmJktzs) {
		this.zzhxmJktzs = zzhxmJktzs;
	}

	public ZzhxmSfxx getZzhxmSfxx() {
		return zzhxmSfxx;
	}

	public void setZzhxmSfxx(ZzhxmSfxx zzhxmSfxx) {
		this.zzhxmSfxx = zzhxmSfxx;
	}

	public List<Zzhqfhz> getZzhqfhzList() {
		return zzhqfhzList;
	}

	public void setZzhqfhzList(List<Zzhqfhz> zzhqfhzList) {
		this.zzhqfhzList = zzhqfhzList;
	}

	public Zzhqfhz getZzhqfhz() {
		return zzhqfhz;
	}

	public void setZzhqfhz(Zzhqfhz zzhqfhz) {
		this.zzhqfhz = zzhqfhz;
	}

	public List<ZzhxmJktzs> getZzhxmJktzsList() {
		return zzhxmJktzsList;
	}

	public void setZzhxmJktzsList(List<ZzhxmJktzs> zzhxmJktzsList) {
		this.zzhxmJktzsList = zzhxmJktzsList;
	}

	public List<ZzhxmSfxx> getZzhxmSfxxList() {
		return zzhxmSfxxList;
	}

	public void setZzhxmSfxxList(List<ZzhxmSfxx> zzhxmSfxxList) {
		this.zzhxmSfxxList = zzhxmSfxxList;
	}

	public List<ZzhxmSfxx> getNewzzhxmSfxxList() {
		return newzzhxmSfxxList;
	}

	public void setNewzzhxmSfxxList(List<ZzhxmSfxx> newzzhxmSfxxList) {
		this.newzzhxmSfxxList = newzzhxmSfxxList;
	}

	public List<String> getXmhzList() {
		return xmhzList;
	}

	public void setXmhzList(List<String> xmhzList) {
		this.xmhzList = xmhzList;
	}

	public Map<String, List<ZzhxmSfxx>> getBankMap() {
		return bankMap;
	}

	public void setBankMap(Map<String, List<ZzhxmSfxx>> bankMap) {
		this.bankMap = bankMap;
	}

	public Map<String, Map<String, String>> getBankDetail() {
		return bankDetail;
	}

	public void setBankDetail(Map<String, Map<String, String>> bankDetail) {
		this.bankDetail = bankDetail;
	}

	public List<Zzhqfhzmx> getZzhqfhzmxList() {
		return zzhqfhzmxList;
	}

	public void setZzhqfhzmxList(List<Zzhqfhzmx> zzhqfhzmxList) {
		this.zzhqfhzmxList = zzhqfhzmxList;
	}

	public Map<String, List<Zzhkppj>> getBankMapkp() {
		return bankMapkp;
	}

	public void setBankMapkp(Map<String, List<Zzhkppj>> bankMapkp) {
		this.bankMapkp = bankMapkp;
	}
}
