package com.jshx.zzhqfdz.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwjzpz.dao.YzscwjzpzDao;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhqfdz.dao.ZzhqfdzDao;
import com.jshx.zzhqfdz.dao.ZzhqfhzDao;
import com.jshx.zzhqfdz.dao.ZzhqfhzmxDao;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhqfdz.entity.Zzhqfhz;
import com.jshx.zzhqfdz.entity.Zzhqfhzmx;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhqfdz.service.ZzhqfhzService;
import com.jshx.zzhxm.dao.ZzhxmJktzsDao;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.entity.ZzhxmSfxx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;

@Service("zzhqfhzService")
public class ZzhqfhzServiceImpl extends BaseServiceImpl implements ZzhqfhzService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhqfhzDao")
	private ZzhqfhzDao zzhqfhzDao;

	@Autowired()
	@Qualifier("zzhxmjktzsDao")
	private ZzhxmJktzsDao zzhxmJktzsDao;

	@Autowired()
	@Qualifier("zzhqfhzmxDao")
	private ZzhqfhzmxDao zzhqfhzmxDao;

	@Autowired()
	@Qualifier("yzscwjzpzDao")
	private YzscwjzpzDao yzscwjzpzDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhqfhzDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqfhz getById(String id)
	{
		return zzhqfhzDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhqfhz 信息
	 */
	@Transactional
	public void save(Zzhqfhz zzhqfhz)
	{
		zzhqfhzDao.save(zzhqfhz);
	}

	/**
	 * 修改信息
	 * @param zzhqfhz 信息
	 */
	@Transactional
	public void update(Zzhqfhz zzhqfhz)
	{
		zzhqfhzDao.update(zzhqfhz);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhqfhzDao.findZzhqfhz(paraMap);
		zzhqfhzDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhqfhzDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Zzhqfhz> findZzhqfhz(Map<String, Object> paraMap) {

		return zzhqfhzDao.findZzhqfhz(paraMap);

	}

	/**
	 * 确认清分保存信息
	 * @param zzhqfhz
	 * @param bankDetail
	 * @param zzhxmJktzsList111
	 */
	@Transactional
	public void saveQrqf(Zzhqfhz zzhqfhz, Map<String,Map<String,String>> bankDetail, List<ZzhxmJktzs>  zzhxmJktzsList111){
//		zzhqfhzDao.save(zzhqfhz);
		//存清分汇总明细表
		for(Map.Entry<String, Map<String, String>> entry : bankDetail.entrySet()){
			Zzhqfhzmx zzhqfhzmx = new Zzhqfhzmx();
			zzhqfhzmx.setFshmc(entry.getValue().get("fshmc"));
			zzhqfhzmx.setFshzh(entry.getValue().get("fshzh"));
			zzhqfhzmx.setQfhzid(entry.getValue().get("qfhzid"));
			zzhqfhzmx.setQfyjjemx(entry.getValue().get("qfyjjemx"));
			zzhqfhzmx.setQfhzlsh(entry.getValue().get("qfhzlsh"));
			zzhqfhzmx.setDelFlag(0);
			zzhqfhzmxDao.save(zzhqfhzmx);

			//存一站式财务机制凭证
			/*SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Yzscwjzpz yzscwjz	pz = new Yzscwjzpz();
			yzscwjzpz.setDelFlag(0);
			yzscwjzpz.setZdzt("0");//制单状态
			yzscwjzpz.setIspz("0");//是否生成凭证
			yzscwjzpz.setZdtrq(java.sql.Date.valueOf(sdf.format(new Date())));//业务日期
			yzscwjzpz.setJzpzje(entry.getValue().get("qfyjjemx"));//机制凭证金额
			yzscwjzpz.setJfje(entry.getValue().get("qfyjjemx"));//借方金额
			yzscwjzpz.setDfje(entry.getValue().get("qfyjjemx"));//贷方金额
			yzscwjzpz.setJzpzlx("资金清分凭证");//机制凭证类型
			yzscwjzpz.setFshmc(entry.getValue().get("fshmc"));//非税行名称
			String zy = sdf.format(new Date()).substring(0,7) + "上缴" + entry.getValue().get("fshmc") +"非税收入";
			yzscwjzpz.setZy(zy);
			yzscwjzpz.setQfhzid(entry.getValue().get("qfhzid"));//清分汇总id
			yzscwjzpz.setQfhzlsh(entry.getValue().get("qfhzlsh"));//清分汇总流水号
			yzscwjzpzDao.save(yzscwjzpz);*/
		}
		for(ZzhxmJktzs zzhxmJktzs:zzhxmJktzsList111){
			zzhxmJktzs.setQfzt("1");
			zzhxmJktzsDao.update(zzhxmJktzs);
		}
	}




}
