package com.jshx.zzhqfdz.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhqfdz.dao.ZzhqfhzmxDao;
import com.jshx.zzhqfdz.entity.Zzhqfhz;
import com.jshx.zzhqfdz.entity.Zzhqfhzlsh;
import com.jshx.zzhqfdz.entity.Zzhqfhzmx;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("zzhqfhzmxDao")
public class ZzhqfhzmxDaoImpl extends BaseDaoImpl implements ZzhqfhzmxDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findZzhqfhzmxByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findZzhqfhzmx(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhqfhzmxByMap", paraMap);
	}

	public List findZzhqfhzlsh(Map<String, Object> paraMap){
		return this.findListByHqlId("findZzhqfhzlshByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhqfhzmx getById(String id)
	{
		return (Zzhqfhzmx)this.getObjectById(Zzhqfhzmx.class, id);
	}

	/**
	 * 保存信息
	 * @param zzhqfhzmx 信息
	 */
	public void save(Zzhqfhzmx zzhqfhzmx)
	{
		zzhqfhzmx.setId(null);
		this.saveOrUpdateObject(zzhqfhzmx);
	}

	public void save(Zzhqfhzlsh zzhqfhzlsh)
	{
		zzhqfhzlsh.setId(null);
		this.saveOrUpdateObject(zzhqfhzlsh);
	}

	/**
	 * 修改信息
	 * @param zzhqfhzmx 信息
	 */
	public void update(Zzhqfhzmx zzhqfhzmx)
	{
		this.saveOrUpdateObject(zzhqfhzmx);
	}

	public void update(Zzhqfhzlsh zzhqfhzlsh)
	{
		this.saveOrUpdateObject(zzhqfhzlsh);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Zzhqfhzmx.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Zzhqfhzmx zzhqfhzmx = (Zzhqfhzmx)this.getObjectById(Zzhqfhzmx.class, id);
		zzhqfhzmx.setDelFlag(1);
		this.saveObject(zzhqfhzmx);
	}
}
