package com.jshx.zzhkppj.web;

import com.jshx.account.paymentVoucher.service.PaymentVoucherService;
import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.billManager.dao.BillManagerDao;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.common.utils.Constant;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.mobile.utils.JsonUtil;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhkppj.entity.Zzhkppj;
import com.jshx.zzhqfdz.entity.Zzhqfdz;
import com.jshx.zzhkppj.service.ZzhkppjService;
import com.jshx.zzhqfdz.service.ZzhqfdzService;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.entity.ZzhxmSfxx;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import com.jshx.zzhxm.service.ZzhxmService;
import com.jshx.zzhxm.service.ZzhxmSfxxService;
import com.neusoft.egov.utils.billendnumber;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

public class ZzhkppjAction extends BaseAction
{
	private static Logger logger = LoggerFactory.getLogger(ZzhkppjAction.class);

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String jktzsbhVal;
	private String printNo;

	/**
	 * 实体类
	 */
	private Zzhkppj zzhkppj = new Zzhkppj();

	/**
	 * 业务类
	 */
	@Autowired
	private ZzhkppjService zzhkppjService;
	@Autowired
	private ZzhxmSfxxService zzhxmSfxxService;
	@Autowired
	private ZzhxmService zzhxmService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;


	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;


	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != zzhkppj){

		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != zzhkppj.getAccountDetail()) && (0 < zzhkppj.getAccountDetail().trim().length())){
				paraMap.put("accountDetail", "%" + zzhkppj.getAccountDetail().trim() + "%");
			}
			if ((null != zzhkppj.getJsdwmc()) && (0 < zzhkppj.getJsdwmc().trim().length())){
				paraMap.put("jsdwmc", "%" + zzhkppj.getJsdwmc().trim() + "%");
			}
			if ((null != zzhkppj.getYbjksbh()) && (0 < zzhkppj.getYbjksbh().trim().length())){
				paraMap.put("ybjksbh", "%" + zzhkppj.getYbjksbh().trim() + "%");
			}
			if ((null != zzhkppj.getPjzt()) && (0 < zzhkppj.getPjzt().trim().length())){
				paraMap.put("pjzt", "%" + zzhkppj.getPjzt().trim() + "%");
			}
			if ((null != zzhkppj.getJktzsbh()) && (0 < zzhkppj.getJktzsbh().trim().length())){
				paraMap.put("jktzsbh", "%" + zzhkppj.getJktzsbh().trim() + "%");
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "";
		final String filter = "id|jfdmwybh|accountDetail|jktzsbh|jsdwmc|gcxmmc|sfxmmc|ybjksbh|kpje|kprq|pjzt|fsdzrq|pjqfrq|zfrq|fsdzrq|pjjxrq|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = zzhkppjService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	// 初始化更新缴销清分日期页面
	public String initUpdateDate() {
		if (null != zzhkppj && StringUtils.isNotBlank(zzhkppj.getId())) {
			zzhkppj = zzhkppjService.getById(zzhkppj.getId());
		}
		return EDIT;
	}

	public String updateQfrq() {
		if (null != zzhkppj && StringUtils.isNotBlank(zzhkppj.getId())) {
			Zzhkppj byId = zzhkppjService.getById(zzhkppj.getId());
			byId.setPjzt("3");
			byId.setPjjxrq(zzhkppj.getPjqfrq());
			byId.setPjqfrq(zzhkppj.getPjqfrq());
//			zzhkppjService.update(byId);

			//存一站式财务机制凭证
			Map<String,Object> paramMap33 = new HashMap<>();
			ZzhxmSfxx zzhxmSfxx22 = new ZzhxmSfxx();
			paramMap33.put("jfdmwybh",byId.getJfdmwybh());
			paramMap33.put("sfxmmc",byId.getSfxmmc());
			List<ZzhxmSfxx> zzhxmSfxxList22 = new ArrayList<>();
			zzhxmSfxxList22 = zzhxmSfxxService.findZzhxmSfxx(paramMap33);
			if(CollectionUtils.isNotEmpty(zzhxmSfxxList22)){
				zzhxmSfxx22 = zzhxmSfxxList22.get(0);
			}

			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Yzscwjzpz yzscwjzpz = new Yzscwjzpz();
			yzscwjzpz.setDelFlag(0);
			yzscwjzpz.setZdzt("0");//制单状态
			yzscwjzpz.setIspz("0");//是否生成凭证
			yzscwjzpz.setZdtrq(DateTime.parse(byId.getPjqfrq().substring(0,10)).toDate());//业务日期
			yzscwjzpz.setJxrq(DateTime.parse(byId.getPjqfrq().substring(0,10)).toDate());//缴销日期
			yzscwjzpz.setJzpzje(byId.getKpje());//机制凭证金额
			yzscwjzpz.setJfje(byId.getKpje());//借方金额
			yzscwjzpz.setDfje(byId.getKpje());//贷方金额
			yzscwjzpz.setJzpzlx("资金清分凭证");//机制凭证类型
			String zy = byId.getPjqfrq().substring(0,7) + "上缴" + zzhxmSfxx22.getKhyh() +"非税收入";
			yzscwjzpz.setZy(zy);
			yzscwjzpz.setFshmc(zzhxmSfxx22.getKhyh());//非税行名称
			yzscwjzpz.setGcxmmc(byId.getGcxmmc());//项目名称
			yzscwjzpz.setJfdwmc(byId.getJsdwmc());//缴费单位名称
			yzscwjzpz.setJfdmwybh(byId.getJfdmwybh());//缴费代码唯一编号
			yzscwjzpz.setJktzsbh(byId.getJktzsbh());//缴款通知书编号
			yzscwjzpz.setAccountDetail(byId.getAccountDetail());//子账户账号
			yzscwjzpz.setYbjksbh(byId.getYbjksbh());//非税票据号码
			yzscwjzpz.setSfxmmc(byId.getSfxmmc());//收费事项
			yzscwjzpz.setYzsqy(zzhxmSfxx22.getYzsqy());//收费区域

			zzhxmService.saveJk6(byId,yzscwjzpz);
		}
		return  RELOAD;
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != zzhkppj)&&(null != zzhkppj.getId())){
			zzhkppj = zzhkppjService.getById(zzhkppj.getId());
		}
		return VIEW;
	}

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
			zzhkppjService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getJktzsbhVal() {
		return jktzsbhVal;
	}

	public void setJktzsbhVal(String jktzsbhVal) {
		this.jktzsbhVal = jktzsbhVal;
	}

	public String getPrintNo() {
		return printNo;
	}

	public void setPrintNo(String printNo) {
		this.printNo = printNo;
	}

	public Zzhkppj getZzhkppj() {
		return zzhkppj;
	}

	public void setZzhkppj(Zzhkppj zzhkppj) {
		this.zzhkppj = zzhkppj;
	}
}
