package com.jshx.zzhgl.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.zzhgl.entity.Zzh;
import com.jshx.zzhgl.service.ZzhglService;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ZzhglAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Zzh zzh = new Zzh();

	/**
	 * 业务类
	 */
	@Autowired
	private ZzhglService zzhglService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;



	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != zzh){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != zzh.getAccountName()) && (0 < zzh.getAccountName().trim().length())){
				paraMap.put("accountName", "%" + zzh.getAccountName().trim() + "%");
			}
			if ((null != zzh.getAccountDetail()) && (0 < zzh.getAccountDetail().trim().length())){
				paraMap.put("accountDetail", "%" + zzh.getAccountDetail().trim() + "%");
			}
			if ((null != zzh.getAccountStatus()) && (0 < zzh.getAccountStatus().trim().length())){
				paraMap.put("accountStatus", zzh.getAccountStatus().trim());
			}
			if ((null != zzh.getZzhktFlag()) && (0 < zzh.getZzhktFlag().trim().length())){
				paraMap.put("zzhktFlag", zzh.getZzhktFlag().trim());
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|accountName|accountDetail|accountStatus|createTime|zhuzh|khh|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = zzhglService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != zzh)&&(null != zzh.getId()))
			zzh = zzhglService.getById(zzh.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}
		zzh.setDeptId(this.getLoginUserDepartmentId());
		String zzhktqjz = changeQj(zzh.getZzhktqjz());
		String zzhktqjy = changeQj(zzh.getZzhktqjy());
		String zzhz = "476773173268000"+zzhktqjz;
		String zzhy = "476773173268000"+zzhktqjy;
		Map<String,Object> map = new HashMap<>();
		map.put("zzhz",zzhz);
		map.put("zzhy",zzhy);
		zzhglService.activeZzh(map);
		return RELOAD;
	}

	public String changeQj(String str){
		StringBuilder sb = new StringBuilder();
		for(int i =0;i<4-str.length();i++){
			sb.append("0");
		}
		sb.append(str);
		return sb.toString();
	}

	public static void main(String[] args) {
		/*String str = "23";
		StringBuilder sb = new StringBuilder();
		for(int i =0;i<4-str.length();i++){
			sb.append("0");
		}
		System.out.println(sb.append(str));*/

		Map<String,Integer> map = new HashMap<>();
		map.put("Tom",22);
		map.put("Jack",20);
		map.put("Lucy",18);
		System.out.println("二次取值遍历:");
		for(String key : map.keySet()){
			System.out.printf("%s=%d %c",key,map.get(key),',');
		}
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != zzh)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			zzhglService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Zzh getZzh(){
		return this.zzh;
	}

	public void setZzh(Zzh zzh){
		this.zzh = zzh;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
}
