package com.jshx.zzhgl.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhgl.dao.ZzhglDao;
import com.jshx.zzhgl.entity.Zzh;
import com.jshx.zzhgl.service.ZzhglService;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Service("zzhglService")
public class ZzhglServiceImpl extends BaseServiceImpl implements ZzhglService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhglDao")
	private ZzhglDao zzhglDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhglDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzh getById(String id)
	{
		return zzhglDao.getById(id);
	}
	@Override
	public Zzh getBySerialNo(String serialNo) {
		Map<String, String> paraMap = new HashMap<String, String>();
		paraMap.put("serialNo", serialNo);
		Zzh zzh = (Zzh) zzhglDao.findObjectByFieldsMap(Zzh.class, paraMap);
		return zzh;
	}

	@Override
	public Zzh getByAccountDetail(String accountDetail) {
		Map<String, String> paraMap = new HashMap<String, String>();
		paraMap.put("accountDetail", accountDetail);
		Zzh zzh = (Zzh) zzhglDao.findObjectByFieldsMap(Zzh.class, paraMap);
		return zzh;
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Zzh zzh)
	{
		zzhglDao.save(zzh);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Zzh zzh)
	{
		zzhglDao.update(zzh);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhglDao.findZzhgl(paraMap);

		zzhglDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhglDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Zzh> findZzhgl(Map<String, Object> paraMap) {

		return zzhglDao.findZzhgl(paraMap);

	}

	@Override
	public String findZzh(Map<String,Object> map){
		List<String> zzhlist = new ArrayList<>();
		String zzhzh = "";
		zzhlist = zzhglDao.findZzh(map);
		if(!CollectionUtils.isEmpty(zzhlist)){
			zzhzh = zzhlist.get(0);
		}
		return zzhzh;
	}

	/**
	 * 更新子账户
	 */
	@Transactional
	public void activeZzh(Map<String,Object> map){
		zzhglDao.activeZzh(map);
	}

}
