package com.jshx.zzhgl.service;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhgl.entity.Zzh;

import java.util.List;
import java.util.Map;

public interface ZzhglService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public List<Zzh> findZzhgl(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzh getById(String id);
	public Zzh getBySerialNo(String serialNo);
	public Zzh getByAccountDetail(String accountDetail);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Zzh model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Zzh model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);

	/**
	 * 随机获取子账户
	 * @return
	 */
	public String findZzh(Map<String,Object> map);

	/**
	 * 更新子账户
	 */
	public void activeZzh(Map<String,Object> map);
}
