package com.jshx.zsdw.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zsdw.dao.ZsdwDao;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;

@Service("zsdwService")
public class ZsdwServiceImpl extends BaseServiceImpl implements ZsdwService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zsdwDao")
	private ZsdwDao zsdwDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zsdwDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zsdw getById(String id)
	{
		return zsdwDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Zsdw zsdw)
	{
		zsdwDao.save(zsdw);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Zsdw zsdw)
	{
		zsdwDao.update(zsdw);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zsdwDao.findZsdw(paraMap);
		
		zsdwDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    zsdwDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Zsdw> findZsdw(Map<String, Object> paraMap) {
             return zsdwDao.findZsdw(paraMap);
	}
	
	/**
	 * 根据用户部门ID 返回单位代码
	 */
	    @Override
	   public  String getDwdm(String deptid){
		   Map<String, Object> paraMap = new HashMap<String, Object>();
		   paraMap.put("bmzj", deptid.trim());
		   List<Zsdw> lzsdw= zsdwDao.findZsdw(paraMap);
		   if(null!=lzsdw&&lzsdw.size()>0){
			   return lzsdw.get(0).getZsdm();
		   }
		   return "";
	   }
	    /**
	     * 返回执收单位
	     */

	@Override
	public Zsdw getzsdw(String deptid) {
		 Map<String, Object> paraMap = new HashMap<String, Object>();
		   paraMap.put("bmzj", deptid.trim());
		   List<Zsdw> lzsdw= zsdwDao.findZsdw(paraMap);
		   if(null!=lzsdw&&lzsdw.size()>0){
			   return lzsdw.get(0);
		   }
		   return null;
	}

		@Override
		public String getDwdmByzsdw(String zsdw) {
			Map<String, Object> paraMap = new HashMap<String, Object>();
			   paraMap.put("zsdw", zsdw.trim());
			   List<Zsdw> lzsdw= zsdwDao.findZsdw(paraMap);
			   if(null!=lzsdw&&lzsdw.size()>0){
				   return lzsdw.get(0).getZsdm();
			   }
			   return null;
		}

		@Override
		public String getDwdwByzsdm(String zsdm) {
			Map<String, Object> paraMap = new HashMap<String, Object>();
			   paraMap.put("zsdm", zsdm.trim());
			   List<Zsdw> lzsdw= zsdwDao.findZsdw(paraMap);
			   if(null!=lzsdw&&lzsdw.size()>0){
				   return lzsdw.get(0).getZsdw();
			   }
			   return null;
		}
	
}
