package com.jshx.yzssfgl.web;

import com.fr.web.core.A.S;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.yzssfgl.entity.Yzsdicgl;
import com.jshx.yzssfgl.entity.Yzssfgl;
import com.jshx.yzssfgl.service.YzsdicglService;
import com.jshx.yzssfgl.service.YzssfglService;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.FileInputStream;
import java.util.*;

public class YzssfglAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
    List<String> yzssxqyList = new ArrayList<>();
    List<String> yzssxdsdwList = new ArrayList<>();
    List<String> yzssxsfxmmcList = new ArrayList<>();
    List<String> yzssxshbmList = new ArrayList<>();

	/**
	 * 实体类
	 */
	private Yzssfgl yzssfgl = new Yzssfgl();
	private Yzsdicgl yzsdicgl = new Yzsdicgl();


	/**
	 * 业务类
	 */
	@Autowired
	private YzssfglService yzssfglService;
	private YzsdicglService yzsdicglService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;



	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

        if("请选择".equals(yzssfgl.getYzsqy())){
            yzssfgl.setYzsqy("");
        }
        if("请选择".equals(yzssfgl.getDsdw())){
            yzssfgl.setDsdw("");
        }
        if("请选择".equals(yzssfgl.getSfxmmc())){
            yzssfgl.setSfxmmc("");
        }
        if("请选择".equals(yzssfgl.getShbm())){
            yzssfgl.setShbm("");
        }

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != yzssfgl){

		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != yzssfgl.getYzsqy()) && (0 < yzssfgl.getYzsqy().trim().length())){
				paraMap.put("yzsqy", "%" + yzssfgl.getYzsqy().trim() + "%");
			}
			if ((null != yzssfgl.getDsdw()) && (0 < yzssfgl.getDsdw().trim().length())){
				paraMap.put("dsdw", "%" + yzssfgl.getDsdw().trim() + "%");
			}
			if ((null != yzssfgl.getSfxmmc()) && (0 < yzssfgl.getSfxmmc().trim().length())){
				paraMap.put("sfxmmc", "%" + yzssfgl.getSfxmmc().trim() + "%");
			}
			if ((null != yzssfgl.getShbm()) && (0 < yzssfgl.getShbm().trim().length())){
				paraMap.put("shbm", "%" + yzssfgl.getShbm().trim() + "%");
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|yzsqy|dsdw|sfxmmc|shbm|ssdwmc|qhm|fsxmbm|zsdwbm|skrqc|skrzh|khyh|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = yzssfglService.findByPage(pagination, paraMap);
		convObjectToJson(pagination, config);
	}

	/**
	 * 	列表页
	 */
	public String init(){
		getQyxx();
        getDsdw();
        getSfxmmc();
        getShbm();
		return SUCCESS;
	}

	/**
	 * 	添加字典信息
	 */
	public String initEditadd() throws Exception{
		view();
        getQyxx();
        getDsdw();
        getSfxmmc();
        getShbm();
		return EDIT;
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != yzssfgl)&&(null != yzssfgl.getId()))
			yzssfgl = yzssfglService.getById(yzssfgl.getId());
		return VIEW;
	}

	/**
	 * 获取收费区域信息
	 */
	public void getQyxx(){
		Map<String,Object> paramMap =  new HashMap<>();
        yzssxqyList =yzssfglService.getYzssfqy(paramMap);
	}

    /**
     * 获取一站式代收单位
     */
    public void getDsdw(){
        Map<String,Object> paramMap =  new HashMap<>();
        yzssxdsdwList =yzssfglService.getYzsdsdw(paramMap);
    }

    /**
     * 获取一站式收费项目名称
     */
    public void getSfxmmc(){
        Map<String,Object> paramMap =  new HashMap<>();
        yzssxsfxmmcList =yzssfglService.getYzssfxmmc(paramMap);
    }

    /**
     * 获取一站式审核部门
     */
    public void getShbm(){
        Map<String,Object> paramMap =  new HashMap<>();
        yzssxshbmList =yzssfglService.getYzsshbm(paramMap);
    }

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
        getQyxx();
        getDsdw();
        getSfxmmc();
        getShbm();
	    return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag)){
			yzssfgl.setDeptId(this.getLoginUserDepartmentId());
			yzssfgl.setDelFlag(0);
			yzssfglService.save(yzssfgl);
		}else{
			yzssfglService.update(yzssfgl);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (null != yzssfgl)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
	    try{
			yzssfglService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Yzssfgl getYzssfgl() {
		return yzssfgl;
	}

	public void setYzssfgl(Yzssfgl yzssfgl) {
		this.yzssfgl = yzssfgl;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

    public List<String> getYzssxqyList() {
        return yzssxqyList;
    }

    public void setYzssxqyList(List<String> yzssxqyList) {
        this.yzssxqyList = yzssxqyList;
    }

    public List<String> getYzssxdsdwList() {
        return yzssxdsdwList;
    }

    public void setYzssxdsdwList(List<String> yzssxdsdwList) {
        this.yzssxdsdwList = yzssxdsdwList;
    }

    public List<String> getYzssxsfxmmcList() {
        return yzssxsfxmmcList;
    }

    public void setYzssxsfxmmcList(List<String> yzssxsfxmmcList) {
        this.yzssxsfxmmcList = yzssxsfxmmcList;
    }

    public List<String> getYzssxshbmList() {
        return yzssxshbmList;
    }

    public void setYzssxshbmList(List<String> yzssxshbmList) {
        this.yzssxshbmList = yzssxshbmList;
    }

    public Yzsdicgl getYzsdicgl() {
        return yzsdicgl;
    }

    public void setYzsdicgl(Yzsdicgl yzsdicgl) {
        this.yzsdicgl = yzsdicgl;
    }
}
