package com.jshx.yzssfgl.service;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzssfgl.entity.Yzssfgl;

import java.util.List;
import java.util.Map;

public interface YzssfglService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public List<Yzssfgl> findYzssfgl(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzssfgl getById(String id);


	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Yzssfgl model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Yzssfgl model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);

	/**
	 * 获取一站式收费区域
	 */
	public List<String> getYzssfqy(Map<String,Object> paramMap);

	/**
	 * 获取一站式代收单位
	 */
	public List<String> getYzsdsdw(Map<String,Object> paramMap);

	/**
	 * 获取一站式收费项目名称
	 */
	public List<String> getYzssfxmmc(Map<String,Object> paramMap);

	/**
	 * 获取一站式审核部门
	 */
	public List<String> getYzsshbm(Map<String,Object> paramMap);

	/**
	 * 获取一站式审核部门
	 */
	public List<String> getJktzsRemarks(Map<String,Object> paramMap);
}
