package com.jshx.yzscw.yzscwpzgl.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwpzgl.dao.YzscwpzglDao;
import com.jshx.yzscw.yzscwpzgl.dao.YzscwpzglSfxxDao;
import com.jshx.yzscw.yzscwpzgl.entity.Yzscwpzgl;
import com.jshx.yzscw.yzscwpzgl.entity.YzscwpzglSfxx;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("yzscwpzglSfxxDao")
public class YzscwpzglSfxxDaoImpl extends BaseDaoImpl implements YzscwpzglSfxxDao {
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findYzscwpzglSfxxByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findYzscwpzglSfxx(Map<String, Object> paraMap){
		return this.findListByHqlId("findYzscwpzglSfxxByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public YzscwpzglSfxx getById(String id)
	{
		return (YzscwpzglSfxx) this.getObjectById(YzscwpzglSfxx.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(YzscwpzglSfxx model)
	{
		model.setId(null);
		this.saveOrUpdateObject(model);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(YzscwpzglSfxx model)
	{
		this.saveOrUpdateObject(model);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(YzscwpzglSfxx.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		YzscwpzglSfxx model = (YzscwpzglSfxx)this.getObjectById(YzscwpzglSfxx.class, id);
		model.setDelFlag(1);
		this.saveObject(model);
	}
}
