package com.jshx.yzscw.yzscwjzpz.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwjzpz.dao.YzscwjzpzDao;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.yzscw.yzscwjzpz.service.YzscwjzpzService;
import com.jshx.yzscw.yzscwpzgl.dao.YzscwpzglSfxxDao;
import com.jshx.yzscw.yzscwpzgl.entity.YzscwpzglSfxx;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("yzscwjzpzService")
public class YzscwjzpzServiceImpl extends BaseServiceImpl implements YzscwjzpzService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("yzscwjzpzDao")
	private YzscwjzpzDao yzscwjzpzDao;

	@Autowired()
	@Qualifier("yzscwpzglSfxxDao")
	private YzscwpzglSfxxDao yzscwpzglSfxxDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return yzscwjzpzDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzscwjzpz getById(String id)
	{
		return yzscwjzpzDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param yzscwjzpz 信息
	 */
	@Transactional
	public void save(Yzscwjzpz yzscwjzpz)
	{
		yzscwjzpzDao.save(yzscwjzpz);
	}

	@Override
	public void saveTo(Yzscwjzpz model) {

	}

	/**
	 * 修改信息
	 * @param yzscwjzpz 信息
	 */
	@Transactional
	public void update(Yzscwjzpz yzscwjzpz)
	{
		yzscwjzpzDao.update(yzscwjzpz);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=yzscwjzpzDao.findYzscwjzpz(paraMap);
		yzscwjzpzDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					yzscwjzpzDao.deleteWithFlag(id);
			}
		}
	}


	@Override
	public List<Yzscwjzpz> findYzscwjzpz(Map<String, Object> paraMap) {
		return yzscwjzpzDao.findYzscwjzpz(paraMap);
	}

	/**
	 * 根据缴费代码唯一编号获取机制凭证
	 * @param jfdmwybh
	 * @return
	 */
	@Override
	public Yzscwjzpz getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		Yzscwjzpz yzscwjzpz = (Yzscwjzpz)yzscwjzpzDao.findObjectByFieldsMap(Yzscwjzpz.class,paramMap);
		return yzscwjzpz;
	}

	/**
	 * 修改凭证状态信息
	 * @param id 信息
	 */
	public void updatePzzt(String id,int voucherStatus){
		Map<String,Object> paramMap = new HashMap<>();
		paramMap.put("pzxglId",id);
		List<Yzscwjzpz> yzscwjzpzList = yzscwjzpzDao.findYzscwjzpz(paramMap);
		if(CollectionUtils.isNotEmpty(yzscwjzpzList)){
			for(Yzscwjzpz yzscwjzpz:yzscwjzpzList){
				yzscwjzpz.setVoucherStatus(voucherStatus);
				yzscwjzpzDao.update(yzscwjzpz);
			}
		}
	}

	@Transactional
	public void saveYzscwpz(YzscwpzglSfxx yzscwpzglSfxx, Yzscwjzpz yzscwjzpz, YzscwpzglSfxx yzscwpzglSfxx1) {
		yzscwpzglSfxxDao.save(yzscwpzglSfxx);
		yzscwpzglSfxxDao.save(yzscwpzglSfxx1);
		yzscwjzpzDao.update(yzscwjzpz);
	}

}
