package com.jshx.xxjl.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.xxjl.entity.Xxjl;
import com.jshx.xxjl.entity.Xxjlhis;

public interface XxjlService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public List findxxjlList(Map<String, Object> paraMap);
	public Xxjl getByxmbzj(String xmbzj);
	public Xxjlhis getByXxjlhis(String xmbzj);
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xxjl getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Xxjl model);
	public void save(Xxjlhis model);
	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Xxjl model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
}
