package com.jshx.xmxxb.web;

import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.wwsqys.entity.Wwsqys;
import com.jshx.wwsqys.service.WwsqysService;
import org.activiti.editor.language.json.converter.util.CollectionUtils;

import org.hibernate.SessionFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.hscmj.entity.Hscmj;
import com.jshx.hscmj.service.HscmjService;
import com.jshx.hsdmj.entity.Hsdmj;
import com.jshx.hsdmj.entity.Hsdmj2;
import com.jshx.hsdmj.service.HsdmjService;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import com.jshx.sdjd.entity.Sdjd;
import com.jshx.sdjd.service.SdjdService;
import com.jshx.szys.entity.Szys;
import com.jshx.szys.service.SzysService;
import com.jshx.xmdrb.entity.Xmdrb;
import com.jshx.xmdrb.service.XmdrbService;
import com.jshx.xmhf.entity.Xmhf;
import com.jshx.xmhf.service.XmhfService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import javax.servlet.http.HttpServletRequest;

public class XmxxbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Xmxxb xmxxb = new Xmxxb();
    private Xmhf xmhf=new Xmhf();
    private Szys szys=new Szys();
    private Sdjd sdjd=new Sdjd();
	/**
	 * 业务类
	 */
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private XmhfService xmhfService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private HsdmjService hsdmjService;
	@Autowired
	private HscmjService hscmjService;
	@Autowired
	private SzysService szysService;
	@Autowired
	private SdjdService sdjdService;
	@Autowired
	private UserService userService;
	@Autowired
	private XmdrbService xmdrbService;
	@Autowired
	private WwsqysService wwsqysService;


	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	/**
	 * 查询附件
	 */
	private String taskId;

	private String comment;
	private String xmbid;
	private String dwdm;
	
	private String slzt;
	private List<FawenAttach> attach;
	private Date querySlsjStart;

	private Date querySlsjEnd;
	
	public List<FawenAttach> getAttach() {
		return attach;
	}

	public void setAttach(List<FawenAttach> attach) {
		this.attach = attach;
	}

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	@Autowired
	private FawenAttachService fawenAttachService;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list1() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (!this.getLoginUser().getIsSuperAdmin())
		{
			List<String> b = new ArrayList<String>();
			String dwdma = "";
			dwdma = zsdwService.getDwdm(this.getLoginUserDepartmentId());
			b.add(0, dwdma);
			b.add(1, "wqr");
			// 未确认和本部门的项目
			paraMap.put("dwdmm", b);
		}
		if (null != xmxxb)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getXmlsh()) && (0 < xmxxb.getXmlsh().trim().length()))
			{
				paraMap.put("xmlsh", "%" + xmxxb.getXmlsh().trim() + "%");
			}

			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length()))
			{
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}

			if ((null != xmxxb.getXmbh()) && (0 < xmxxb.getXmbh().trim().length()))
			{
				paraMap.put("xmbh", "%" + xmxxb.getXmbh().trim() + "%");
			}

			if ((null != xmxxb.getSlbh()) && (0 < xmxxb.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + xmxxb.getSlbh().trim() + "%");
			}

			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length()))
			{
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}

			if ((null != xmxxb.getDwbh()) && (0 < xmxxb.getDwbh().trim().length()))
			{
				paraMap.put("dwbh", "%" + xmxxb.getDwbh().trim() + "%");
			}

			if ((null != xmxxb.getXmmc()) && (0 < xmxxb.getXmmc().trim().length()))
			{
				paraMap.put("xmmc", "%" + xmxxb.getXmmc().trim() + "%");
			}

			if ((null != xmxxb.getLianxiren()) && (0 < xmxxb.getLianxiren().trim().length()))
			{
				paraMap.put("lianxiren", "%" + xmxxb.getLianxiren().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|gzlbh|slbh|xmlsh|xxylb|xmbh|jsdw|dwbh|jbcs|czgs|bllb|ckbh|lsck|zjdyjks|zsdw|zsfw|issdxm|lianxiren|xkzh|jzmjdx|jzmjdc|jzmj27|jzmj8ys|zjzmjds|csje|beizhu|xmmc|mjyj|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xmxxbService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != xmxxb)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getXmlsh()) && (0 < xmxxb.getXmlsh().trim().length()))
			{
				paraMap.put("xmlsh", "%" + xmxxb.getXmlsh().trim() + "%");
			}

			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length()))
			{
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}

			if ((null != xmxxb.getXmbh()) && (0 < xmxxb.getXmbh().trim().length()))
			{
				paraMap.put("xmbh", "%" + xmxxb.getXmbh().trim() + "%");
			}

			if ((null != xmxxb.getSlbh()) && (0 < xmxxb.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + xmxxb.getSlbh().trim() + "%");
			}

			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length()))
			{
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}

			if ((null != xmxxb.getDwbh()) && (0 < xmxxb.getDwbh().trim().length()))
			{
				paraMap.put("dwbh", "%" + xmxxb.getDwbh().trim() + "%");
			}

			if ((null != xmxxb.getXmmc()) && (0 < xmxxb.getXmmc().trim().length()))
			{
				paraMap.put("xmmc", "%" + xmxxb.getXmmc().trim() + "%");
			}

			if ((null != xmxxb.getLianxiren()) && (0 < xmxxb.getLianxiren().trim().length()))
			{
				paraMap.put("lianxiren", "%" + xmxxb.getLianxiren().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|gzlbh|slbh|xmlsh|xxylb|xmbh|jsdw|dwbh|jbcs|czgs|bllb|ckbh|lsck|zjdyjks|zsdw|zsfw|issdxm|lianxiren|xkzh|jzmjdx|jzmjdc|jzmj27|jzmj8ys|zjzmjds|csje|beizhu|xmmc|mjyj|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xmxxbService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 划分查询
	 * @throws Exception
	 */
	public void listhf() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("hfsz", "0");
		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != xmxxb)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getXmlsh()) && (0 < xmxxb.getXmlsh().trim().length()))
			{
				paraMap.put("xmlsh", "%" + xmxxb.getXmlsh().trim() + "%");
			}

			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length()))
			{
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}

			if ((null != xmxxb.getXmbh()) && (0 < xmxxb.getXmbh().trim().length()))
			{
				paraMap.put("xmbh", "%" + xmxxb.getXmbh().trim() + "%");
			}

			if ((null != xmxxb.getSlbh()) && (0 < xmxxb.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + xmxxb.getSlbh().trim() + "%");
			}

			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length()))
			{
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}

			if ((null != xmxxb.getDwbh()) && (0 < xmxxb.getDwbh().trim().length()))
			{
				paraMap.put("dwbh", "%" + xmxxb.getDwbh().trim() + "%");
			}

			if ((null != xmxxb.getXmmc()) && (0 < xmxxb.getXmmc().trim().length()))
			{
				paraMap.put("xmmc", "%" + xmxxb.getXmmc().trim() + "%");
			}
			if ((null != xmxxb.getJbcs()) && (0 < xmxxb.getJbcs().trim().length()))
			{
				paraMap.put("jbcs", "%" + xmxxb.getJbcs().trim() + "%");
			}
			if ((null != xmxxb.getJsdd()) && (0 < xmxxb.getJsdd().trim().length()))
			{
				paraMap.put("jsdd", "%" + xmxxb.getJsdd().trim() + "%");
			}

			if ((null != xmxxb.getLianxiren()) && (0 < xmxxb.getLianxiren().trim().length()))
			{
				paraMap.put("lianxiren", "%" + xmxxb.getLianxiren().trim() + "%");
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|gzlbh|slbh|xmlsh|xxylb|xmbh|jsdw|dwbh|jbcs|czgs|bllb|ckbh|lsck|zjdyjks|zsdw|zsfw|issdxm|lianxiren|xkzh|jzmjdx|jzmjdc|jzmj27|jzmj8ys|zjzmjds|csje|hfsbz|xmmc|jsdd|createTime|createUserID|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xmxxbService.findByPagehf(pagination, paraMap);
		List ls=pagination.getList();
		List<Xmxxb> newList=new ArrayList<Xmxxb>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");	
		for (Object object : ls) {
			Xmxxb xm=(Xmxxb)object;
			User u=userService.findUserById(xm.getCreateUserID());
			String uname="";
			if(null!=u){
				uname=u.getDisplayName();
				xm.setCreateUserID(uname);
			}
			newList.add(xm);
		}
		pagination.setList(newList);
		convObjectToJson(pagination, config);
	}

	/**
	 * 工作流业务查询
	 * @throws Exception
	 */
	public void listgzl() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != xmxxb)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件

			if ((null != xmxxb.getId()) && (0 < xmxxb.getId().trim().length()))
			{
				paraMap.put("ids", xmxxb.getId().trim());
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		// 政策类别
		codeMap.put("zclb", "40288044571c5a4a01571c6016440011");
		// 面积依据
		codeMap.put("mjyj", "40288044571c5a4a01571c5c82d40008");
		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|slbh|xmlsh|xxylb|jsdw|jbcs|zsdw|zsfw|bllb|ckbh|lsck|lianxiren|xkzh|zjsmj|csmj|zclb|mjyj|zjdyjks|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xmxxbService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{
		if ((null != xmxxb) && (null != xmxxb.getId()))
		{
			List<Hsdmj2> dmjList = new ArrayList<Hsdmj2>();
			xmxxb = xmxxbService.getById(xmxxb.getId());
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("slbh", xmxxb.getSlbh());
			List<Hsdmj> hsdmjs = hsdmjService.query(map);
			for (Hsdmj hsdmj : hsdmjs)
			{
				Map<String, Object> param = new HashMap<String, Object>();
				param.put("dmjzj", hsdmj.getId());
				List<Hscmj> hscmjs = hscmjService.query(param);
//				System.out.println("cmj.size:" + hscmjs.size());
				Hsdmj2 dmj = new Hsdmj2();
				BeanUtils.copyProperties(hsdmj, dmj);
				dmj.setHscmjs(hscmjs);
				dmjList.add(dmj);
			}
//			System.out.println("dmjList.size:" + dmjList.size());s
			setRequestAttribute("dmjList", dmjList);
			Map<String, String> paramMapt = new HashMap<String, String>();
			paramMapt.put("bizrowid", xmxxb.getId());
			paramMapt.put("xmTypecad", "CAD%");
			attach = fawenAttachService.queryAttachListByTempleId(paramMapt);
			this.setRequestAttribute("attach", attach);
			
		}

		return VIEW;
	}

	public String viewa() throws Exception
	{
		if ((null != xmxxb) && (null != xmxxb.getId()))
		{
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", xmxxb.getId());
			List<Xmxxb> lx = xmxxbService.findXmxxb(paraMap);
			if (lx.size() > 0)
			{
				xmxxb = lx.get(0);
			}
		}
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		view();
		return EDIT;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit1() throws Exception
	{
		view();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception
	{
		FileInputStream in = null;
		try
		{
			// 设置Blob字段
			setBlobField(in);
		} finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				} catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag))
		{
			xmxxb.setDeptId(this.getLoginUserDepartmentId());
			xmxxb.setDelFlag(0);
			xmxxbService.save(xmxxb);
		}
		else
		{
			xmxxbService.update(xmxxb);
		}

		return RELOAD;
	}

	/**
	 * 项目划分
	 * @return
	 * @throws Exception
	 */
	public String savehf() throws Exception
	{
		try
		{
			Xmxxb x = new Xmxxb();
			List<Xmhf> listxmhf = new ArrayList<Xmhf>();
			if ((null != xmbid) && (null != xmbid))
			{
				x = xmxxbService.getById(xmbid);
				// 判断是新建,还是退回后修改
				Map<String, Object> paraMap = new HashMap<String, Object>();
				paraMap.put("xmxxbzj", "%" + xmbid + "%");
				listxmhf = xmhfService.findXmhf(paraMap);
			}
			x.setXkzh(StringUtil.isEmpty(x.getXkzh())?flag:x.getXkzh() );
			x.setLxpw(StringUtil.isEmpty(x.getLxpw())?slzt:x.getLxpw() );

			// 划分执收单位
			Map<String, Object> hf = new HashMap<String, Object>();
			hf.put("zsdm", "%" + dwdm + "%");
			List<Zsdw> listzsd = zsdwService.findZsdw(hf);
			Xmhf xmhf;
			if (listxmhf.size() > 0)
			{
				xmhf = listxmhf.get(0);
				xmhf.setJbrid(this.getLoginUserId());
				xmhf.setXmjbr(this.getLoginUser().getDisplayName());
				xmhf.setJbsj(new Date());
				xmhf.setDwdm(dwdm);
				if (listzsd != null && listzsd.size() > 0)
				{
					xmhf.setHfzsdw(listzsd.get(0).getZsdw());
				}
				// xmhf.setBxzd1(x.getZsfw());
				// 经办意见
				// String a=this.getRequest().getParameter("jbyj");
				// String jbyijian=new String(a.getBytes("ISO8859-1"),"UTF-8");
				xmhf.setJbbz(comment);
				// 划分经办
				xmhf.setStarts("0");
				xmhfService.update(xmhf);
				// 0:批量导入时先建项目信息表时状态,1:划分经办,2:划分复核,9:手动导入
				x.setHfsz("1");
				xmxxbService.update(x);
			}
			if (listxmhf.size() == 0)
			{
				xmhf = new Xmhf();
				xmhf.setXmxxbzj(x.getId());
				xmhf.setJbrid(this.getLoginUserId());
				xmhf.setXmjbr(this.getLoginUser().getDisplayName());
				xmhf.setJbsj(new Date());
				xmhf.setDwdm(dwdm);

				if (listzsd != null && listzsd.size() > 0)
				{
					xmhf.setHfzsdw(listzsd.get(0).getZsdw());
				}
				// 征收范围
				// xmhf.setBxzd1(xmxxb.getZsfw());
				// 经办意见
				// String a=this.getRequest().getParameter("jbyj");
				// String jbyijian=new String(a.getBytes("ISO8859-1"),"UTF-8");
				xmhf.setJbbz(comment);
				// 划分经办
				xmhf.setStarts("0");
				xmhfService.save(xmhf);
				// 0:批量导入时先建项目信息表时状态,1:划分经办,2:划分复核,9:手动导入
				x.setHfsz("1");
				xmxxbService.update(x);
			}
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;

	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != xmxxb)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到xmxxb中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	public String fjsh() throws Exception
	{
		try
		{
			Map<String, String> paraMap = new HashMap<String, String>();
			paraMap.put("xmType", "缴费初审");
			paraMap.put("bizrowid", taskId);

			List<FawenAttach> lfa = fawenAttachService.queryAttachListByTempleId(paraMap);
			if (lfa.size() > 0)
			{
				this.getResponse().getWriter().println("{\"result\":true}");
			}
			else
			{
				this.getResponse().getWriter().println("{\"result\":false}");
			}
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	/**
	 * 初始状态查询
	 * @throws Exception
	 */
	public void csztcxlist() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
		{
			pagination = new Pagination(this.getRequest());
		}
		// List<String> a=new ArrayList<String>();
		// a.add(0, "5");
		// a.add(1, "4");
		// a.add(2, "6");
		//// 4:正常数字预审,6:未确定项目,5手动建档
		// paraMap.put("hfszz", a);
//		if (!this.getLoginUser().getIsSuperAdmin())
//		{
////			List<String> b = new ArrayList<String>();
//			String dwdma = "";
//			dwdma = zsdwService.getDwdm(this.getLoginUserDepartmentId());
////			b.add(0, dwdma);
////			b.add(1, "wqr");
//			// 未确认和本部门的项目
//			if(!"sf".equals(dwdma)){
//				paraMap.put("dwdm", dwdma);
//			}
//		}
		// 流程监控未启动0
//		paraMap.put("lcjk", "0");
		if (null != xmxxb)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmxxb.getXmlsh()) && (0 < xmxxb.getXmlsh().trim().length()))
			{
				paraMap.put("xmlsh", "%" + xmxxb.getXmlsh().trim() + "%");
			}

			if ((null != xmxxb.getXxylb()) && (0 < xmxxb.getXxylb().trim().length()))
			{
				paraMap.put("xxylb", "%" + xmxxb.getXxylb().trim() + "%");
			}

			if ((null != xmxxb.getXmbh()) && (0 < xmxxb.getXmbh().trim().length()))
			{
				paraMap.put("xmbh", "%" + xmxxb.getXmbh().trim() + "%");
			}
			if ((null != xmxxb.getJbcs()) && (0 < xmxxb.getJbcs().trim().length()))
			{
				paraMap.put("jbcss", "%" + xmxxb.getJbcs().trim() + "%");
			}

			if ((null != xmxxb.getSlbh()) && (0 < xmxxb.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + xmxxb.getSlbh().trim() + "%");
			}

			if ((null != xmxxb.getJsdw()) && (0 < xmxxb.getJsdw().trim().length()))
			{
				paraMap.put("jsdw", "%" + xmxxb.getJsdw().trim() + "%");
			}

			if ((null != xmxxb.getDwbh()) && (0 < xmxxb.getDwbh().trim().length()))
			{
				paraMap.put("dwbh", "%" + xmxxb.getDwbh().trim() + "%");
			}

			if ((null != xmxxb.getXmmc()) && (0 < xmxxb.getXmmc().trim().length()))
			{
				paraMap.put("xmmc", "%" + xmxxb.getXmmc().trim() + "%");
			}

			if ((null != xmxxb.getLianxiren()) && (0 < xmxxb.getLianxiren().trim().length()))
			{
				paraMap.put("lianxiren", "%" + xmxxb.getLianxiren().trim() + "%");
			}
			if (null != querySlsjStart)
			{
				paraMap.put("qst", querySlsjStart);
			}
			
			if (null != querySlsjEnd)
			{
				paraMap.put("qend", querySlsjEnd);
			}

		}
		if(null!=slzt){
			if("1".equals(slzt)){
				paraMap.put("declare", "1");
				
			}
			if("2".equals(slzt)){
				paraMap.put("isDeclare", "2");
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|gzlbh|slbh|xmlsh|hfsz|xxylb|jsdw|czgs|bllb|ghspsj|ckbh|lsck|zjdyjks|zsdw|zsfw|issdxm|lianxiren|xkzh|xmmc|csje|jsdd|mjyj|beizhu|jbcs|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xmxxbService.findByPage2(pagination, paraMap);
//		List<Xmxxb> lxms=pagination.list;
//		if(null!=lxms&&lxms.size()>0){
//			for (Xmxxb xb : lxms) {
//				if(null!=xb.getBeizhu()&&!"".equals(xb.getBeizhu())&&xb.getBeizhu().length()>=13){
//					xb.setBeizhu(xb.getBeizhu().substring(xb.getBeizhu().length()-13));
//				}
//			}
//			
//		}
//		
		convObjectToJson(pagination, config);
	}

	/**
	 * 初始详细信息
	 */
	public String jfslview1() throws Exception
	{
		if ((null != xmxxb) && (null != xmxxb.getId())){
			xmxxb = xmxxbService.getById(xmxxb.getId());
		}
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("xmxxbzj", xmxxb.getId());
		List<Xmhf> lx=xmhfService.findXmhf(paraMap);
		List<Szys> ls=szysService.findSzys(paraMap);
		
		Map<String, Object> paraMap1 = new HashMap<String, Object>();
			paraMap1.put("xxbbh", "%" + xmxxb.getXxylb().trim() + "%");
			List<Sdjd> lsd=sdjdService.findSdjd(paraMap1);
		if(lx.size()>0){
			xmhf=lx.get(0);
		}
		if(ls.size()>0){
			szys=ls.get(0);
		}
		if(lsd.size()>0){
			sdjd=lsd.get(0);
			User cu=userService.findUserById(sdjd.getCreateUserID());
			User uu=userService.findUserById(sdjd.getUpdateUserID());
			String cuname="";
			String uuname="";
            if(null!=cu){
            	cuname=cu.getDisplayName();
            }
            if(null!=uu){
            	uuname=uu.getDisplayName();
            }
			sdjd.setCreateUserID(cuname);
			sdjd.setUpdateUserID(uuname);
		}	

		List<Wwsqys> listww = wwsqysService.findxxylb(xmxxb.getXxylb());
		if(CollectionUtils.isNotEmpty(listww))
		{
		  HttpServletRequest request = Struts2Util.getRequest();
		  Wwsqys w = listww.get(0);

		  request.setAttribute("wwjbr",w.getWwjbr());
		  request.setAttribute("wwjbsj",w.getWwjbsj());
		  request.setAttribute("wwjbyj",w.getWwjbyj());
		  request.setAttribute("wwfhr", w.getWwfhr());
		  request.setAttribute("wwfhsj", w.getWwfhsj());
		  request.setAttribute("wwfhyj",w.getWwfhyj());

		}

		return VIEW;
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			xmxxbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	/**
	 * 删除信息(信息表,导入表,划分表)
	 */
	public String deletesc() throws Exception
	{
		try
		{
			Xmxxb lxmxxb=xmxxbService.getById(ids);
			if(null!=lxmxxb){
				
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("xmxxbzj", lxmxxb.getId());
			List<Xmhf> lh=xmhfService.findXmhf(paraMap);
			   if(lh.size()>0){
				   String [] hfid=new String[lh.size()];
					hfid[0]=lh.get(0).getId();
					xmhfService.delete(hfid);
			   }
			Map<String, Object> paraMap1 = new HashMap<String, Object>();
			paraMap1.put("xxbbh", lxmxxb.getXxylb());
			List<Xmdrb> lx= xmdrbService.findXmdrb(paraMap1);
                if(lx.size()>0){
                	String [] drbid=new String[lx.size()];
                	for (int i = 0; i < lx.size(); i++) {
						drbid[i]=lx.get(i).getId();
					}
                	xmdrbService.delete(drbid);
                }   	
			
			
					String[]b=new String[1];
					b[0]=lxmxxb.getId();
					xmxxbService.delete(b);
			}
				
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Xmxxb getXmxxb()
	{
		return this.xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb)
	{
		this.xmxxb = xmxxb;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

	public String getTaskId()
	{
		return taskId;
	}

	public void setTaskId(String taskId)
	{
		this.taskId = taskId;
	}

	public String getComment()
	{
		return comment;
	}

	public void setComment(String comment)
	{
		this.comment = comment;
	}

	public String getXmbid()
	{
		return xmbid;
	}

	public void setXmbid(String xmbid)
	{
		this.xmbid = xmbid;
	}

	public String getDwdm()
	{
		return dwdm;
	}

	public void setDwdm(String dwdm)
	{
		this.dwdm = dwdm;
	}

	public Xmhf getXmhf() {
		return xmhf;
	}

	public void setXmhf(Xmhf xmhf) {
		this.xmhf = xmhf;
	}

	public Szys getSzys() {
		return szys;
	}

	public void setSzys(Szys szys) {
		this.szys = szys;
	}

	public Sdjd getSdjd() {
		return sdjd;
	}

	public void setSdjd(Sdjd sdjd) {
		this.sdjd = sdjd;
	}

	public Date getQuerySlsjStart() {
		return querySlsjStart;
	}

	public void setQuerySlsjStart(Date querySlsjStart) {
		this.querySlsjStart = querySlsjStart;
	}

	public Date getQuerySlsjEnd() {
		return querySlsjEnd;
	}

	public void setQuerySlsjEnd(Date querySlsjEnd) {
		this.querySlsjEnd = querySlsjEnd;
	}

	public String getSlzt() {
		return slzt;
	}

	public void setSlzt(String slzt) {
		this.slzt = slzt;
	}
    
	
}
