package com.jshx.xmxxb.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmxxb.dao.XmxxbDao;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;

@Service("xmxxbService")
public class XmxxbServiceImpl extends BaseServiceImpl implements XmxxbService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("xmxxbDao")
	private XmxxbDao xmxxbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return xmxxbDao.findByPage(page, paraMap);
	}
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap)
	{
		return xmxxbDao.findByPage1(page, paraMap);
	}
	public Pagination findByPage2(Pagination page, Map<String, Object> paraMap)
	{
		return xmxxbDao.findByPage2(page, paraMap);
	}
	public Pagination findByPagehf(Pagination page, Map<String, Object> paraMap)
	{
		return xmxxbDao.findByPagehf(page, paraMap);
	}
	public List findXmxxb( Map<String, Object> paraMap)
	{
		return xmxxbDao.findXmxxb(paraMap);
	}
	@Override
	public Pagination findgdXmxxb(Pagination page, Map<String, Object> paraMap) {
		return xmxxbDao.findgdXmxxb(page, paraMap);
	}
	@Override
	public Pagination findXmxxbxg(Pagination page, Map<String, Object> paraMap) {
		return xmxxbDao.findXmxxbxg(page, paraMap);
	}
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	@Transactional
	public Xmxxb getById(String id)
	{
		return xmxxbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Xmxxb xmxxb)
	{
		xmxxbDao.save(xmxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Xmxxb xmxxb)
	{
		xmxxbDao.update(xmxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=xmxxbDao.findXmxxb(paraMap);
		
		xmxxbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    xmxxbDao.deleteWithFlag(id);
			}
		}
	}
	@Override
	public Xmxxb getBySlbh(String slbh) {
		Map<String, String> paraMap = new HashMap<String, String>();
		paraMap.put("slbh", slbh);
		Xmxxb xmxxb = (Xmxxb) xmxxbDao.findObjectByFieldsMap(Xmxxb.class, paraMap);
		return xmxxb;
	}
	@Override
	public Xmxxb getByXxylb(String xxylb) {
		Map<String, String> paraMap = new HashMap<String, String>();
		paraMap.put("xxylb", xxylb);
		Xmxxb xmxxb = (Xmxxb) xmxxbDao.findObjectByFieldsMap(Xmxxb.class, paraMap);
		return xmxxb;
	}
	


}
