package com.jshx.xmxxb.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmxxb.entity.Xmxxb;

public interface XmxxbService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap);
	public Pagination findByPage2(Pagination page, Map<String, Object> paraMap);
	public Pagination findByPagehf(Pagination page, Map<String, Object> paraMap);
	public List findXmxxb(Map<String, Object> paraMap);
	public Pagination findgdXmxxb(Pagination page,Map<String, Object> paraMap);
	public Pagination findXmxxbxg(Pagination page,Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xmxxb getById(String id);
	public Xmxxb getBySlbh(String slbh);
	public Xmxxb getByXxylb(String xxylb);
	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Xmxxb model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Xmxxb model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
}
