package com.jshx.xmhf.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmhf.dao.XmhfDao;
import com.jshx.xmhf.entity.Xmhf;
import com.jshx.xmhf.service.XmhfService;

@Service("xmhfService")
public class XmhfServiceImpl extends BaseServiceImpl implements XmhfService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("xmhfDao")
	private XmhfDao xmhfDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return xmhfDao.findByPage(page, paraMap);
	}
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap)
	{
		return xmhfDao.findByPage1(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xmhf getById(String id)
	{
		return xmhfDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Xmhf xmhf)
	{
		xmhfDao.save(xmhf);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Xmhf xmhf)
	{
		xmhfDao.update(xmhf);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=xmhfDao.findXmhf(paraMap);
		
		xmhfDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    xmhfDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Xmhf> findXmhf(Map<String, Object> paraMap) {
		return xmhfDao.findXmhf(paraMap);
	}
}
