package com.jshx.xmhf.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmhf.entity.Xmhf;
import com.jshx.xmhf.dao.XmhfDao;

@Component("xmhfDao")
public class XmhfDaoImpl extends BaseDaoImpl implements XmhfDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findXmhfByMap", paraMap, page);
	}
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap)
	{
//		return this.findPageByHqlId("findXmhfByMap", paraMap, page);
		return this.findPageBySqlIdReturnMap("findXmhfByMap1", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findXmhf(Map<String, Object> paraMap){
		return this.findListByHqlId("findXmhfByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xmhf getById(String id)
	{
		return (Xmhf)this.getObjectById(Xmhf.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Xmhf xmhf)
	{
		xmhf.setId(null);
		this.saveOrUpdateObject(xmhf);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Xmhf xmhf)
	{
		this.saveOrUpdateObject(xmhf);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Xmhf.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Xmhf xmhf = (Xmhf)this.getObjectById(Xmhf.class, id);
		xmhf.setDelFlag(1);
		this.saveObject(xmhf);
	}
}
