package com.jshx.xmdrb.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletResponse;

import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.util.CollectionUtil;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.common.utils.Constant;
import com.jshx.common.utils.ValidUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.jsdwinfo.entity.Jsdwinfo;
import com.jshx.jsdwinfo.service.JsdwinfoService;
import com.jshx.module.admin.entity.CodeValue;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.CodeService;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.sdjd.entity.Sdjd;
import com.jshx.sdjd.service.SdjdService;
import com.jshx.szys.entity.Szys;
import com.jshx.szys.service.SzysService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.xmdrb.entity.Xmdrb;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmdrb.service.XmdrbService;
import com.jshx.xmhf.entity.Xmhf;
import com.jshx.xmhf.service.XmhfService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;

import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Sheet;
import jxl.Workbook;

public class XmdrbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Xmdrb xmdrb = new Xmdrb();
	private Xmhf xmhf=new Xmhf();
    private Szys szys=new Szys();
    private Sdjd sdjd=new Sdjd();
	private String excel_Name ;
	public String getExcel_Name() {
		return excel_Name;
	}

	public void setExcel_Name(String excel_Name) {
		this.excel_Name = excel_Name;
	}
   private String xxbbh;
   
   
	public String getXxbbh() {
	return xxbbh;
}

public void setXxbbh(String xxbbh) {
	this.xxbbh = xxbbh;
}
	/**
	 * 业务类
	 */
	@Autowired
	private XmdrbService xmdrbService;
	@Autowired
	private XmhfService xmhfService;
	@Autowired
    private  CodeService codeService;
	@Autowired
	private JsdwinfoService jsdwinfoService;
	@Autowired
	private GenericManager genericManager;
	@Autowired
	private XmxxbService xmxxbService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    protected RuntimeService runtimeService;
	@Autowired
	private SzysService szysService;
	@Autowired
	private SdjdService sdjdService;
	@Autowired
	private UserService userService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	private File importFile;
	
	public File getImportFile() {
		return importFile;
	}

	public void setImportFile(File importFile) {
		this.importFile = importFile;
	}
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != xmdrb){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmdrb.getXmbh()) && (0 < xmdrb.getXmbh().trim().length())){
				paraMap.put("xmbh", "%" + xmdrb.getXmbh().trim() + "%");
			}

			if ((null != xmdrb.getJsdw()) && (0 < xmdrb.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + xmdrb.getJsdw().trim() + "%");
			}

			if ((null != xmdrb.getDwbm()) && (0 < xmdrb.getDwbm().trim().length())){
				paraMap.put("dwbm", "%" + xmdrb.getDwbm().trim() + "%");
			}

			if ((null != xmdrb.getLxr()) && (0 < xmdrb.getLxr().trim().length())){
				paraMap.put("lxr", "%" + xmdrb.getLxr().trim() + "%");
			}

			if ((null != xmdrb.getXmmc()) && (0 < xmdrb.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + xmdrb.getXmmc().trim() + "%");
			}
			if ((null != xmdrb.getXxbbh()) && (0 < xmdrb.getXxbbh().trim().length())){
				paraMap.put("xxbbh", "%" + xmdrb.getXxbbh().trim() + "%");
			}
			if ((null != xmdrb.getStarts()) && (0 < xmdrb.getStarts().trim().length())){
				paraMap.put("starts", "%" + xmdrb.getStarts().trim() + "%");
			}
			if ((null != xmdrb.getJbcs()) && (0 < xmdrb.getJbcs().trim().length())){
				paraMap.put("jbcs", "%" + xmdrb.getJbcs().trim() + "%");
			}
		}
//		String a=this.getRequest().getParameter("xxbbh");
//		if(null!=a&&!"".equals(a)){
//			String jbyijian=new String(a.getBytes("ISO8859-1"),"UTF-8");
//			paraMap.put("xxbbh", "%" + jbyijian + "%");
//		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|lxr|lxdh|jsdd|xkzh|gcmc|jzcsds|jzcsdx|xmbh|jsdw|dwbm|zjzmj|jbcs|xxbbh|xmdm|xklx|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = xmdrbService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list1() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		
		if(pagination==null)
			pagination = new Pagination(this.getRequest());
		
		if(null != xmdrb){
			//设置查询条件，开发人员可以在此增加过滤条件
			if ((null != xmdrb.getXmbh()) && (0 < xmdrb.getXmbh().trim().length())){
				paraMap.put("xmbh", "%" + xmdrb.getXmbh().trim() + "%");
			}
			
			if ((null != xmdrb.getJsdw()) && (0 < xmdrb.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + xmdrb.getJsdw().trim() + "%");
			}
			
			if ((null != xmdrb.getDwbm()) && (0 < xmdrb.getDwbm().trim().length())){
				paraMap.put("dwbm", "%" + xmdrb.getDwbm().trim() + "%");
			}
			
			if ((null != xmdrb.getLxr()) && (0 < xmdrb.getLxr().trim().length())){
				paraMap.put("lxr", "%" + xmdrb.getLxr().trim() + "%");
			}
			
			if ((null != xmdrb.getXmmc()) && (0 < xmdrb.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + xmdrb.getXmmc().trim() + "%");
			}
			if ((null != xmdrb.getXxbbh()) && (0 < xmdrb.getXxbbh().trim().length())){
				paraMap.put("xxbbh", "%" + xmdrb.getXxbbh().trim() + "%");
			}
			if ((null != xmdrb.getStarts()) && (0 < xmdrb.getStarts().trim().length())){
				paraMap.put("starts", "%" + xmdrb.getStarts().trim() + "%");
			}
		}
//		String a=this.getRequest().getParameter("xxbbh");
//		if(null!=a&&!"".equals(a)){
//			String jbyijian=new String(a.getBytes("ISO8859-1"),"UTF-8");
//			paraMap.put("xxbbh", "%" + jbyijian + "%");
//		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|lxr|lxdh|jsdd|xkzh|gcmc|jzcsds|jzcsdx|xmbh|jsdw|dwbm|zjzmj|zyjzxz|jzmjds|jzmjdc|jzmj27|jsmj8ys|jzmjdx|xmdm|xklx|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination.setPageSize(30);
		pagination = xmdrbService.findByPage(pagination, paraMap);
		if(pagination.getList().size()>0){
			Map<String, Object> paraMap2 = new HashMap<String, Object>();
			paraMap2.put("xxylb", xmdrb.getXxbbh());
			List<Xmxxb> listxmxxb =xmxxbService.findXmxxb(paraMap2);
			if(listxmxxb.size()>0){
				Xmdrb a=new Xmdrb();
				a.setGcmc("合计");
				a.setJzmjds(listxmxxb.get(0).getZjzmjds());
				a.setJzmjdc(listxmxxb.get(0).getJzmjdc());
				a.setJzmj27(listxmxxb.get(0).getJzmj27());
				a.setJsmj8ys(listxmxxb.get(0).getJzmj8ys());
				a.setJzmjdx(listxmxxb.get(0).getJzmjdx());
//				this.setRequestAttribute("xmxxb", a);
			   pagination.list.add(a);
			}
		}
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != xmdrb)&&(null != xmdrb.getId()))
			xmdrb = xmdrbService.getById(xmdrb.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 删除信息(信息表,导入表,划分表,数字预审表)
	 */
	public String xmxxbDelscsz() throws Exception
	{
		try
		{
			Xmxxb lxmxxb=xmxxbService.getById(ids);
			if(null!=lxmxxb){

				Map<String, Object> paraMap = new HashMap<String, Object>();
				paraMap.put("xmxxbzj", lxmxxb.getId());
				List<Xmhf> lh=xmhfService.findXmhf(paraMap);
				if(lh.size()>0){
					String [] hfid=new String[lh.size()];
					hfid[0]=lh.get(0).getId();
					xmhfService.delete(hfid);
				}
				Map<String, Object> paraMap1 = new HashMap<String, Object>();
				paraMap1.put("xxbbh", lxmxxb.getXxylb());
				List<Xmdrb> lx= xmdrbService.findXmdrb(paraMap1);
				if(lx.size()>0){
					String [] drbid=new String[lx.size()];
					for (int i = 0; i < lx.size(); i++) {
						drbid[i]=lx.get(i).getId();
					}
					xmdrbService.delete(drbid);
				}
				Map<String, Object> paraMap2 = new HashMap<String, Object>();
				paraMap2.put("xmxxbzj", lxmxxb.getId());
				List<Szys> szys= szysService.findSzys(paraMap2);
				if(CollectionUtils.isNotEmpty(szys)){
					String [] szyss=new String[szys.size()];
					for (int i = 0; i < szys.size(); i++) {
						szyss[i]=szys.get(i).getId();
					}
					szysService.delete(szyss);
				}

				String[]b=new String[1];
				b[0]=lxmxxb.getId();
				xmxxbService.delete(b);
			}

			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	/**
	 * 初始化修改信息
	 */
	public String qzhi() throws Exception{
		Map<String, Object> paraMap2 = new HashMap<String, Object>();
		paraMap2.put("xxylb", xxbbh);
		List<Xmxxb> listxmxxb =xmxxbService.findXmxxb(paraMap2);
		if(listxmxxb.size()>0){
			Map<String, Object> paraMap1 = new HashMap<String, Object>();
			paraMap1.put("xmxxbzj",listxmxxb.get(0).getId());
      List<Xmhf> lxmhfs=xmhfService.findXmhf(paraMap1);
      if(lxmhfs.size()>0){
    	  this.getRequest().setAttribute("xmhf", lxmhfs.get(0));
      }
		   this.getRequest().setAttribute("xmb", listxmxxb.get(0));
		}
		return "success";
	}
	public String qzhitt() throws Exception{
		Map<String, Object> paraMap2 = new HashMap<String, Object>();
		paraMap2.put("xxylb", xxbbh);
		List<Xmxxb> listxmxxb =xmxxbService.findXmxxb(paraMap2);
		if(listxmxxb.size()>0){
			this.getRequest().setAttribute("xmb", listxmxxb.get(0));
			Map<String, Object> paraMap= new HashMap<String, Object>();
			paraMap.put("xmxxbzj", listxmxxb.get(0).getId().trim());
			List<Xmhf> lhf=xmhfService.findXmhf(paraMap);
			if(lhf.size()>0){
				this.getRequest().setAttribute("xmhf", lhf.get(0));
			}
		}
		return "success";
	}
	public String qzhifh() throws Exception{
		Map<String, Object> paraMap2 = new HashMap<String, Object>();
		paraMap2.put("xxylb", xxbbh);
		List<Xmxxb> listxmxxb =xmxxbService.findXmxxb(paraMap2);
		if(listxmxxb.size()>0){
			this.getRequest().setAttribute("xmb", listxmxxb.get(0));
			Map<String, Object> paraMap3= new HashMap<String, Object>();
			paraMap3.put("xmxxbzj", listxmxxb.get(0).getId());
			List<Szys> lsz =szysService.findSzys(paraMap3);
			if(lsz.size()>0){
				this.getRequest().setAttribute("szys", lsz.get(0));
			}
		}
		return "success";
	}
	//缴费受理查看
	public String qzhifhjs() throws Exception{
		Map<String, Object> paraMap2 = new HashMap<String, Object>();
		paraMap2.put("xxylb", xxbbh);
		List<Xmxxb> listxmxxb =xmxxbService.findXmxxb(paraMap2);
		if(listxmxxb.size()>0){
			Xmxxb xmxxb =listxmxxb.get(0);
			
			if ((null != xmxxb) && (null != xmxxb.getId())){
				xmxxb = xmxxbService.getById(xmxxb.getId());
			}
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("xmxxbzj", xmxxb.getId());
			List<Xmhf> lx=xmhfService.findXmhf(paraMap);
			List<Szys> ls=szysService.findSzys(paraMap);
			
			Map<String, Object> paraMap1 = new HashMap<String, Object>();
				paraMap1.put("xxbbh", "%" + xmxxb.getXxylb().trim() + "%");
				List<Sdjd> lsd=sdjdService.findSdjd(paraMap1);
			if(lx.size()>0){
				xmhf=lx.get(0);
			}
			if(ls.size()>0){
				szys=ls.get(0);
			}
			if(lsd.size()>0){
				sdjd=lsd.get(0);
				User cu=userService.findUserById(sdjd.getCreateUserID());
				User uu=userService.findUserById(sdjd.getUpdateUserID());
				String cuname="";
				String uuname="";
	            if(null!=cu){
	            	cuname=cu.getDisplayName();
	            }
	            if(null!=uu){
	            	uuname=uu.getDisplayName();
	            }
				sdjd.setCreateUserID(cuname);
				sdjd.setUpdateUserID(uuname);
			}	
				
			
			this.getRequest().setAttribute("xmb", listxmxxb.get(0));
			Map<String, Object> paraMap3= new HashMap<String, Object>();
			paraMap3.put("xmxxbzj", listxmxxb.get(0).getId());
			List<Szys> lsz =szysService.findSzys(paraMap3);
			if(lsz.size()>0){
				this.getRequest().setAttribute("szys", lsz.get(0));
			}
		}
		return "success";
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			xmdrb.setDeptId(this.getLoginUserDepartmentId());
			xmdrb.setDelFlag(0);
			xmdrbService.save(xmdrb);
		}else{
			xmdrbService.update(xmdrb);
		}
		
		return RELOAD;
	}

	/**
	 * 导入
	 */
	public String importSomething() {
		return "importSomething";
	}
	public void downloadTemplate()
	 {
		 String excelName = getExcelNameFromProperty(excel_Name);
	     try
	     {
	         excelName = new String(excelName.getBytes("GBK"), "ISO8859-1");
	     }
	     catch (UnsupportedEncodingException e)
	     {
	         excelName = excel_Name;
	     }
	     getResponse().setContentType("application/csv");
	     getResponse().setCharacterEncoding("UTF-8");
	     getResponse().addHeader("Content-Disposition", "attachment;filename=" + excelName);
	     String dir = this.getRequest().getRealPath("") + File.separator + "WEB-INF" + File.separator + "download"
	             + File.separator + excel_Name;
	     java.io.FileInputStream in = null;
	     OutputStream out = null;
	     try
	     {
	         in = new java.io.FileInputStream(dir);
	         out = this.getResponse().getOutputStream();
	         int t = in.read();
	         while (t != -1)
	         {
	             out.write(t);
	             t = in.read();
	         }
	         in.close();
	         out.flush();
	         out.close();
	     }
	     catch (Exception e)
	     {
	    	 e.printStackTrace();
	     }
	     finally
	     {
	         if (null != in)
	         {
	             try
	             {
	                 in.close();
	             }
	             catch (IOException e)
	             {
	            	 e.printStackTrace();
	             }
	         }
	         if (null != out)
	         {
	             try
	             {
	                 out.close();
	             }
	             catch (IOException e)
	             {
	            	 e.printStackTrace();
	             }
	         }
	     }
	 }
	
	/**
	 * 导入excel
	 * @return
	 * @throws Throwable
	 */
	public String importDetail(){
		if (null != importFile) {
			String message = null;
			Workbook workBook = null;
			try {
				try {
					workBook = Workbook.getWorkbook(importFile);
				} catch (Exception e) {
					message = "解析上传文件信息异常,请检查.";
				}

				if (null == workBook) {
					message = "打开上传文件信息失败,请检查.";
				}

				try {
					Sheet[] sheets = workBook.getSheets();
					if (null == sheets || 0 == sheets.length) {
						message = "上传文件工作薄信息为空,请检查.";
					}
					Sheet sheet = sheets[0];
					Cell[] cells;
					long rowCount = ValidUtils.getRealRows(sheet, sheet.getRows(), sheet.getColumns());
					if (rowCount <= 1) {
						message = "上传文件中无数据,请检查.";
					}
					List<Xmdrb> list = new ArrayList<Xmdrb>();
					for (int i = 1; i < rowCount; i++) {
						Xmdrb bean = null;
						cells = sheet.getRow(i);
						if (null == cells || cells.length == 0) {
							continue;
						}
						bean = new Xmdrb();
						bean.setCreateTime(new Date());
						bean.setDeptId(this.getLoginUserDepartmentId());
						bean.setDelFlag(0);
						bean.setId("");
						bean.setCreateUserID("");
						bean.setUpdateUserID("");
						//原始表导入状态,0:导入未划分,1:已整合入项目基础表,2:与已整合的信息编号相同,999:异常代码
						bean.setStarts("0");
						if(null == cells[0] || cells[0].getContents() == null
								|| "".equals(cells[0].getContents().trim())||"null".equalsIgnoreCase(cells[0].getContents().trim())){
							throw new Exception("第" + (i + 1) + "行:项目编号不能为空或NULL!");
						}
						bean.setXmbh(cells[0].getContents().trim());
						
						if(null == cells[1] || cells[1].getContents() == null
								|| "".equals(cells[1].getContents().trim())||"null".equalsIgnoreCase(cells[1].getContents().trim())){
							throw new Exception("第" + (i + 1) + "行:建设单位不能为空或NULL!");
						}
						bean.setJsdw(cells[1].getContents().trim());
						
						if(null == cells[2] || cells[2].getContents() == null
								|| "".equals(cells[2].getContents().trim())||"null".equalsIgnoreCase(cells[2].getContents().trim())){
							throw new Exception("第" + (i + 1) + "行:单位编码不能为空或NULL!");
						}
						bean.setDwbm(cells[2].getContents().trim());
						
						if("null".equalsIgnoreCase(cells[3].getContents().trim())){
							bean.setLxr("");
						}else{
							bean.setLxr(cells[3].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[4].getContents().trim())){
							bean.setLxdh("");
						}else{
							bean.setLxdh(cells[4].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[5].getContents().trim())){
							bean.setXmmc("");
						}else{
							bean.setXmmc(cells[5].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[6].getContents().trim())){
							bean.setJsdd("");
						}else{
							bean.setJsdd(cells[6].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[7].getContents().trim())){
							bean.setXkzh("");
						}else{
							bean.setXkzh(cells[7].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[8].getContents().trim())){
							bean.setGcmc("");
						}else{
							bean.setGcmc(cells[8].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[9].getContents().trim())){
							bean.setZyjzxz("");
						}else{
							bean.setZyjzxz(cells[9].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[10].getContents().trim())){
							bean.setJzcsds("");
						}else{
							bean.setJzcsds(cells[10].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[11].getContents().trim())){
							bean.setJzcsdx("");
						}else{
							bean.setJzcsdx(cells[11].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[12].getContents().trim())){
							bean.setJzmjdx("");
						}else{
							bean.setJzmjdx(cells[12].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[13].getContents().trim())){
							bean.setJzmjdc("");
						}else{
							bean.setJzmjdc(cells[13].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[14].getContents().trim())){
							bean.setJzmj27("");
						}else{
							bean.setJzmj27(cells[14].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[15].getContents().trim())){
							bean.setJsmj8ys("");
						}else{
							bean.setJsmj8ys(cells[15].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[16].getContents().trim())){
							bean.setJzmjds("");
						}else{
							bean.setJzmjds(cells[16].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[17].getContents().trim())){
							bean.setZjzmj("");
						}else{
							bean.setZjzmj(cells[17].getContents().trim());
						}
						
						if(null == cells[18] || cells[18].getContents() == null
								|| "".equals(cells[18].getContents().trim())||"null".equalsIgnoreCase(cells[18].getContents().trim())){
							throw new Exception("第" + (i + 1) + "行:经办处室不能为空或NULL!");
						}
						bean.setJbcs(cells[18].getContents().trim());
						
						if(null == cells[19] || cells[19].getContents() == null
								|| "".equals(cells[19].getContents().trim())||"null".equalsIgnoreCase(cells[19].getContents().trim())){
							throw new Exception("第" + (i + 1) + "行:信息表编号不能为空或NULL!");
						}
						bean.setXxbbh(cells[19].getContents().trim());
						
						
						
						if("null".equalsIgnoreCase(cells[20].getContents().trim())){
							bean.setBeizhu("");
						}else{
							bean.setBeizhu(cells[20].getContents().trim());
						}
						
						if("null".equalsIgnoreCase(cells[21].getContents().trim())){
							bean.setSpsj("");
						}else{
							if(cells[21].getType()==CellType.DATE){
								    DateCell dc = (DateCell)cells[21];
									Date date = dc.getDate();	//获取单元格的date类型
									SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");  
							       bean.setSpsj(sdf.format(date));
							}else{
								bean.setSpsj("");
							}
						}
						// 2019-7-18 start---------------
						if("null".equalsIgnoreCase(cells[22].getContents().trim())){
							bean.setXmdm("");
						}else{
							bean.setXmdm(cells[22].getContents().trim());
						}
						if("null".equalsIgnoreCase(cells[23].getContents().trim())){
							bean.setXklx("");
						}else{
							bean.setXklx(cells[23].getContents().trim());
						}
						// 2019-7-18 end-----------------


						list.add(bean);
					}
					// 批量插入数据，要求数据必须全部满足要求，否则一律不导入。
					
					
					//this.xmdrbService.saveList(list);
					if (null != list && list.size() > 0) {
						boolean fas=false;
						Map<String,Object> paraMap = new HashMap<String,Object>();
						List<Xmxxb> lixxb=xmxxbService.findXmxxb(paraMap);
						for (Xmdrb bean : list) {
						      for (Xmxxb xmxxb : lixxb) {
								if(bean.getXxbbh().equals(xmxxb.getXxylb())){
								fas=true;	
								}
							}
						    if(fas){
						    	bean.setStarts("2");
						    }else{
						    	bean.setStarts("0");
						    }
							bean.setDeptId(this.getLoginUserDepartmentId());
					    	bean.setDelFlag(0);
					    	xmdrbService.save(bean);
					    	fas=false;
						}
					}
					//建立单位信息库
					jldwinfo(list);
					//建立项目
					makexm();
				} catch (Exception ex) {
					message = "出错了！" + ex.getMessage();
				}
			} catch (Exception e) {
				workBook.close();
			}
			if (null != message) {
				this.getRequest().setAttribute("message", message);
			}
			workBook.close();
		} else {
			this.getRequest().setAttribute("message", "获取上传文件信息失败,请重新上传文件.");
		}
		return "reload";
	}
	
	private void makexm() {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		//查询出所有状态为0  导入表中 未分配到项目表中的数据
		paraMap.put("starts", "0");
		List<Xmdrb> list=xmdrbService.findXmdrb(paraMap);
		if(list.size()>0){
		Map<String,List<Xmdrb>> map = new HashMap<String, List<Xmdrb>>();  
        for(Xmdrb s:list){  
            if(map.containsKey(s.getXxbbh())){//  
             map.get(s.getXxbbh()).add(s);  
            }else{  
            	List<Xmdrb> tempList = new ArrayList<Xmdrb>(); 
            	tempList.add(s);  
            	map.put(s.getXxbbh(), tempList);
            }  
        } 
		   String xmlsh="";
        for (List<Xmdrb> listxmd : map.values()) {
        	  String jzmjdx ="0";//建筑面积地下 
        	  String jzmjdc="0";//建筑面积底层 
        	  String jzmj27="0";//建筑面积2至7
        	  String jzmj8ys="0";//建筑面积8以上
        	  String zjzmjds="0";//总建筑面积地上
        	  String zjsmj="0";//总建筑面积
        	  Xmxxb xmb=new Xmxxb();
			  for (Xmdrb bean : listxmd) {
				  if(null!=bean.getJzmjdx()&&!"".equals(bean.getJzmjdx())){
					  jzmjdx=SysPropertiesUtil.add(jzmjdx, bean.getJzmjdx());
				  }
				  if(null!=bean.getJzmjdc()&&!"".equals(bean.getJzmjdc())){
					  jzmjdc=SysPropertiesUtil.add(jzmjdc,bean.getJzmjdc());
				  }
				  if(null!=bean.getJzmj27()&&!"".equals(bean.getJzmj27())){
					  jzmj27=SysPropertiesUtil.add(jzmj27,bean.getJzmj27());
				  }
				  if(null!=bean.getJsmj8ys()&&!"".equals(bean.getJsmj8ys())){
					  jzmj8ys=SysPropertiesUtil.add(jzmj8ys,bean.getJsmj8ys());
				  }
				  if(null!=bean.getJzmjds()&&!"".equals(bean.getJzmjds())){
					  zjzmjds=SysPropertiesUtil.add(zjzmjds,bean.getJzmjds());
				  }
				  if(null!=bean.getZjzmj()&&!"".equals(bean.getZjzmj())){
					  zjsmj=SysPropertiesUtil.add(zjsmj,bean.getZjzmj());
//					  zjsmj=SysPropertiesUtil.add(zjsmj,SysPropertiesUtil.sswr1w(bean.getZjzmj()));
				  }
			}
			  if(null!=listxmd.get(0).getXmbh()&&!"".equals(listxmd.get(0).getXmbh().trim())){
				  xmb.setXmbh(listxmd.get(0).getXmbh());
			  }
			  if(null!=listxmd.get(0).getJsdw()&&!"".equals(listxmd.get(0).getJsdw().trim())){
				  xmb.setJsdw(listxmd.get(0).getJsdw());
			  }
			  if(null!=listxmd.get(0).getDwbm()&&!"".equals(listxmd.get(0).getDwbm().trim())){
				  xmb.setDwbh(listxmd.get(0).getDwbm());
			  }
			  if(null!=listxmd.get(0).getLxr()&&!"".equals(listxmd.get(0).getLxr())){
				  xmb.setLianxiren(listxmd.get(0).getLxr());
			  }
			  if(null!=listxmd.get(0).getLxdh()&&!"".equals(listxmd.get(0).getLxdh().trim())){
				  xmb.setPhone(listxmd.get(0).getLxdh());
			  }
			  if(null!=listxmd.get(0).getXmmc()&&!"".equals(listxmd.get(0).getXmmc().trim())){
				  xmb.setXmmc(listxmd.get(0).getXmmc());
			  }
			  if(null!=listxmd.get(0).getJsdd()&&!"".equals(listxmd.get(0).getJsdd().trim())){
				  xmb.setJsdd(listxmd.get(0).getJsdd());
			  }
			  if(null!=listxmd.get(0).getXkzh()&&!"".equals(listxmd.get(0).getXkzh().trim())){
				  xmb.setXkzh(listxmd.get(0).getXkzh());
			  }
			  if(null!=listxmd.get(0).getJbcs()&&!"".equals(listxmd.get(0).getJbcs().trim())){
				  xmb.setJbcs(listxmd.get(0).getJbcs());
			  }
			  if(null!=listxmd.get(0).getXxbbh()&&!"".equals(listxmd.get(0).getXxbbh().trim())){
				  xmb.setXxylb(listxmd.get(0).getXxbbh());
			  }
			//2019-7-23 start ----------------------------
			// 在生成项目信息表时,填入对应的项目代码(xmdm) → lxpw
			if(null!=listxmd.get(0).getXmdm()&&!"".equals(listxmd.get(0).getXmdm().trim())){
				xmb.setLxpw(listxmd.get(0).getXmdm());
			}

			//2019-7-23 end ------------------------------

			//将审批时间放入备注最后
			  String spsj="";
			  if(null!=listxmd.get(0).getSpsj()&&!"".equals(listxmd.get(0).getSpsj().trim())){
				  spsj=listxmd.get(0).getSpsj();
				  SimpleDateFormat  format=new SimpleDateFormat("yyyy-MM-dd");
				  try {
					  xmb.setGhspsj(format.parse(spsj));
				} catch (ParseException e) {
					 xmb.setGhspsj(new Date());
				}
			  }else{
			    xmb.setGhspsj(new Date());
			  }
			  
			  
			  if(null!=listxmd.get(0).getBeizhu()&&!"".equals(listxmd.get(0).getBeizhu().trim())){
				  xmb.setBeizhu(listxmd.get(0).getBeizhu()+" 审批时间:"+spsj);
			  }else{
				  xmb.setBeizhu(spsj);
			  }
			  if(!jzmjdx.equals("0")){
				  xmb.setJzmjdx(jzmjdx);
			  }
			  if(!jzmjdc.equals("0")){
				  xmb.setJzmjdc(jzmjdc);
			  }
			  if(!jzmj27.equals("0")){
				  xmb.setJzmj27(jzmj27);
			  }
			  if(!jzmj8ys.equals("0")){
				  xmb.setJzmj8ys(jzmj8ys);
			  }
			  if(!zjzmjds.equals("0")){
				  xmb.setZjzmjds(zjzmjds);
			  }
			  if(!zjsmj.equals("0")){
				  
				  xmb.setZjsmj(zjsmj);
				  //获取单位平方的金额
//				  String danjia=SysPropertiesUtil.getProperty("danweijine");
				  String danjia=(String) Constant.CONSTANT_MAP.get("ptf");
				  //建档时预审金额,
				  String tem=SysPropertiesUtil.jinehuoqu(xmb.getZjsmj(), danjia);
				  xmb.setSlmj(tem);
				  xmb.setYsdmj(zjsmj);
			  }
			  xmb.setDeptId(this.getLoginUserDepartmentId());
			  xmb.setDelFlag(0);
			  xmlsh=genericManager.getSN("lsh");
			  xmb.setXmlsh(xmlsh);
			  xmb.setHfsz("0");//待划分数字
			  //面积依据,001规划局,监控流程,未监控0
			  xmb.setMjyj("001");
			  xmb.setLcjk("0");
			  xmb.setIsxmcx("2");
			  xmxxbService.save(xmb);
		   }
            //将项目导入表状态从0改为1
            for (Xmdrb rb : list) {
				rb.setStarts("1");
				//项目流水号
				rb.setJcbzj(xmlsh);
				xmdrbService.update(rb);
			}        
        
       
		}
	}

	
	private void jldwinfo(List<Xmdrb> list) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		if(list.size()>0){
		    //设置查询条件，开发人员可以在此增加过滤条件
			for (Xmdrb xmdrb : list) {
				if((null!=xmdrb.getJsdw())&&(0<xmdrb.getJsdw().trim().length())){
					paraMap.put("dwmc","%"+xmdrb.getJsdw().trim()+"%");
				}
				List li = jsdwinfoService.findJsdwinfo(paraMap);
				if(li.size()==0){
					Jsdwinfo jsdwinfo=new Jsdwinfo();
					jsdwinfo.setDeptId(this.getLoginUserDepartmentId());
					jsdwinfo.setDelFlag(0);
					jsdwinfo.setDwbm(xmdrb.getDwbm());
					jsdwinfo.setDwmc(xmdrb.getJsdw());
					jsdwinfo.setLianxiren(xmdrb.getLxr());
					jsdwinfo.setLxdh(xmdrb.getLxdh());
					jsdwinfoService.save(jsdwinfo);
				}
			}
		}
		
		
	}

	public String getExcelNameFromProperty(String excel_Name) {
		Properties prop = new Properties();
		try {
			// 读取属性文件a.properties
			InputStream in = this.getClass().getClassLoader().getResourceAsStream("com/jshx/common/conf/excel.properties");
			InputStreamReader reader = new InputStreamReader(in,"UTF-8");
			prop.load(reader); // /加载属性列表
			Iterator<String> it = prop.stringPropertyNames().iterator();
			while (it.hasNext()) {
				String key=it.next();
				if(excel_Name.equals(key)){
					return (String)prop.getProperty(key);
				}
			}
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return excel_Name;
	}
	
	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != xmdrb)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到xmdrb中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			xmdrbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Xmdrb getXmdrb(){
		return this.xmdrb;
	}

	public void setXmdrb(Xmdrb xmdrb){
		this.xmdrb = xmdrb;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public Xmhf getXmhf() {
		return xmhf;
	}

	public void setXmhf(Xmhf xmhf) {
		this.xmhf = xmhf;
	}

	public Szys getSzys() {
		return szys;
	}

	public void setSzys(Szys szys) {
		this.szys = szys;
	}

	public Sdjd getSdjd() {
		return sdjd;
	}

	public void setSdjd(Sdjd sdjd) {
		this.sdjd = sdjd;
	}
       
    
}
