package com.jshx.xmdrb.service;

/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2012-2014 Jiangsu Hongxin System Integration Co., Ltd.   */
/*                                                                        */
/* PROPRIETARY RIGHTS of Jiangsu Hongxin are involved in the 　　　　　　 */
/* subject matter of this material.  All manufacturing, reproduction, use,*/
/* and sales rights pertaining to this subject matter are governed by the */
/* license agreement. The recipient of this software implicitly accepts   */
/* the terms of the license.                                              */
/* 本软件文档资料是江苏鸿信公司的资产,任何人士阅读和使用本资料必须获得    */
/* 相应的书面授权,承担保密责任和接受相应的法律约束.                       */
/*                                                                        */
/**************************************************************************/

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.engine.task.TaskQuery;

import com.jshx.core.base.vo.Pagination;

public interface GenericManager<T, PK extends Serializable> {

	public Pagination findByPage(Pagination pagination, Map<String, Object> paraMap);

	public Object findClassById(Class class1, String id);

	public List<T> findListById(Map<String, Object> paraMap);

	public Object findClassByObject(Class class1, String string, String id);

	public Object getObjectByProperty(Class entity, String[] name, Object[] value);

	/**
	 * 返回map类型的list
	 * 
	 * @param paraMap
	 * @return
	 */
	public List<T> findListBySqlId(Map<String, Object> paraMap);

	public Pagination findBySqlId(Pagination pagination, Map<String, Object> paraMap);

	/**
	 * 返回object类型的list
	 * 
	 * @param paraMap
	 * @return
	 */
	public List<T> findListByObject(Map<String, Object> paraMap);

	public void update(T obj);

	public void saveOrUpdate(T obj);

	void deleteWithFlag(Class class1, String ids);

	public void updateByHql(String string);

	public void saveOrUpdateByHql(T obj);

	public void updateByHql(Map paraMap);

	public void updateBySql(Map paraMap);
	public int batchInsertZh(List<String[]> list); 
	/**
	 * 开启工作流
	 * 
	 * @paramkey:为工作流名称
	 * @paramvariables：里面存入message信息与user列表信息
	 */
	public String startProcessInstance(String key, String rowId, String userId, Map<String, Object> variables);

	/**
	 * 获取未签收的任务查询对象
	 * 
	 * @param userId
	 *            用户ID
	 */
	public TaskQuery createUnsignedTaskQuery(String userId, String processDefKey);

	/**
	 * 获取正在处理的任务查询对象
	 * 
	 * @param userId
	 *            用户ID
	 */
	public TaskQuery createTodoTaskQuery(String userId, String processDefKey);

	/**
	 * 获取未经完成的流程实例查询对象
	 * 
	 * @param userId
	 *            用户ID
	 */
	public ProcessInstanceQuery createUnFinishedProcessInstanceQuery(String processDefKey);

	/**
	 * 获取已经完成的流程实例查询对象
	 * 
	 * @param userId
	 *            用户ID
	 */
	public HistoricProcessInstanceQuery createFinishedProcessInstanceQuery(String processDefKey);

	/**
	 * 审批通过
	 * 
	 * @param taskId
	 * @param m
	 */
	public void passProcess(String taskId, String remark, Map<String, Object> variables);

	/**
	 * 动态获取下一步的人员，默认将人员全部发送
	 * 
	 * @param key
	 * @param userTaskId
	 * @param deptCode
	 * @return
	 */
	public List<String> findAllPersons(String staticActiveDefId, String workFlowModelId, String deptCode);

	public List<String> findAllPersons(Map<String, Object> variables);

	public String findAllPersons1(String staticActiveDefId, String workFlowModelId, String deptCode);

	public List<Map<String, Object>> getOutGoingTransNames(String taskId);

	public List<Map<String, Object>> getinstanceDiagram(String taskId);

	public String getTaskFormData(String taskId);

	public void createAttachment(String attachmentType, String taskId, String processInstanceId, String attachmentName,
			String url);

	public void endProcess(String processId);

	public String getTaskName(String id);

	public String getSN(String dm);
	public String getSN();

	public void remove(T a);

	public List<String> getHighLightedFlows(ProcessDefinitionEntity s,
			List<HistoricActivityInstance> historicActivityInstances);

	List<Map<String, Boolean>> getHighLightedActivities(ProcessDefinitionEntity processDefinition,
			List<HistoricActivityInstance> historicActivityInstances);

	public void jump(String targetTaskDefinitionKey, String _processId) throws Exception;

	public String getDays(String defId2);

	public String getSN2();
	public String getslbh(String dwdm);

}
